/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintBuilder;
import com.googlecode.jslint4java.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final String PROGNAME = "jslint";
    private boolean errored = false;
    private JSLint lint = new JSLintBuilder().fromDefault();

    public static void main(String[] args) throws IOException {
        try {
            Main main = new Main();
            List<String> files = main.processOptions(args);
            if (files.size() == 0) {
                main.help();
            }
            for (String file : files) {
                main.lintFile(file);
            }
            System.exit(main.isErrored() ? 1 : 0);
        }
        catch (DieException e) {
            if (e.getMessage() != null) {
                System.err.println("jslint: " + e.getMessage());
            }
            System.exit(e.getCode());
        }
    }

    private Main() throws IOException {
    }

    private void applyOptions(Map<Option, String> options) {
        for (Map.Entry<Option, String> entry : options.entrySet()) {
            String value = entry.getValue();
            try {
                if (value == null) {
                    this.lint.addOption(entry.getKey());
                    continue;
                }
                this.lint.addOption(entry.getKey(), value);
            }
            catch (IllegalArgumentException e) {
                String optName = entry.getKey().getLowerName();
                this.die("--" + optName + ": " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    private void die(String message) {
        throw new DieException(message, 1);
    }

    private void err(String message) {
        System.out.println("jslint:" + message);
        this.setErrored(true);
    }

    private Option getOption(String optName) {
        try {
            return Option.valueOf(optName.toUpperCase(Locale.getDefault()));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void help() {
        this.info("usage: jslint [options] file.js ...");
        String fmt = "  --%-" + Option.maximumNameLength() + "s %s";
        for (Option o : Option.values()) {
            String name = o.getLowerName();
            if (o.getType() != Boolean.class) {
                name = name + "=";
            }
            this.info(String.format(fmt, name, o.getDescription()));
        }
        this.info("");
        this.info(String.format(fmt, "help", "Show this help"));
        this.info(String.format(fmt, "jslint=", "Specify an alternative version of jslint.js"));
        this.info("");
        this.info("using jslint version " + this.lint.getEdition());
        throw new DieException(null, 0);
    }

    private void info(String message) {
        System.out.println(message);
    }

    private boolean isErrored() {
        return this.errored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lintFile(String file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            List<Issue> issues = this.lint.lint(file, reader);
            for (Issue issue : issues) {
                this.err(issue.toString());
            }
        }
        catch (FileNotFoundException e) {
            this.die(file + ": No such file or directory.");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Pair<String, String> parseArgAndValue(String arg) {
        String[] bits = arg.substring(2).split("=", 2);
        if (bits.length == 2) {
            return Pair.of(bits[0], bits[1]);
        }
        return Pair.of(bits[0], null);
    }

    private List<String> processOptions(String[] args) {
        boolean inFiles = false;
        ArrayList<String> files = new ArrayList<String>();
        HashMap<Option, String> options = new HashMap<Option, String>();
        for (String arg : args) {
            Pair<String, String> pair;
            if (inFiles) {
                files.add(arg);
                continue;
            }
            if ("--".equals(arg)) {
                inFiles = true;
                continue;
            }
            if ("--help".equals(arg)) {
                this.help();
                continue;
            }
            if (arg.startsWith("--jslint")) {
                pair = this.parseArgAndValue(arg);
                if (pair.b == null) {
                    this.die("Must specify file with --jslint=/some/where/jslint.js");
                }
                try {
                    this.lint = new JSLintBuilder().fromFile(new File((String)pair.b));
                }
                catch (IOException e) {
                    this.die(e.getMessage());
                }
                continue;
            }
            if (arg.startsWith("--")) {
                pair = this.parseArgAndValue(arg);
                Option o = this.getOption((String)pair.a);
                if (o == null) {
                    this.die("unknown option " + arg);
                }
                options.put(o, (String)pair.b);
                continue;
            }
            inFiles = true;
            files.add(arg);
        }
        this.applyOptions(options);
        return files;
    }

    private void setErrored(boolean errored) {
        this.errored = errored;
    }

    private static class DieException
    extends RuntimeException {
        private final int code;

        public DieException(String message, int code) {
            super(message);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<A, B> {
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public static <A, B> Pair<A, B> of(A a, B b) {
            return new Pair<A, B>(a, b);
        }
    }
}

