/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.ant.ResultFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlResultFormatter
implements ResultFormatter {
    private OutputStream out;
    private DocumentBuilder builder = null;
    private Document doc = null;
    private Element rootElement = null;

    @Override
    public void begin() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.doc = this.builder.newDocument();
            this.rootElement = this.doc.createElement("jslint");
        }
        catch (ParserConfigurationException e) {
            throw new BuildException(e);
        }
    }

    @Override
    public void end() {
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
            w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            new DOMElementWriter().write(this.rootElement, w, 0, "  ");
            ((Writer)w).flush();
        }
        catch (IOException exc) {
            throw new BuildException("Unable to write log file", exc);
        }
        finally {
            if (this.out != System.out && this.out != System.err) {
                FileUtils.close(w);
            }
        }
    }

    @Override
    public void output(String name, List<Issue> issues) {
        Element f = this.doc.createElement("file");
        f.setAttribute("name", name);
        for (Issue issue : issues) {
            f.appendChild(this.issueToElement(issue));
        }
        this.rootElement.appendChild(f);
    }

    private Element issueToElement(Issue issue) {
        Element iel = this.doc.createElement("issue");
        iel.setAttribute("line", Integer.toString(issue.getLine()));
        iel.setAttribute("char", Integer.toString(issue.getCharacter()));
        iel.setAttribute("reason", issue.getReason());
        iel.setAttribute("evidence", issue.getEvidence());
        return iel;
    }

    @Override
    public void setOut(OutputStream os) {
        this.out = os;
    }
}

