/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.listener;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.listener.BaseAntUnitListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.FileUtils;

public class FailureAntUnitListener
extends BaseAntUnitListener {
    private static final String BR = System.getProperty("line.separator");
    private static SortedSet failedTests = new TreeSet();
    private static File failureBuildfile;
    private Project currentTestProject;
    private String currentBuildFile;

    public FailureAntUnitListener() {
        super(new BaseAntUnitListener.SendLogTo("ant"), "txt");
    }

    public void setFile(File file) {
        failureBuildfile = file;
    }

    public void startTestSuite(Project testProject, String buildFile) {
        super.startTestSuite(testProject, buildFile);
        this.currentTestProject = testProject;
        this.currentBuildFile = buildFile;
    }

    public void addError(String target, Throwable ae) {
        super.addError(target, ae);
        failedTests.add(new TestInfos(this.currentTestProject, this.currentBuildFile, target, ae.getMessage()));
    }

    public void addFailure(String target, AssertionFailedException ae) {
        super.addFailure(target, ae);
        failedTests.add(new TestInfos(this.currentTestProject, this.currentBuildFile, target, ae.getMessage()));
    }

    public void endTest(String target) {
    }

    public void endTestSuite(Project testProject, String buildFile) {
        StringBuffer sb = new StringBuffer();
        sb.append("<project default=\"antunit\" xmlns:au=\"antlib:org.apache.ant.antunit\">");
        sb.append(BR);
        sb.append(BR);
        sb.append("  <target name=\"antunit\">").append(BR);
        sb.append("    <au:antunit>").append(BR);
        sb.append("      <au:plainlistener/>").append(BR);
        sb.append("      <file file=\"${ant.file}\"/>").append(BR);
        sb.append("    </au:antunit>").append(BR);
        sb.append("  </target>").append(BR);
        sb.append(BR);
        sb.append(BR);
        int testNumber = 0;
        NumberFormat f = NumberFormat.getIntegerInstance();
        Iterator it = failedTests.iterator();
        while (it.hasNext()) {
            sb.append("  <target name=\"test");
            sb.append(f.format(testNumber++));
            sb.append("\">").append(BR);
            TestInfos testInfos = (TestInfos)it.next();
            sb.append(testInfos);
            sb.append("  </target>").append(BR);
            sb.append(BR);
        }
        sb.append("</project>").append(BR);
        try {
            FileOutputStream fos = new FileOutputStream(failureBuildfile);
            fos.write(sb.toString().getBytes());
            FileUtils.close(fos);
        }
        catch (FileNotFoundException e) {
            throw new BuildException(e);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public class TestInfos
    implements Comparable {
        boolean projectHasSetup = false;
        boolean projectHasTearDown = false;
        String target;
        String buildfile;
        String errorMessage;

        public TestInfos(Project project, String buildfile, String target, String errorMessage) {
            this.projectHasSetup = project.getTargets().containsKey("setUp");
            this.projectHasTearDown = project.getTargets().containsKey("tearDown");
            this.buildfile = buildfile;
            this.target = target;
            this.errorMessage = errorMessage;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("    <!-- ");
            sb.append(this.errorMessage);
            sb.append(" -->").append(BR);
            sb.append("    <ant ");
            sb.append("antfile=\"");
            sb.append(this.buildfile.replace('\\', '/'));
            sb.append("\" ");
            sb.append("inheritAll=\"false\">");
            sb.append(BR);
            if (this.projectHasSetup) {
                sb.append("      <target name=\"setUp\"/>").append(BR);
            }
            sb.append("      <target name=\"");
            sb.append(this.target);
            sb.append("\"/>");
            sb.append(BR);
            if (this.projectHasTearDown) {
                sb.append("      <target name=\"tearDown\"/>").append(BR);
            }
            sb.append("    </ant>").append(BR);
            return sb.toString();
        }

        public int compareTo(Object other) {
            if (!(other instanceof TestInfos)) {
                return -1;
            }
            TestInfos that = (TestInfos)other;
            return this.toString().compareTo(that.toString());
        }
    }
}

