BEGIN;
CREATE TABLE "counties_pg" (gid serial PRIMARY KEY,
"id" int4,
"area" numeric,
"perimeter" numeric,
"county_" int4,
"county_id" int4,
"name" varchar(16),
"fips" int4,
"lfips" varchar(16),
"stfid" int4,
"stfid_num" int4,
"sq_miles" int4,
"acres" int4,
"pop_100" int4,
"pov_pop" int4,
"pct_pov" numeric,
"povpcttotp" numeric,
"age_65_up" int4,
"pct_65_up" numeric,
"poor_65_up" int4,
"pct_poor65" numeric,
"age_17_und" int4,
"pct_17_und" numeric,
"poor_17und" int4,
"pct_poor17" numeric,
"white" int4,
"white_poor" int4,
"pctpov_wht" numeric,
"black" int4,
"black_poor" int4,
"pctpov_blk" numeric,
"amind" int4,
"amind_poor" int4,
"pctpov_ind" numeric,
"asian" int4,
"asian_poor" int4,
"pctpov_asn" numeric,
"pcisl" int4,
"pcisl_poor" int4,
"pctpov_pi" numeric,
"other" int4,
"other_poor" int4,
"pctpov_oth" int4,
"mixed" int4,
"mixed_poor" int4,
"pctpov_mix" float8,
"ipt_pov" float8,
"ipt_65_up" float8,
"ipt_poor65" float8,
"ipt_17_und" float8,
"ipt_poor17" float8,
"iptpov_wht" float8,
"iptpov_blk" float8,
"iptpov_ind" float8,
"iptpov_asn" float8,
"iptpov_pi" float8,
"iptpov_oth" float8,
"iptpov_mix" float8,
"farm_wrk" int4,
"no_phone" int4,
"pct_no_ph" float8,
"hispanic" int4,
"non_eng" int4,
"pct_noneng" float8,
"institutn" int4,
"pctpov_hsp" float8,
"ipt_no_ph" float8,
"iptpov_hsp" float8,
"ipt_noneng" float8,
"type" varchar(16),
"iptpovtotp" float8,
"pop2000" int4,
"pop2005" int4,
"dcases" varchar(20),
"dcases_num" int4,
"p100n_00" int4,
"p100p_00" float8,
"p125n_00" int4,
"p100n_06" int4,
"p100p_06" float8,
"p125n_06" int4,
"p_ch_100" float8,
"diff_num" int4);
SELECT AddGeometryColumn('','counties_pg','the_geom','2285','MULTIPOLYGON',2);
CREATE INDEX "counties_pg_the_geom_gist" ON "counties_pg" using gist ("the_geom" gist_geometry_ops);
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('1','69637258262.874','1499131.825','2','4','Whatcom','73',NULL,'53073','53073','2498','1598651','166814','23003','0.142','0.038','19418','0.116','1560','0.08030','40147','0.241','5767','0.144','147332','18201','0.791','1014','271','0.012','4699','1304','0.057','4416','1007','0.044','119','42','0.002','4180','1170','0','5054','1008','0.04','14.22','11.64','8.03','24.07','14.36','79.12','1.18','5.67','4.38','0.18','5.09','4.38','3170','811','0.01','8316','14419','0.09','1134','0.09','1.26','9.29','9.22','County','3.76','166711','178043','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('2','70841216671.353','1608893.673','3','2','Stevens','65',NULL,'53065','53065','2541','1626291','40066','6316','0.160','0.010','5143','0.128','587','0.11410','11517','0.288','2349','0.204','36169','5368','0.850','79','22','0.004','2331','651','0.103','167','33','0.005','21','2','0.000','230','26','0','1069','214','0.03','15.95','12.84','11.41','28.75','20.40','84.99','0.35','10.31','0.52','0.03','0.41','3.39','122','439','0.03','661','1009','0.03','295','0.03','2.92','3.10','2.68','County','1.03','40132','41474','usually','3','6316','15.90','8211','7258','17.50','9436','14.91','942','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('3','148122316448.833','2060855.349','4','5','Okanogan','47',NULL,'53047','53047','5313','3400420','39564','8311','0.213','0.014','5569','0.141','564','0.10130','10943','0.277','3078','0.281','29617','4951','0.596','133','37','0.005','4524','1298','0.156','217','26','0.003','39','14','0.002','4036','1598','0','998','387','0.05','21.34','14.08','10.13','27.66','28.13','59.57','0.45','15.62','0.31','0.17','19.23','4.66','9820','883','0.06','5754','5578','0.15','412','0.29','5.88','29.24','15.05','County','1.36','38965','38688','never','1','8311','21.10','10626','8434','21.80','10783','1.48','123','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('4','39586712505.613','983448.606','5','1','Pend Oreille','51',NULL,'53051','53051','1420','908786','11732','2095','0.181','0.003','1770','0.151','111','0.06270','3084','0.263','851','0.276','10875','1919','0.916','16','0','0.000','317','97','0.046','91','11','0.005','17','10','0.005','35','4','0','381','54','0.03','18.12','15.09','6.27','26.29','27.59','91.60','0.00','4.63','0.53','0.48','0.19','2.58','0','234','0.05','238','391','0.04','80','0.02','5.04','2.15','3.52','County','0.34','11757','12524','usually','3','2095','18.10','2716','2342','18.70','3036','11.79','247','SRID=2285;0106000000010000000103000000010000001A000000D2A57D115B79434172F1808AEDF126410EBEA08684964341CF634E3278AB18419700AEC1347C434127AD6BC278A1184176B2B5B39D5643411478368377941841836573E572174341BEB91C76048018410865DB8C06DA4241CC6086C0F36E1841D0A8D6D0F2D64241078562BAFB601A417183949814B84241DC391D2CA4561A41D63676AECDB642412F3860D68D591B412CBC7FDA5EB54241F13A3D04C24E1C41F2F5D61F19B64241B03E24FBFA4E1C4178CDAD9F33B142412C787A7C61102041C5898201E2B0424163EB350D5E10204144A7B16024AE424180C0D332CB0D2141A296BACDBEAD4241FD59913EC90D2141EE5DB89E34AA42419B92236B22752241DB5751292EA94241FE0D18D648F822412908C5D5126C42418A3D65EBCEEC224129C131646D694241E5CCBA3428E42341DF1796A3598842415DB0903DFDE92341D174C55C94854241408E45050AF52441F00CB6702CA44241CB4FE3D503FB24416B20C74A5FA142416A45362E7BF025413946B49894C14241B2E4559B72F62541EE88A4F839BF4241AE9AF3B092D12641D2A57D115B79434172F1808AEDF12641');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('5','62928459425.029','1293235.771','6','3','Ferry','19',NULL,'53019','53019','2257','1444639','7260','1368','0.190','0.002','919','0.127','94','0.10230','1954','0.269','461','0.236','5527','942','0.689','35','22','0.016','1289','314','0.230','19','0','0.000','0','0','0.000','81','23','0','309','67','0.05','19.04','12.66','10.23','26.91','23.59','68.86','1.61','22.95','0.00','0.00','1.68','4.90','13','183','0.06','126','257','0.04','31','0.03','6.48','3.36','3.74','County','0.22','7257','7305','usually','3','1368','19.00','1962','1461','20.00','2095','6.80','93','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('6','17305687848.520','607121.030','7','7','San Juan','55',NULL,'53055','53055','621','397284','14077','1286','0.092','0.002','2686','0.191','82','0.03050','2732','0.194','334','0.122','13452','1212','0.943','13','0','0.000','101','12','0.009','69','13','0.010','19','0','0.000','101','7','0','322','42','0.03','9.24','19.08','3.05','19.41','12.23','94.25','0.00','0.93','1.01','0.00','0.54','3.27','18','110','0.02','378','661','0.05','71','0.05','1.70','5.21','4.88','County','0.21','14322','15065','sometimes','2','1286','9.20','1753','1386','9.20','1889','7.78','100','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('7','53656738007.082','1352987.509','8','8','Skagit','57',NULL,'53057','53057','1925','1231789','102979','11244','0.111','0.018','15004','0.146','972','0.06480','26972','0.262','3821','0.142','88943','7827','0.696','304','101','0.009','1906','430','0.038','1459','262','0.023','118','33','0.003','7680','2188','0','2569','403','0.04','11.11','14.57','6.48','26.19','14.17','69.61','0.90','3.82','2.33','0.29','19.46','3.58','4175','577','0.01','11586','11275','0.12','995','0.30','1.49','29.62','11.71','County','1.84','103924','111000','sometimes','2','11244','11.10','15586','14763','13.30','20464','31.30','3519','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('8','83460362461.617','1803010.009','9','9','Chelan','7',NULL,'53007','53007','2994','1915986','66616','8147','0.124','0.013','9314','0.140','668','0.07170','18621','0.280','2993','0.161','55797','5076','0.623','193','47','0.006','755','275','0.034','417','80','0.010','35','0','0.000','7931','2459','0','1488','210','0.03','12.43','13.98','7.17','27.95','16.07','62.31','0.58','3.38','0.98','0.00','30.18','2.58','17055','549','0.02','12894','12148','0.20','698','0.44','2.19','44.37','19.63','County','1.33','66120','68281','sometimes','2','8147','12.40','11977','9491','13.90','13953','16.50','1344','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('9','74123026585.827','1357469.936','10','10','Clallam','9',NULL,'53009','53009','2659','1701631','64525','7825','0.125','0.013','13767','0.213','926','0.06730','14094','0.218','2430','0.172','57477','6201','0.793','464','33','0.004','3244','828','0.106','870','93','0.012','61','21','0.003','746','267','0','1663','382','0.05','12.50','21.34','6.73','21.84','17.24','79.25','0.42','10.58','1.19','0.27','3.41','4.88','166','520','0.02','2189','3830','0.06','1526','0.08','1.91','8.20','6.26','County','1.28','63421','68078','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('10','14472082566.920','577144.954','11','11','Island','29',NULL,'53029','53029','519','332233','71558','4895','0.070','0.008','10213','0.143','444','0.04350','18206','0.254','1677','0.092','62333','3979','0.813','1743','239','0.049','632','64','0.013','2847','240','0.049','261','14','0.003','1128','82','0','2614','277','0.06','7.00','14.27','4.35','25.44','9.21','81.29','4.88','1.31','4.90','0.29','1.68','5.66','31','245','0.01','2961','5495','0.08','232','0.05','0.88','4.96','8.23','County','0.80','71934','77713','always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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('11','60711259959.427','1590306.623','12','12','Jefferson','31',NULL,'53031','53031','2178','1393739','25953','2899','0.113','0.005','5461','0.210','329','0.06020','5119','0.197','860','0.168','23947','2514','0.867','87','13','0.005','601','146','0.050','290','23','0.008','24','10','0.003','105','26','0','899','167','0.06','11.26','21.04','6.02','19.72','16.80','86.72','0.45','5.04','0.79','0.34','0.90','5.76','2','273','0.02','455','991','0.04','63','0.03','2.34','3.41','3.98','County','0.47','26393','28130','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('12','61192143940.606','1200532.948','13','13','Snohomish','61',NULL,'53061','53061','2195','1404778','606024','41024','0.069','0.067','55248','0.091','4220','0.07640','165571','0.273','13164','0.080','518043','30713','0.749','9587','1297','0.032','8127','1425','0.035','35534','3689','0.090','1250','80','0.002','11365','1708','0','22118','2112','0.05','6.86','9.12','7.64','27.32','7.95','74.87','3.16','3.47','8.99','0.20','4.16','5.15','999','2526','0.01','27340','68721','0.12','3442','0.09','1.12','9.00','12.21','County','6.70','615535','645250','usually','3','41024','6.90','54306','56782','8.80','75166','38.41','15758','SRID=2285;010600000001000000010300000001000000D9010000EE48FC0FE267384129C518B14FD91C416078FFBB3B683841F82A913BC4D71C415302735C19693841C32A0A47BBD21C4174E6C0851A68384108CF0AB12DCD1C419E49CCA37F68384174EEAEAF77C91C412F9D36A77E6838414CEB0E2051C21C41C340C29405693841318C383513BE1C41147D2BD1A066384104D3E9A4A4A81C41D49277BFF46638416D6EA12514A31C412F47C38390653841624C27FF619F1C417211D8CC97613841F9A8A89EC49C1C41B234AD860060384108EFC6197C971C41D490AA8FAD5E3841251BCDFB2B961C41A093E8B6BE5D3841F740A536FF891C4198704B77CE5D3841F904407474811C4189BE0800CB5E3841B39ECAA852761C413D1FBC3CA460384123CD2865A06E1C41D9CD0C0726633841E215763DD5601C417AC9EA849A643841BB1206107F5F1C41B7677C79436538416149A503505C1C412CDA877A00643841CF93ACDE1C541C41236590AEEC643841AAE458FF374D1C41EC24B0BB0F643841B619A1D3ED471C417D697DCCD66538418D6A8F613A371C41838AD2E16C673841EF430B80C5331C414978AD375B67384198CB528C792E1C416874CFADDE6838416402FCD4D51E1C41C3FF3700CB693841A4A2A04DBC181C4150D199552A6B3841A3BA593688171C411AB39FD2AC6D38411825A55C810E1C410C18C77682703841E679FF3616FA1B41BD8C8073E770384122D736E450F51B414593F79BDC7538413FDAEA9235EB1B410B18EBCF7177384196C6107F21E11B41E7787851A079384139CC3DBC23DD1B41DE63E752E17A38418301C0A9C5D61B41085B31FB547B384164A9CF3650C11B4151FAE207387E3841A9591532CBB11B41D4DB2FFD9B7E3841E68DFC4D57A51B41838653A6948138419E9BA6E5DD981B4180DAA35AF58238414D73B20D57821B41A7BDB8CD318638415622350EDD751B418553A6D80B883841106970D476731B41F838AAA0E28A384141A78FDBB9661B413F079925558D3841445CD56452641B413990E544B58F3841EFBD9DCB0E571B41972EF9D7B48F3841A79D520DE1531B4133EFED19EA8D3841C8A93FB4174A1B41F73C6A9C3E8C38416F5FEDE3B32C1B419545B8952F8A3841DF5167B0351F1B41D0AA60B9D78A38419747F4FDAA151B41C2A02A64C48A384123858E7EEB031B41E49431578F8B384194B874B143011B4198B1BC2C178B3841CBD30DC49CF51A4104790033A78D3841601AACF3D0F11A416B4174BCB09138416B9AA2500CF21A41BB753FE822943841C02EA8E3BAEC1A41975406543F9738418E5184D87FED1A418F887FE7819738418C695F8A7DE41A413E592B8D8D993841FE639B818DD81A414BC52061FF9A38415F03F4AB8DC21A41755FE78C4F9D3841D3A6C8392DBC1A41385D046E109F38412F12A511F6B91A41A0620E04BEA13841A408F1E793B61A41B7F9B0D451A43841E24821A834AF1A4158B039C391A638418620FCC520AE1A4118147EE736A938419D7A3D8089A91A417F5A54C5F7AD38410917DDDBFC911A4156C7F2B623B1384192C1D67F90871A414C5CC4E672B4384196D7B5CF89871A418F43B72AF8B538416228E70726841A41FD5685666DB63841E56BF1547B791A414E7C07645DB538413AF5623F67721A410896FF2AC8B838416212C9595D411A41B5CD47ED7BBA384143F0F8D8FA3C1A41C535A68BC3BF384171FA19D5341E1A419D96743E4BBF38411D57FA89F6101A419412C7CB9CC03841BEEFABF55A061A41C1CF5C18EDC13841671FBCC7F1F11941F34DDF44A8C1384188A4DEC0BBE919418995C39C98C03841092F829F80E519418A684532D2BC384178889FF34AE11941098BC9CB17BB384101D9DECEFFD2194175E3C77DB5B83841798E4DFBE5D01941775702C3DFB4384155205C1F68D91941287D04C826B33841E65FB5B03DD61941C1A4463D25AB3841427868BEA9DC1941D19FED4539A93841D8D40C7470D819416874B3F76CA83841FA4FD0F506D11941400B6D1325A9384177B6BEE688BF19414444EC4EE6A5384122AE22C81DBC194115EBA0044FA438412FCB71FA9FB71941FB73BC038D9E38418536499A86B91941F4651435A19C3841AAA97D7CA0B619416E66CCE5939A38410B00E6BBA4B61941DF2A53C90C943841DB91C6F5CAA7194198443E5161933841118AB32BB2981941B23EB18909943841D36695C96A8F19419618A21E168B3841CF6A0A70AB731941F052BC5CF389384116BD9994CE5F1941E24BE365888B384104AB943357531941E6A21899B98B3841177ABF872647194146F946B4878A384162F9431ACD401941AD7B00B91E8B3841C538F3EDAA3519419A0758DEF58D3841C0959553FC291941C0156DD5EF903841D15F0E1831251941867AC06F0B9338413243796309111941BE7D0C673D93384109E57626690A1941FEC50F2B3E923841D79C0410BC0219415E128FF26C93384148B65937B3F1184187C7CACECD953841C6D4B50968E818410943E474DB963841465F57F000DD1841C749C4154A9B38415F1B93B59BD6184197714C2CF39B3841E5004A21B0D31841BA36F2F7F29A38411BA4288C97C41841E0F114C55B993841B6CD4C0329C11841FFFCD775709738418E80812580C218412A2BA39DEA9438412A0CFEE5BDB41841DB63324ADA9338411A5C568301AC18419FE3FD5001913841FEEFCB7670AA18416224527BC18E3841A991955D5FAD1841BB5D5A901E8B38419391DD7369B6184106758ACEDD883841892F82AB74B21841235ABA61AE863841E1F7E7F069B118415E8D2586F78338413AE6D7AF6FB11841428C94D81A83384118865A22CBAE1841D4A3AC1F8E843841A00673371FA318418B10B4DE38833841EEA4BE702C9218413A07524FE87F3841F09525B0B889184135B87CCF3F7E38413F91F5C5E7831841539E53D6647B384103E397B3C37318419B7EECC1597B384139B519619E6018415B6E683FB477384164CDBC21D8561841CFAAE5A063753841DDE19E881A5B184193A7EB94797138419B5B6912084C1841EE6F3166E66C3841878B2C779D3F184150B242CFBB6A3841A5E4011A14431841475DFBB72069384125F328EF8F42184119882BABDE6938417E69E579413D1841E0D88B59B769384158D9EAEAC6341841A1950A6452683841E14316605E2D1841AEE54E1A0066384174304F07B42518418EAA350578643841600B31FD8C151841987D4C64AD62384152A69723690E18416BA1F4A6805E3841C784CB35D207184170437CD596593841266ECFE4AFEE17412A214E3E44523841F4A09875C5001841B23098FD864938415A93BD96600118410C545C95BF453841CFCED96466F817416C6DD8B258453841DB652F2430F01741DB4B0AAB29423841DC73093F25E61741DD6F8DD81B403841FF8F297783E31741C8B28C06243A384158A6387766D31741F9FECC4E9F3538415E92B4511AD41741DEAFF84670333841BEB9690D3ED61741A455B659552F38413EF241A203D61741EE3346817F2A38418B5E64C49CD217415FFFD719F1223841284C36985EC41741EF615DF46A2038411DC49D7F9CB617410067487E2C1C38417EEC7BE084AB1741C5E49B94501A38418C359D50CAA2174109133C4ABA183841FA7B960740A6174195622E8A6A1638414C7DAA9557B017414942B6E33D133841F9453352BBB617413D96D389040D384129F4EC3186B61741E248C8D0A507384144FFCEB7E9AA17415C8BB18CE9063841E9108760FE9E1741A86DE8C8EA0438414A3817B92B901741363EB2EC53033841A7780CB3EB8F1741A35322C7AC003841DFBDAE4E8688174156EE9B8657FC3741D467A4F40E8F1741F93DB5D07EF9374183833B3025901741B1BC2E63E7F437414D69E7144A6A1741882CFD7A44EF37419402FF7DD35C1741A78A3DCF35ED3741DDA6ACE52855174193E3082C58EB37411B0ABC75D4411741B2BA1AC9CBE33741571BADCB2A421741F3E351086AE0374157A09EA03F3A17412AD9D618FDD93741C8FE99DF11361741BDBF75958AD63741CE17292F7A2F1741DC87720D56D637416B7BE7ABE02417418AEF6F3CA2D937419AC41894600F174167B32EE8AEDA3741B7A0B81133FF1641DF2662288BDA37417A9E04EB89F3164106C1441117E83741ABC3CC3328C516410A418E6EDCEB3741910C52314ABF16413E86508681ED37419542F2C6C7AD1641438A387827EE3741521537D5B696164132680DDED5F2374114B4F3D5BD7416417038430C99F73741197EEE586B6B1641EC2147AB54F63741A5A3CE4FB85C1641F1F4969FDAF637411C74B3DAD8511641D028BD42D5F83741F98C32DF1A4516410B7E4650D6F73741E45A4591DF401641263EF6EC4CF73741C1AF5BFB7A351641657B2F5973F43741481ACBDBCB3116419AA0E4EB40F3374101C53D3097291641A679C406DDF03741F3CDCF608A1F16417E6F3918F1EB3741F36D72A820FD1541C29A559EA5E73741B06BB3ED3BF215419C92BCF7D7E63741ACA2DE4731E41541E4C070AAA6E537415E296EA368E31541FDC6D27810E43741D4A6342BEEE715415C5C4CB09EE037419DCB2A37E7E6154152B755C2D3DE3741431F7E857FDF15418B31CBB783DB37415C2874D668DD1541DF740A2F2DDB374125AA748447D215411A3BD9ED82DA37410C595886C7CD154153AD1A6E6ADA37412163568D109E15411C7A4839EDD837413F466E8C169A1541235A9AC890D6374142A74E7AC98F1541B2103717C2D5374182A615F7617B1541A7814616B2D43741C56B87EBE276154158B81090C7D337412C93FCAF146E15417E9FCCFE40D237418F83B26B626A154129259149ECD037415F6282D752601541CD6F00025ACB37414473424FA7531541988EAF8E37CA3741B475AE21E145154163D44FC3D5CD37417B2E9C00141E1541B4B348F0E6CC3741BF414FD812151541355F3ADB17CD374154FBE566E0081541529F1D0EC4C8374114F39FB9A8E5144186FB827996C4374150DC915A7BDD1441E8C135C500C33741B480F15924CF144104000B2BA8C23741CF2DFE0998CD1441ADBF0D35A5C2374124140BE10ACC144120F7E12083C237414D40C1D72CBA14414221D32D7BC437412DAEC2D4419D14416B63D3E456C53741C2521FD5BD98144130FFEFCCF4C137419F3F723CD2901441FF0F4EB3FABB3741783FCA287D78144102EE2C1270BC3741E76FC2E6437014410B04532B0DC337415013A9E9C25F1441B8F69C9E1AC43741E2A57DC1155414415D1FDC0991C23741316FD902183E1441F68802DE61BE374133838FE0A22C1441ABD41F2C2DBE37410EC4129B6F211441D745B3FCE8BB374181ECE9B52F0B14415687007294BA3741744FE80DB7021441C3B67D6E5CBC37414F5DC7DF07F713414FC4212B8BBE3741709A3ADF70F11341EF29BB238ABE3741F4DA9DC713EB134187A3109C54BF3741C57CB1B2B4E41341E6D216E81EBF3741A9A3993535D3134184011AB1E6BF37415495FDB821BC13416BE2AF2692C737417607DEE674A41341BA17B99FA1C73741C766A2E72C9B13415820B213B0C837416AC088BA98951341C5EBC78967CB3741877AEB7F5D961341E9556869A8CE37411F018B1600A21341792478AB60D137410A5E7F99CEA71341B39D22818FD0374195DA3191488413418ACDF93E9AD23741947078CE5E7113411865C5E819D63741A6BD35E62E5D134149DA0B2921D83741883525C60F3413417809CEB23ADB3741A32CFAF0391D13414A5C6B8528DB37415329AE65891513413060168C92D737418033F40B50081341806470CA82D53741A2FDFD87DEFB124101BA8B905CD437417F5AEF2AC1D61241974253B863D93741D0CB2797C5CA1241A62AB54BF7DC3741C5C244929DC8124194161293B0DE37417991BC7D74CA1241E4D00A4425E037418FF4B41D86C71241C5882D4753E3374170864294B2C6124178246C9150E53741C780106B98C9124101576C273AE83741FB9A2B1F0FC51241D6C6C71E1EE83741363674507CB412419FACEB0E06EC3741D3E8B4C768AF12419663CDA3BDEE3741A2BFB0AA71B01241B55EFD2232F0374156D16FE02FAC12412F44377593F137418948C75875AD124150EFC65232F437411AB1BC5C68A31241FCC432E0B3F3374184400C99B98712411F0FE3F5B8F73741049EB1AC17801241E357097928003841D54628F5ED7512414699683A57043841041AC34B947C12410D0F0D72F4053841D5A4CBD44083124118244F14FF08384199EBA75DBE82124177E5FE62D20C384125A8FEDD9A8F12417D6C481DEC0F3841CAE0EC6CD58912411EEC79E012123841CAD3347F2A8D12417EB18B9AEF14384137A68B023B8B1241FBA4A389471C38410EA30DCD9D961241D00FAE05721F3841D7357769C5821241DDFE1FF4BC24384132457B9CC27C12410C0B4FCFA924384153FF53C2CC661241CD5B48BDBF203841A06E4777A15D1241EE63B11AD5203841FAD4157964501241573BFA7C6E193841964FB68F1A2C12419347FFAB6B19384157F0561246191241CBC284715D1438411761C74DA3F71141AB06B7E1FD0E3841EEE9BA2058ED11412EC094E6650F38412FDF73F045D7114196DEAB46200D38419A48827E44CD11416A9C1223DE093841D3EB357584C811415E7B7FA9F00638412CC73B2CC4BE1141D56357C7A4043841FA8FE0AFF7BF114146DA88CBFE03384112C3CEF3FCBA11414C80776E71013841FFDF46BC13B41141A47311E0CFFE374151E778E4B8A611412217191628FF3741C1B87E63F3911141E9030EEBDAFA374119BDD57732881141500A0A8AD3F83741E937E8A93D891141B9E9ECAF0AF437411095D546E27511412321B8930BF437418F6BE4F5B06D1141FD88E72236F53741F1E83DE4E6621141314FC59D58F53741C6EEBC848C5F114126AC53BA11ED37413D90CCD2C35F1141A563F8EAE4A93741BE4D35B72D651141AE6A2067E4A93741AD26D0640B621141E7B6FCD98B5237411AD01FF94A64114146DE134793343741F831915709641141147BAE757DFE36415B1C256C496511417FECEF3F2CB2364196C45478DF69114100A0C84C28B23641A17F5D210A5E114184D211B4729E364157C8CBE8A55E114157FE689D839536417A466070635C114185241306BF8E3641B2E5E524795C11414E06A27618783641A7B9E436D85A1141BFC7E862D24D36410699CF23085D114190C8957F4E363641069FFD14DF5E1141A5F4B62B5636364121030E6F655A1141A586F103C9213641760F8717285C114190B50EDED60D3641F5D9D028545A114128442FFAB4E435410BCC273ED15E11419D76499262E335412B2EFEF28F5E11418CD05A00F0B035412EE5B9B2D4611141EDDBEE3E69833541670A643EAE631141224956A89962354130547632A16511418FEBC85DDD2B3541C1926EA762691141E1927FE4C216354149C3BDC43F6611419C803128E5EC3441257DDAC48F6A11416C5AC5816ACE34419291108C976811413B56EDF518AF344128463AE6D1641141B71A0B567B973441EEEC5DA92C671141CB29C78464853441F7B7167E4E6A1141CE070089CC723441198A1E06426A11418686455A266434411D4FB8429B6C1141011F6AF9A04734417603F73D496E1141D9E1695A3C2B3441494C9D71FD7011415D907D88260E34412FC46FFCAD731141F5938AD4ABFA33419A7972B1BC7511412F6FEC3A28E83341EF37B7390378114157A56630EBC133414C89092AC27D1141D327A9404F9A334177E34D0D4E821141BC26FB09E581334167DFB70DF2851141633DC2B99A6E33417F22C3E2DD8711410B8AB239AD5F33419EAF30DCB4891141ADE396CD0D3A3341F5251BCD018D1141218D3F0AAB313341581E2510448E1141D4D1468A3E0233416789CF3D50921141330A80215300334128D542D69DB81141FAA5194E79FF3241B39020D321E3114135F13C62FDFF324158B982A98A141241BCA1BD55AB0033416C07FCB6C82A1241C432BF065B0233412FA7D749584B1241E034CF2F15053341EBD9809B2D6E12410F7E5821DB073341AA4332BF218B1241E2DD33690A0C33414CBD5622CAAF124155D733A1430F3341750D13F0EBCA1241C06E79FC481333410E5FFD7AC7EA12417F9A3BEF2A1A334123A2D370141913418F5BAA3621213341EC8DACBAFD401341428C2DB0DB263341DA4FFD35AF5B13419397B699F52C3341FEB40578D1751341BC33DEDA4433334133EBC17C3A8F1341882D19FE6842334114861FC97BC51341FC5F4BD97C4833419287AB8725E21341C716CC18F5503341D76635D86C0E14415312AF11BD55334190D820BAC22C1441F83913E88B5933418F69E3F40C52144131B1FD9B0A5B3341ED406F26486F144151989666BA5B3341F8421304208D1441DB33426C785D3341A98CC0E702A11441106F495B275F334181BBCC619CAD14418BF7190A5468334163A1DB40D8E11441B977219D376B3341E0880820CAF71441D622629A937033414B94768E0B821541A958EAEF177133418CE949451CA2154165F8921DCD7033414E0EF2ED55BF15413EC682DBBF6E334132DFB6C390EC1541E8E71D5A266A334128152FF3C7261641634AAC7C72613341C8C6ED97C97D1641D8DA12CABD5C3341E0B95F9ED8B016413A462EDFC55B3341F7550A8192CC1641801142E5765C3341B9DDD97888EE16413D838A475D5F334192EF90F6B9121741968A425D14653341A1CA218D4D4B17412910DE8E296733410C891B6226671741CE7492A1A7683341E6769152778417418AF53C3DF168334119998901C89B1741FCE1228AD26733414FE1F6F58CC51741CB1D3B3A1966334195906DF7B9E71741B30B6150596433415CD87B5280061841064DC9A324613341958ABCF9753118416AA4E182215D334164C07D149D5A184190A0CE9B8A5733411D79EAF794891841CAA8BAD9E2533341E576AAC93CA41841A345E174E54C33414E46D0DD39CA184195FCCD3905463341D6C2DEA47EED1841C5BC97323E413341753F90DC64101941D01EB07D903933419DB374881F471941AAE75257DA2F3341A82BD2EB9085194199BCD827852A33418363162D88B71941349510E57225334184BE2E9336ED19414BF19E81D322334161E1380B60251A41412FC47FA82133415381DFBA97561A4133E8F5813C223341E2A1671DF0941A41EB3B6B6369233341491D8B8B60C51A416074AB1D652433413652AD427EDB1A4172A99A3BC226334131CEA5B3A6FD1A415C80CE57472833410E0E97B51A0C1B416726B4E1052F334103AE94EFE73B1B41A87EBD02553233416B0E308CD8551B418417111285343341EF18E99DC06A1B4194F963C20838334178E7918C808E1B41C914330BC93A33415D313CA489B11B41C06D0A40D73B3341C720BB0A9FB81B418E74467C763B3341E28EBBFDD2BF1B41BAEB2B5A663B3341F54C0E3C1BC41B4105ED7DFD9C3B334131698A8C1DCB1B412A120AFF7B3B33411772CF1EC0CE1B41EDADEEF51A39334191D548EABCD91B411AAA141FB73533410E3A5FE3B8E21B41147DD5DE37353341E370F0E550E61B412DC01D7CAE3433413BCF0E35FAED1B410A2134CAFB333341346620A300F41B41810B0DFE04343341601A5FDBFDF91B41EEE1F9340A34334151B1ADB9BEFC1B410A851C6C17323341B13834A4B4031C41E8B14EE5A6303341F125C10B4E111C41E977F7B9822F3341F271579ACF201C41D15004052F2E3341BBC9B978562D1C41C59A3CC85E2933418B38116473541C414BFC5D5A22273341B28FF21AEB631C414B87EFA1471E33412435FF9191A01C4107D5309C7F1633411DD6442A31CE1C4129599F6501113341812BCF9ECEEA1C415ED22E526D0B3341C4DE6992A4021D41AC0B4EE1670733410037F2825C101D41041BE83FAD033341F032C4C32E1B1D41A046A28A2F003341CA521D3907231D419B392532CAFE32411A2C7389B2251D415CE3CEF8BE4C33413EE886ACFB1E1D41B24F0CDFF97333415542BFB2FF1A1D411E21C2AC14A33341B4DB44CD46181D418B81C59029E03341AE397DF5DA111D4105CAA84A64043441BF014E76020F1D41BF6AB89EE62B3441D3AECE76360F1D41C40AA791C13934416B057F819A0E1D413020B028FB523441059765C70C0C1D4145164CFDFE6D3441E8E2F91B990A1D41A2609D1826A03441CD654623D5061D41BD572BDE22BB3441277F2225ED041D41F25A9EC895E83441FF99D4B2FF011D41E34D9751403335415C273B168AFD1C4114D885A49670354107EC899B9AFC1C411990A19214CB3541CF014B23A4F91C4188C32405C3F33541A77A555712FB1C41816BEBEB5E063641B63E5884CFF81C415A4DD619D91B3641D4176ABC55F81C41E0A9DCB874443641D54877BA88FA1C41C04A75CD77443641ADDBF2BD69F11C414B4702A3DF573641D1C822A50DED1C4137962343DA8C3641AF4687CCBBE51C412E39550552CE3641EE91D3AE03E41C414A55161E5824374175870EB08CE11C41557C0A52A35737412F96F48A6EE01C414CB27677B1EF37417CFA96D1EAD91C411471CC2AC133384144B1993A87D91C418D51133894673841635975FE4FD91C41EE48FC0FE267384129C518B14FD91C41');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('13','51525388130.105','1340355.522','14','14','Douglas','17',NULL,'53017','53017','1848','1182860','32603','4640','0.144','0.008','4131','0.127','272','0.06580','9593','0.294','2026','0.211','27626','3277','0.706','175','21','0.005','325','59','0.013','241','83','0.018','33','14','0.003','3466','1075','0','737','111','0.02','14.42','12.67','6.58','29.42','21.12','70.63','0.45','1.27','1.79','0.30','23.17','2.39','8612','259','0.02','6490','5871','0.19','220','0.44','2.21','43.99','19.45','County','0.76','32658','34603','never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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('14','49648129241.756','1019476.485','15','15','Spokane','63',NULL,'53063','53063','1781','1139764','417939','49859','0.123','0.081','52221','0.125','4021','0.07700','106908','0.256','15672','0.147','381356','41505','0.832','6325','1528','0.031','5740','1416','0.028','7444','1347','0.027','695','141','0.003','3375','801','0','13004','3121','0.06','12.32','12.49','7.70','25.58','14.66','83.24','3.06','2.84','2.70','0.28','1.61','6.26','495','2411','0.01','11465','25724','0.07','6545','0.04','1.47','4.37','6.59','County','8.14','411310','424425','usually','3','49859','12.30','67302','61966','14.60','83645','24.28','12107','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('15','15763029329.454','629276.893','16','16','Kitsap','35',NULL,'53035','53035','565','361869','231969','19601','0.088','0.032','24463','0.106','1401','0.05730','62000','0.267','6973','0.113','194741','14618','0.746','6233','886','0.045','3324','617','0.032','10465','765','0.039','1698','279','0.014','3558','530','0','11950','1906','0.10','8.75','10.55','5.73','26.73','11.25','74.58','4.52','3.15','3.90','1.42','2.70','9.72','235','1061','0.01','9718','18011','0.08','3919','0.06','1.23','5.59','8.31','County','3.20','227037','231078','sometimes','2','19601','8.80','26207','20797','9.00','27806','6.10','1196','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('16','77835252440.806','1483736.095','17','17','Grant','25',NULL,'53025','53025','2792','1786852','74698','12809','0.174','0.021','8664','0.116','780','0.09000','23999','0.321','5370','0.224','57354','8103','0.633','747','180','0.014','753','217','0.017','569','26','0.002','14','8','0.001','12966','3741','0','2295','534','0.04','17.41','11.60','9.00','32.13','22.38','63.26','1.41','1.69','0.20','0.06','29.21','4.17','28941','778','0.03','22543','19327','0.28','582','0.48','3.09','48.43','28.33','County','2.09','75603','79705','unknown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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('17','65218266645.446','1177503.191','18','18','Lincoln','43',NULL,'53043','53043','2339','1497205','10184','1260','0.126','0.002','1927','0.189','141','0.07320','2566','0.252','448','0.175','9721','1146','0.910','30','8','0.006','153','49','0.039','18','0','0.000','13','0','0.000','50','16','0','199','41','0.03','12.57','18.92','7.32','25.20','17.46','90.95','0.63','3.89','0.00','0.00','1.27','3.25','55','90','0.02','168','278','0.03','100','0.01','2.17','1.43','2.89','County','0.21','10048','10214','never','1','1260','12.60','1806','1287','12.60','1845','2.14','27','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('18','64346858869.577','1339706.051','19','19','King','33',NULL,'53033','53033','2308','1477201','1737034','142546','0.084','0.233','181885','0.105','12937','0.07110','389035','0.224','37954','0.098','1312830','79906','0.561','91538','17670','0.124','15728','3129','0.022','187788','21197','0.149','8270','1302','0.009','44239','8800','0','76641','10542','0.07','8.35','10.47','7.11','22.40','9.76','56.06','12.40','2.20','14.87','0.91','6.17','7.40','699','6341','0.01','95250','299620','0.18','13262','0.12','0.89','11.80','18.35','County','23.28','1724792','1747083','always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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('19','29347130734.509','765306.464','20','20','Mason','45',NULL,'53045','53045','1053','673717','49405','5716','0.122','0.009','8105','0.164','389','0.04800','11578','0.234','2058','0.178','43609','4488','0.785','594','5','0.001','1813','398','0.070','474','28','0.005','314','65','0.011','1014','378','0','1587','354','0.06','12.17','16.41','4.80','23.43','17.78','78.52','0.09','6.96','0.49','1.14','6.61','6.19','222','381','0.02','2358','2966','0.06','2191','0.13','2.01','12.56','6.34','County','0.93','48221','52234','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('20','65084530506.233','1428406.322','21','21','Kittitas','37',NULL,'53037','53037','2335','1494135','33362','6122','0.196','0.010','3883','0.116','310','0.07980','6863','0.206','1100','0.160','30756','5431','0.887','247','106','0.017','256','49','0.008','573','141','0.023','162','27','0.004','692','185','0','676','183','0.03','19.64','11.64','7.98','20.57','16.03','88.71','1.73','0.80','2.30','0.44','3.02','2.99','1105','183','0.01','1668','2453','0.08','188','0.08','1.37','8.17','7.74','County','1.00','31521','33668','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('21','62464503509.635','1142181.781','22','22','Grays Harbor','27',NULL,'53027','53027','2241','1433988','67194','10668','0.161','0.017','10332','0.154','951','0.09200','17298','0.257','3760','0.217','59544','8425','0.790','172','63','0.006','3325','976','0.092','640','190','0.018','122','5','0.001','1313','541','0','2078','468','0.04','16.10','15.38','9.20','25.74','21.74','78.97','0.59','9.15','1.78','0.05','5.07','4.39','483','898','0.03','3244','4032','0.06','427','0.13','3.35','13.40','6.40','County','1.74','66433','67773','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('22','50351410615.272','1252902.182','23','23','Pierce','53',NULL,'53053','53053','1806','1155909','700820','71316','0.105','0.116','71386','0.102','4953','0.06940','190257','0.272','25470','0.134','548941','44485','0.624','48741','8065','0.113','9472','1984','0.028','34671','6483','0.091','5075','734','0.010','14879','3215','0','39041','6350','0.09','10.49','10.19','6.94','27.15','13.39','62.38','11.31','2.78','9.09','1.03','4.51','8.90','1631','3450','0.01','38577','76648','0.12','8200','0.11','1.32','10.58','11.77','County','11.65','703484','729646','sometimes','2','66363','10.50','94035','82450','11.30','116830','24.24','16087','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('23','53825945809.353','1087889.328','24','25','Adams','1',NULL,'53001','53001','1931','1235674','16428','2951','0.182','0.005','1771','0.108','149','0.08410','5624','0.342','1343','0.239','10592','1330','0.451','51','35','0.012','61','13','0.004','131','0','0.000','0','0','0.000','5121','1493','1','472','80','0.03','18.20','10.78','8.41','34.23','23.88','45.07','1.19','0.44','0.00','0.00','50.59','2.71','2962','168','0.03','7754','6440','0.43','114','0.74','3.21','73.53','43.30','County','0.48','16214','16475','never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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('24','60715013164.926','1286218.358','25','24','Whitman','75',NULL,'53075','53075','2178','1393825','40740','9027','0.256','0.015','3774','0.093','199','0.05270','7359','0.181','1211','0.165','36025','7279','0.806','624','190','0.021','217','30','0.003','2230','887','0.098','113','68','0.008','413','154','0','1118','419','0.05','25.59','9.26','5.27','18.06','16.46','80.64','2.10','0.33','9.83','0.75','1.71','4.64','451','146','0.01','1263','4261','0.11','243','0.04','0.96','4.45','10.99','County','1.47','35132','35026','never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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('25','21575652967.685','830423.593','26','26','Thurston','67',NULL,'53067','53067','774','495309','207355','17992','0.088','0.029','23453','0.113','1135','0.04840','52379','0.253','5269','0.101','177035','13548','0.753','4783','424','0.024','3144','668','0.037','9424','1262','0.070','1205','115','0.006','3643','776','0','8121','1199','0.07','8.84','11.31','4.84','25.26','10.06','75.30','2.36','3.71','7.01','0.64','4.31','6.66','669','864','0.01','9067','17985','0.09','1959','0.08','1.06','8.30','9.24','County','2.94','210791','225208','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('26','120283146357.561','1701427.194','27','27','Yakima','77',NULL,'53077','53077','4315','2761321','222581','43070','0.197','0.070','24896','0.112','2678','0.10760','70553','0.317','19254','0.273','146065','19248','0.447','1943','430','0.010','9396','2692','0.063','2180','392','0.009','151','64','0.002','54961','18383','0','7885','1861','0.04','19.67','11.19','10.76','31.70','27.29','44.69','1.00','6.25','0.91','0.15','42.68','4.32','52476','1752','0.02','79952','64712','0.32','2549','0.62','2.37','62.13','31.81','County','7.03','220069','226028','usually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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('27','67966890495.128','1393810.958','28','29','Lewis','41',NULL,'53041','53041','2438','1560305','68600','9460','0.140','0.015','10671','0.156','971','0.09100','18197','0.265','3376','0.186','63734','8157','0.862','247','93','0.010','856','202','0.021','380','18','0.002','126','39','0.004','1628','538','0','1629','413','0.04','14.01','15.56','9.10','26.53','18.55','86.23','0.98','2.14','0.19','0.41','5.69','4.37','1320','562','0.02','3557','4083','0.06','749','0.12','2.14','12.07','6.36','County','1.54','67882','70896','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('28','34326333676.087','822015.321','29','28','Pacific','49',NULL,'53049','53049','1231','788024','20984','2973','0.144','0.005','4704','0.224','376','0.07990','4500','0.214','888','0.197','18993','2437','0.820','32','6','0.002','441','93','0.031','501','126','0.042','0','0','0.000','411','225','0','606','86','0.03','14.39','22.42','7.99','21.44','19.73','81.97','0.20','3.13','4.24','0.00','7.57','2.89','129','203','0.02','1102','1650','0.08','243','0.13','2.23','12.82','8.23','County','0.48','20554','21203','sometimes','2','2973','14.40','4268','3350','15.80','4809','12.68','377','SRID=2285;0106000000010000000103000000010000003B010000270C1D0486A92E4134D2F6B923E8EFC0583481332AA12E41A5FC0AD254F7F4C0AC7DF04B2AA52E41CBDBE8EB5DF8F4C07C78AE5E5FA62E41DA9A3E9C5953F9C05AB6DBCDBAA72E4170646EB2DFF3FDC02CCD351591A42E4171E985B1F046FFC08CE90B5149A32E41ADD86F0D875600C19DE1819B66A32E419963A5BBE4F100C1CDBFAA362CA02E414D14BED7188501C13B8DF246109F2E41FF3EF0E24F3202C14B29AFBF6EAA2E41C859718DDF3402C14682A269A2A92E41616751A97FAD03C1421FAC2B78A72E41DFAFC9896CA004C1EF1869E646A62E4109DB33D4874F06C12FE4E44C64A22E414ABA1F7EF8DC07C18DD86DAA709B2E416E7A04273C280AC129D819FF48792E41DC732570F0210AC1766BBB3D1E5C2D41661FA9E674FF09C107417AFAFC652C4178635DCC14D309C1EA9918E258C72B4114CDF0FE6CAE09C1BDB1E5DA90C52B410D1283E2921D0AC179553BA6D5B52B41168C71673A0A0FC1244FF882CBB52B415C6E678F660D0FC1932CC23419B52B416F6398EBC60B0FC1DAB4D1BB129F2B41923B674970D80EC1A050CE3B506F2B41896298E4B3190FC1BC29EA4219972A413030A6D0C01C10C186E7EAA750252A419BB4B15627FB0FC1572584D730D629416D47BA0938A60EC1261198D74D9C2941DE1401F9F4250EC194AED49B6D7629413DE09F707F790DC16D226B0B5B582941F2805FDB30850DC1D2DD50962053294169FF094F1AE00DC13F7ED3A8856129413C8CD81EDB670EC1828C85424F572941A86D2BAD4DB90EC17B4EB63950F42841BAAD6CDA41490FC120D86C16D96B2841E6D5AAA7C34A0FC1C3715892D46A28416CA639D190410FC1FD00559D98692841EBAA45256A310FC1F7C998D70D682841AFD97F2CE61F0FC15A174E03BF66284155D61BE283100FC18A655097AA65284116CC00BE17F90EC1868C250FE76428413360369A34ED0EC1435B4A324A642841D7DD613E86DF0EC11BF03E8A43632841DE6BC82F5FCE0EC14BEBA270146228418F4968C6FA9F0EC19F8FDD5092612841192D7E2EC2840EC17FC51231E66028416406C0891C6C0EC1FFD6AC52046028411ACA313FBA540EC16D5D96FC7A602841D3200E6C671A0EC17834197FC9602841EC7E6C31B1010EC1660BAEADEC6128410602ADA889DA0DC1C1D0A0EA0A642841608210970EB30DC10F5694B308652841D21A4F5084A70DC1E8B5D5CA106628410F00157B98980DC1A7A93E5762662841D7F21CAABF8E0DC1E4CEFF34D0662841CE00E6247D860DC1DE932BC49667284146E44DB7787C0DC1350510D0B96828413662C4E8A76F0DC1EE2D72D7CB692841E2959924D4620DC19A4EC6B7066C284116F9D2B20E520DC137EF19422E6E28417DD4CE9C0D420DC142C072290C7028417106983C14340DC1BCA67B43CD712841E2F28176C7240DC12C7FBD0EAD73284127B4EAF348160DC1F4B5A74B6D752841AB2DF5F4750C0DC1F7E0EF24BA772841E0C9CC5665000DC1BAEA07E92E7928410A5D08B061F90CC1B2223B56AE7A2841F4D086E03EEE0CC1AACC7AC2A67A28419A191456AEE10CC1846A589D567C2841AC05CF1581BD0CC170A55170497D2841F23EAF17EAAA0CC1C54ADE46657E2841EAA1FB2DC0950CC1D0BF1B7F737F28419B908A1C02850CC19238D9098D8028417224D708D7750CC1E3F7A269788128411470679CCE6A0CC11E243845FA8228412B82ED996A5A0CC1D754CA401E8428410AFF7F3C574D0CC18A906D587A852841BF2C444E393E0CC1DFFB00D1C7862841C5E3370D932E0CC1D287D20B7387284102056005ED270CC1CBDE9AD20C88284143C7424286210CC14DD150C9D18828414212417D61080CC1DF5450F7E1882841384A72F950EE0BC199A20117468928419764CB95D6CE0BC1891B63B0008A2841C2989466D1B80BC133C4C3B9B58A28413A44112DD5A90BC1939986A4D98B284154280B9F8A970BC14A651973C48C2841BF5ABD904B870BC18C0CB7C71B8E2841AC6ADBCB85740BC1E5BF08B521902841BFF4CD09475F0BC10C17A1B1C991284187EF19B222480BC19F50C237169328411024EA68BE380BC1C9FB01C201952841B7B57CF99B260BC1598C7088739628415618C2ACF1150BC16CEBB57BB997284117695B41A2080BC145DCC2B4FD9928414FFD96EFBDF40AC1C2852E621D9B284134BD428FC0E30AC1D4F22616AD9B2841E00312DED3D00AC1EDC08A177B9C2841F0DEEC8A40BF0AC111066C4E5F9D28412878015A16B10AC10EBBF53B309E2841AF305791F2A30AC1F7D4C024109F2841AA59DAF7DD910AC14F4022D6D29F2841CBA0911CB87E0AC1B7013F5676A028418B01AD0CC46A0AC15CF50A512CA1284117E89DC5855B0AC1F54368BC36A22841A97F50FFD14B0AC1303554B476A328414936E73341260AC19C40DDCBF3A528419413D4E669000AC1274FA1A6EEA62841B7CFD94370F009C1C82482D2DBA72841BAF9CE34ACDF09C1B93ED6BE53A82841A4FDD12A2BBF09C1CD637C760DA92841A8ED18369FAE09C1498F2BA3D2A9284196CB04B4CD6009C1B836F9F637AB28415A145DEEC1FF08C1F59EFAC04BAB284122DAE6FA0FD508C1FB461ECCCAAB284119115E00ED9208C137C249CD5BAC28413BC640547F5508C1C3B33D1D6DAC28410CE3AD770D2608C13FF435CCE0AC2841464C7A50D90608C146B5F81D18AD284197D981C4FDEA07C1EF7E9EAA27AD2841B39EB7C77EC607C179691E17E0AD28410A999DF8219C07C1C1F20DBBAAAE2841318FE9889E6107C10C42D3D33DAF2841E514ABDB503307C1795A88E1FFAF28416F053872BD1507C1BE48143C2AB02841632EB0B3EBE806C154DDD314ECB0284122B0B47FB2BB06C1207D39F862B1284197E8243F3D9606C1DD3620B0C0B12841E9AE5F4BB96306C176D40C38B1B128418F38BDAE94FF05C15973EC3698B12841A983BF1267DD05C1E3B65560FBB12841F0142F5B30BE05C1B0F8F56748B228418F1D6416C8A005C1C8FA455C74B22841A6DC3BB9168305C1FD937B258FB228413D5B3CD1FF5505C18E3DF6091CB228419C652C61C32405C10D8DFB66DEB1284127AE42F798FA04C13324A5C9FBB128416F25D05CD2BC04C1C89753F9B3B12841D3BB8863599404C1C56F848FEEB028416C981428386404C16B3B6A290DB128415C31E64A0B3B04C176CDDEBB36B128411D19AA1F091904C14961700D0EB1284183F83B6A85B803C17088A8BA22B128410BC78F12887903C1764474E89EB02841395D127C214C03C1AC31F52D1CB02841F68A6975F02303C1896B19125AB028419CF83DC47EFE02C139E4B3D51EB02841B34BF265FDDF02C143AD6C1A3EB028412AD91791F2BE02C1EBBEF19A93B02841C27C304291AD02C1E1859780B3B028418DC3E180FE9102C13AD74CEA00B12841E7B34A81BE7D02C199A5FC9C36B12841375D135B176602C160C37B7905B12841513633A5674F02C112241E506DB02841587FEE48F43302C168A4251C3BB02841E0DA84250F1802C177501D1EF7AF2841F21EEAD8230202C12CEA147751B02841F7B73C0DBFE301C151CF0038A2B028412FBFD0B988BD01C1D5CD2272D1B02841A0820B584C9701C1348CB8A2EAB02841AB6C41D8557801C1CC0A0EFC3FB12841C5AFD7D0F65901C17DF0A2134EB12841736FC506803501C178C04A7F83B02841AE4320C8590901C1FB42C82C40B028417835DADBF9E700C16392349D34B02841CFBCF2A149CA00C1530AAE7241AF2841C953C1BC5FB100C1CE9E8068A3AD28419F5AE7B26D9400C125791525B7AC2841ED3C4192B57300C1C5B0103EECAB2841E43E40F5494D00C16EB7599A71AB284120F9DA64F72700C177D0277339AB28417CC12C2F9E1300C1E1630B4D52AB284153759CB181C8FFC06279AE0EEDAB2841A6D10FFDFC76FFC0845B5200C6AC2841560442F83B1DFFC09743411CF5AD28413D1B6EF86ED8FEC087667D46F9AE28418A6E3915096DFEC011EA88498DAF28410909790FF6E7FDC06CC3D5A15EB02841C2BC0FE17688FDC0AF669A1363B128416989C6607533FDC041206239BAB2284104476ED407EAFCC0D979B558DDB32841473D1CE8A196FCC06A40D5938DB428415A6B77C76958FCC037772369FEB628412EB41C4EABE3FBC0EDF10005EBB828415D9BB92D878FFBC025135AFC99BA284169B46F540B4EFBC006C28ED760BC284151C5F276D01EFBC0B3CEAEEE8BBE28419B1349C2A9ECFAC06C03215B1DBE2841BBB9128EB7A7FAC0D0BB528720BB2841ADC844FA5F62FAC0BFCEBC5E88B828414B9F34C51D28FAC0CF4852D565B62841BA72377D71F8F9C050E796AB17B5284112D0F227B0CBF9C0AF7A1939AEB32841EC51A7302FA6F9C0238FDF38AAB228415A262D82CA7FF9C0C449A9EE0EB128412FC0A5A0AA65F9C0590C3A69CBAF284126062F7FB426F9C0C76941575FAE2841BCF3A5AA5EECF8C0EEACB7B75DAC284139175BC8D0B1F8C0BBC407640BAA28416DA0D8D69275F8C0AA551AC494A4284180D0FAB80803F8C0E6226AB39BA12841C55A20A23AB6F7C0C557BB422FA0284198121B72CC81F7C04EBE6879089F2841DF6219D45367F7C0AE3D35652B9E2841A5C6E9D4BB53F7C046CAA72AD99C284141EA02CA0835F7C01FCC342CDF9B28413629F35C5613F7C0C809F232659B28418680E0D16900F7C0C94C74DBA39A284151E632960DE5F6C06E76A68FD1992841DC1954792FCAF6C0BD22096A28992841F3F2E334A1B5F6C0F83784A66F982841CB59922F02A0F6C007572E18CC97284163BC7D544B87F6C05F575A451497284113C29B192771F6C0C1E3E1FF399628414B508CDB7A5BF6C0BA68D69C7B9528412C15B9317F49F6C04E02BFB7DD932841D53AB3D88A1AF6C00B816D6CD1922841280CAECFCB04F6C00D43EA98BC912841E78971A7D4E9F5C0B13A46A2179128417979D31D28D2F5C05450E3C2249028415CF065FEB8B6F5C0782A3CA6378F28410FB8BF6E95A2F5C02FCEDEA98B8E2841E6EF4D17968FF5C00BCAE9AABE8D2841A1EE88E3887CF5C0A1B36D821E8D284153B23082AD6CF5C0BADE3DCE648C28412273F79B9357F5C03D8A35C6AF8B2841564C88355B3FF5C0131FE198538B28411AF29634142FF5C0FDF84DDCCC8A28419F4E2DF68719F5C0188668474D8A284130214E033E0AF5C0470DCEB0DE89284122E40099FBFAF4C0CA74CFDF40892841ED43683A90E9F4C02DBBF5069A882841E932C97EEED2F4C02E52EC471D882841373F137A16C2F4C059E7DCE34487284145D83A3360ABF4C0A7FEC621E286284179DC31AD3F9FF4C01993E6886286284190CDCB9EF58FF4C0AB35B10BF38428418F1A564B9E6EF4C0620440D84C832841BB452D905050F4C0E9246BED208228412B9623657A39F4C0E5531D7C6181284123F59513151DF4C01158EF2FE580284141E0DCC4B60BF4C08C1C8B5148802841A5D9BB67C7F9F3C03772E6A6D17F28414E8866AFC6E4F3C0ECEA2456537F284172FD56BA83C9F3C06D93A7EBF07E2841DBE13A7EF0B1F3C02FA48607A67E28410B49A0F2B595F3C0B33D86D1407E2841746AD2EC3680F3C0EBDE5748FA7D28419AD6FC45536CF3C03D4DD3A29F7D284197D8D1B6CC48F3C0403DE30DBA7D2841D4CBAE40E33DF3C0A7516106A57D28418461E224122AF3C036A44F618B7D28413E184899E519F3C006C7514B817D284107FE416E420AF3C03E34228B797D2841636F2F5211F9F2C074F0094EAB7D2841F01E3F75C0E2F2C0EEA94AD9A67D284131B636147BCFF2C07668A33A8A7D2841CA35BEC6EDB5F2C047EA54697A7D284180517D81FE9EF2C03CB45720A37D2841E4BF60347583F2C0F68BD2D9DE7D28419DCCFC56D871F2C0A052275A4E7E2841F917B334D153F2C057B72FB58F7E28418CD4BDEA8F3EF2C0B4B27836D67E28415CC5E724AE25F2C009209FCD1A7F28413A287570D40DF2C0E7869D26857F284171EEA4CE6FF3F1C0F40621BDFC7F2841049DE8E424DBF1C01B1EDBBF39802841F647FA2C8DBDF1C0D2C83E239C802841E31A0C085BA8F1C0B65AFDD3E680284178AAEA14598CF1C04292439A52812841E5741252EA70F1C0D7A5DA001F822841D5EEF1A9C64CF1C05BC0C8E5C98228415AD740769528F1C07293AD695A8328410CC826B9990AF1C0EF93F68504842841EF9AA57561F2F0C03F36118ED5842841B892A65299CAF0C0D115415250852841E8E169794BA5F0C0568615F59D8528412442991FAC92F0C0C2F0F4D443862841A389C8730C7DF0C0FDD3E36916872841E8F293E0AE5FF0C07E0FFC429987284180B6CA651F40F0C0C5C22462FD872841B43476556C1EF0C04CB7DEFA498828411125A43C6201F0C06D89600929882841F07D5D64FDBEEFC00763BFE9F087284170C841879A6DEFC07BD77B48058828417E925289D025EFC0D102A0DB2E8828418C377596D8D7EEC0873002E504882841636F3DFE9C89EEC0E01032F5E1872841132157D50C32EEC085982D119886284139D18C5FCC79EDC0BFB8F9721A862841F5A5B5DA7715EDC04EF8E7DC4C8528417A4DF10F82D9ECC00D9B92CE378428410FE1306ACD76ECC092AFB15275832841D03743C505EEEBC04F25A216F43429416EE02897C43DECC058D4F1FAE6702941B12B3E58C975ECC090F2947D18DC294183F72491B5DBECC0A7ABA2F72D3D2A41F7A62ABE2E29EDC0CB84C9DD9FA42A410D58B29E3A81EDC026E40CF04BC92A414F9ACF1ABADBEDC08526F10063F32A4159EB25585CF7EDC056970E0481F32A41DC4A887A59DDEDC0DB55F64093652B41556EF62CA8F0EDC0F256A0EDF8B72B41F18D5DEB1111EEC057C455A3F6E12B413BA3405CD639EEC0988865CFF6582C41A98A2A2A7A5DEEC04F3D0F283A822C4145ED53079A83EEC0E8E56A105EAB2C410AAB47A1DE8BEEC0ABD8936806D42C411C9EBFF119ADEEC0B3C17A0EC97B2D417ECB5E820BF1EEC025278343B9AA2D4142671840852DEFC0E55FB3AE052C2E419C488DA4C689EFC03F0398322D9F2E411E93FE11BADCEFC0270C1D0486A92E4134D2F6B923E8EFC0');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('29','35291105531.018','961818.240','30','30','Franklin','21',NULL,'53021','53021','1266','810172','49347','9280','0.192','0.015','4157','0.084','310','0.07460','17024','0.345','4384','0.258','30442','3863','0.416','1080','314','0.034','306','61','0.007','944','144','0.016','18','18','0.002','14386','4413','0','2171','467','0.05','19.21','8.42','7.46','34.50','25.75','41.63','3.38','0.66','1.55','0.19','47.55','5.03','15840','456','0.03','23154','19859','0.45','809','0.75','3.07','75.16','44.62','County','1.52','49826','61725','always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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('30','49087811276.968','997332.724','31','32','Benton','5',NULL,'53005','53005','1761','1126901','142475','14517','0.103','0.024','14662','0.103','994','0.06780','42341','0.297','6168','0.146','122789','10180','0.701','1198','248','0.017','977','139','0.010','2934','236','0.016','141','9','0.001','10318','2964','0','4118','741','0.05','10.28','10.29','6.78','29.72','14.57','70.12','1.71','0.96','1.63','0.06','20.42','5.10','22338','669','0.01','18027','18707','0.14','631','0.33','1.27','33.40','14.19','County','2.37','144442','156351','always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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('31','20028996268.019','805020.804','32','31','Garfield','23',NULL,'53023','53023','718','459802','2397','334','0.142','0.001','497','0.207','48','0.09660','624','0.260','108','0.173','2342','309','0.925','0','0','0.000','6','4','0.012','5','0','0.000','2','2','0.006','8','3','0','34','16','0.05','14.22','20.73','9.66','26.03','17.31','92.51','0.00','1.20','0.00','0.60','0.90','4.79','0','39','0.04','22','45','0.02','37','0.03','3.95','2.69','1.97','County','0.06','2317','2294','unknown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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('32','24380183798.338','796092.773','33','33','Columbia','13',NULL,'53013','53013','875','559692','4064','507','0.127','0.001','764','0.188','80','0.10470','974','0.240','153','0.157','3768','466','0.919','3','0','0.000','38','0','0.000','41','5','0.010','0','0','0.000','145','26','0','69','10','0.02','12.65','18.80','10.47','23.97','15.71','91.91','0.00','0.00','0.99','0.00','5.13','1.97','607','61','0.04','269','236','0.06','50','0.11','3.62','10.85','6.15','County','0.08','4000','4022','never','1','507','12.60','753','547','13.60','812','7.89','40','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('33','36243281227.743','927130.388','34','34','Walla Walla','71',NULL,'53071','53071','1300','832031','55180','7567','0.151','0.012','8116','0.147','645','0.07950','13437','0.244','2523','0.188','47141','5646','0.746','909','40','0.005','594','121','0.016','772','89','0.012','45','0','0.000','4474','1337','0','1245','334','0.04','15.06','14.71','7.95','24.35','18.78','74.61','0.53','1.60','1.18','0.00','17.67','4.41','6111','321','0.02','8719','8379','0.16','2721','0.32','1.63','31.98','16.19','County','1.24','50482','52237','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('34','17879149742.106','635698.706','35','35','Asotin','3',NULL,'53003','53003','641','410449','20551','3132','0.154','0.005','3337','0.162','216','0.06470','5224','0.254','1192','0.228','19634','2889','0.922','21','5','0.002','184','47','0.015','104','48','0.015','6','0','0.000','124','8','0','478','135','0.04','15.43','16.24','6.47','25.42','22.82','92.24','0.16','1.50','1.53','0.00','0.26','4.31','63','135','0.02','374','576','0.03','175','0.02','1.61','1.72','3.01','County','0.51','20245','20750','usually','3','3132','15.40','4102','3652','17.60','4783','16.60','520','SRID=2285;010600000001000000010300000001000000A60000006AB4B6DC6AD0434106A9466DE4B306C1E3852DEBD9D14341C6E9223074CA06C1A5C1F93999D24341C6A1D4BD86F506C13B56AC3437D343414B31EAA4510007C168D125A01CD343414F85353B8C6007C1E76B8D9A92D14341A121F8E7849607C116C145BD9ED14341F34AD19B71BE07C171A2844BA9CE434143E5290CB4BA08C1B3DDA8646DCD4341675333F3D9DE08C18E32E28FCFC843410216E8C80B2E09C101E2C33071C74341B2AE94D2526209C11F5E7AC03DC74341AB30D22E927709C11376418295C7434186CD91FE9EC909C11E273E2990C7434114E428B496F109C11AE1A7CF56C84341D4E412FD73190AC1ABDFFF6CE6C8434137E64B067D290AC1A93B2B4373CC43415CA8E2028F550AC180220C3063CF43413663CDAB6E680AC1B72C4213F5D24341063AD05E3A690AC10161CF3F14D64341DB054207956F0AC1FCB36B8EE0D74341D7E5F4A46C790AC13D49405CF5DA4341943601A05BA10AC1B93713429FDB4341D6AFD66573AF0AC11EE9A844DFDB434158733C9A72C10AC1BA732E3449DC4341023E4B49801F0BC15ED4C0CEDEDC4341F8BA716B32700BC1022579878ADD4341C5014792F6910BC189BBF489F8DE434195B685563FB60BC1AB63682723E24341C141795F69D60BC1118241E07BE5434198F47660DC080CC15C49B3A87EE7434190347FC664080CC19C07F24198EA43415BE08E52101F0CC1B3A107734DEE4341D16FD26C5B440CC1A25F6EDE7DEF43419730B28DE2690CC197899CE83BF0434101BE18A424920CC1D601199A05F0434166874EDA6CB20CC1117878B5D0ED4341901175805A0B0DC185D735A860ED4341C5A8702A2D270DC1C7646A7B9CED43415AA2A68D0A420DC1A47BAA10F7EE43410E0E760E985E0DC128B55F62A7F04341927C9A566D780DC14F2D44DBD3F54341914D1A715EB90DC1B998117F6BF843415B16A997A0E80DC10EA3F46CB2FB4341A3FC2C42003B0EC144D7A79B62FC4341CEAD0519C0670EC1CD0D8D7F9EFF43416EED1EBADCDC0EC17AB13A8EC0FF43418F7B82E836160FC1F8123A4F0E0144411378231B03420FC1B8CEEDE75DFF4341589D2E9E8EC00FC1E6CBE0EE26FC4341B376BFA7BC1F10C181A6C363F5FC4341B9DEB905A03E10C1A87A735125FE43418F6686B2414E10C1799052AE8B034441E4A4371D117010C1E7D203F4830544415F541564DE7D10C1009491470E084441D45DB2A5FC9910C1EE56514B67094441ADD7E9494D9F10C1A02EE7057B0A44415E8F07172EB110C1EA00F861430A4441D854ECB327BA10C11F31F354DC0C44418C01B6A09DD710C1234D570CE20E44415921400E7CE010C1C8D663CFBA104441CDBBC35E0DDF10C1DE9445E7EC124441298018A915EF10C1C68B37514B1444418DDE0468A31011C1D8B36EA96A134441BB668A8E552911C125A437F12D0E444148A35418FF4C11C1D031A820CB0D44419B05F470155511C14B7571AAC70D444114D160B0768E11C13418B053A10E4441A38905F1519C11C1E4B8A051DE0E4441F17BA7D495AF11C141BE6D0BA40B4441F230118215CB11C11221B32BEB0744410513445F9BF311C16059BDD22907444103181D3FA51A12C145D6828632074441584F0B16D24812C188A8A2AE090644414AFE88AD4A5F12C1682E09A4AA05444160A1D8D38D7B12C13E440A7470034441648934E0248D12C1A88DD1A5C6FB4341D8990D9A0E9A12C17E20F4C77DF94341F305DBE2F7A912C113BE843554F8434179767265DABC12C1124BFFEDE7F84341E850AEF623D412C15F11E5B1F8F84341552E80C623E112C1AE9C9572F4FA4341EAC84076E10013C1BCD26CC9010044416C3E4747561013C1587D66D8C00244415E65C9F8E51213C1F6289CCC5F044441ABC62EA1560E13C1887BAE6DB905444193CFC972581613C10BEC4BABF3094441A807D65CB93E13C1BCF266C6480D444179B112696B6013C166E86E32160D4441E76B30E04C8413C12FD01BCDDA0E44412D395D050AAF13C1089C78CDFC0F4441C52BAB6906C013C12EB6341AC911444122A2AF1390C713C174ECAE8CC213444113F4586B4DDA13C121ACA1DCE1134441DAA3EE8E32E813C12FB18ED3D714444187D5A8E6B2F313C160E7FBC95B144441F61B90CA2D0E14C17B70F1D74B154441691D30B63B4214C1512BB13D28184441E86E13036F4B14C133ECA89A3B194441C81CF126A15A14C1E2D70BF53F1B44419E998F6352A614C172F1D6D26E1B4441D1939F777EBA14C1C60FD2702A1B4441241E9213FFCB14C1CFFD5C783DF743415DA1FA897ED914C139B21F888DE043411643D171AADF14C1FFD732F3ECDD4341EF86ACB1DBE714C1FBF151C934D143414B0D5A62D9E414C1061877D7978C4341B6263C3FB7FA14C10024BC93C44C434130197234570F15C18B88D4279743434149C5E662DC1F15C177906D909A314341D1E16234351B15C128C19EE90F204341831912D3F42015C1C66D3A3D430543412DCF3F96C52E15C10A02CA0D1A0543415DD0FDCBDA2E15C1E6A35ECE17054341D8CEA75C4C2D15C1EF905D8B1B014341D4C96B582A6A12C1D131FE0D251F4341D176E009156112C10CF7844999194341E18F0CB7EF180DC113A8370A02194341C377F462DC170DC1B80638D59C174341F3D95B4AA11D0BC1706A4AF5EA1643412EFB660F232309C13B4A51C9442143412932E468C81709C19A759B50CB20434171C048335A7208C1577B37EFD135434147D5808A7E6708C12C65A43939354341150DC9412DC207C1A193169DEF68434103ACE542AAA607C120653D35BC73434154B8401EC89B07C103F2A6A0627243413E275418701D06C1A7C1D2CFDB7143413E2F7CA8185605C199296344A773434109ECB2BD886205C11C6381E2287543417EB0F427206805C12B800D694777434146CEB32CB57905C1204F5A945B7A434187DBCA5846A005C1E1324320007D43411B9EF9579DDE05C1D9C417B4017E43411B49BF9E06F705C1CF19D5F1B67D4341236402EFE20C06C141A0943B667C43417CAFC8B5F43106C117049F2A0B7A43416EF848DCA3AF06C1F6DD057B637A43410CD90BFD5BD406C1B69EB44D4D7B4341E61C848A2CEF06C105B7EA49557D4341161710293C0707C1CDEB34CF248143410C8C4FC55C2807C1772F6C006D83434132CE1B191F2E07C188FA3B0F1C894341525ED1B3C71F07C13B8B2864A38C434121938E35690907C154970957CF8F4341134DEBED34E606C1823AD025D49643419310806EC8AF06C1CA80AEBD269A4341D1F67A31B6A206C14E21E04B8B9C4341C0A8B0A4BEA406C1BC9505B8879F4341F4EBE0DD17B506C1C81016E397A24341C301BC6DA7BF06C1EEB9E07B7FA64341FF5A55E4E6CE06C178E6853FC5A84341C321F7C488DF06C14F9AA4A4ADAA4341349B410328E706C1657CA656AAAF43413F79FA96790507C137ED7A146EB24341632B07DD580F07C1642F991B77B54341D1900C13FA2507C1E4569E907DB74341A0ED2C97342A07C116E39D46CEB843412E76D937A92507C13A8DC4B652BA4341D2DBC784C41007C1AEC813094BBF43416851FCACDCD706C1F7CD5B96B0C14341A7AE6EA4CEB406C1919DBB6185C44341686F52A39D9B06C1BF8BCCDABCC7434120F75933588706C199C32E6F17CA434101EBC985CB8306C18FFDF987F9CC43418B3E4382BC9406C16AB4B6DC6AD0434106A9466DE4B306C1');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('35','46990353703.322','996062.374','36','38','Skamania','59',NULL,'53059','53059','1686','1078750','9872','1281','0.131','0.002','1088','0.110','84','0.07720','2638','0.267','492','0.187','9229','1154','0.901','21','3','0.002','279','86','0.067','48','0','0.000','14','0','0.000','93','9','0','188','29','0.02','13.12','11.02','7.72','26.72','18.65','90.09','0.23','6.71','0.00','0.00','0.70','2.26','248','148','0.04','331','455','0.05','56','0.05','3.94','5.07','4.93','County','0.21','9930','10604','usually','3','1281','13.10','1587','1177','11.10','1458','-8.12','-104','SRID=2285;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');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('36','32544714321.078','873879.846','37','37','Cowlitz','15',NULL,'53015','53015','1167','747124','92948','12765','0.140','0.021','12331','0.133','780','0.06330','24866','0.268','4833','0.194','85255','10852','0.850','418','128','0.010','1511','376','0.030','1259','319','0.025','145','14','0.001','1842','594','0','2518','482','0.04','13.97','13.27','6.33','26.75','19.44','85.01','1.00','2.95','2.50','0.11','4.65','3.78','318','746','0.02','4213','5190','0.06','978','0.12','2.08','11.56','6.00','County','2.09','92280','95347','sometimes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
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('37','7993259300.365','416423.725','38','36','Wahkiakum','69',NULL,'53069','53069','287','183500','3824','301','0.081','0.000','711','0.186','18','0.02530','895','0.234','100','0.112','3577','278','0.924','7','0','0.000','87','9','0.030','7','0','0.000','0','0','0.000','25','2','0','121','12','0.04','8.06','18.59','2.53','23.40','11.17','92.36','0.00','2.99','0.00','0.00','0.66','3.99','0','24','0.02','35','157','0.04','59','0.01','1.55','0.66','4.34','County','0.05','3713','3755','never','1','301','8.10','376','383','10.20','478','27.24','82','SRID=2285;010600000001000000010300000001000000230000000D7466488FB02F4107F181CAFC3D0AC1F4E190B1AEAF2F416094BAA4AD1F0EC1E055E9AE55A72F414A319358292210C1F695380996A52F4158ED9ECA61F210C1DBE6024214AA2F41B240D02590F210C10258960FA5A62F41D2B7BAD1C1D711C14828EF82A0A62F4168DC4E23F1D811C164F3EBF5B7A52F41B1AD7EE606DA11C14AD6F06554812F41AB3BB26D29FB11C16C7A3764AC402F416B4819E6974E12C1329663A95FDD2E4150EDCAD1527A12C10223DAF76A462E41EF07D121184412C107C6233D18FE2D41562EF934EC9411C1D55F6FF105FC2D41FD39C61BCB5511C1492427B37A0B2E41AD9F5C89F9B910C19EF272DE77FC2D41C0A2585DDC3F10C1FEF2409EC9E02D415B7D85E32A0610C1CE138B211DBD2D41DDAB0118C6710FC10BC6F2E825772D41449532156A0D0FC1431EA1BAC5272D414103A6E524770FC1E112605BE6CE2C419EDD6A4349970FC107052E6FA0512C417BDB19CAC8670FC1D50D7F1183032C416DB975D9D4C10FC1A98500B5A6B62B4111C07FE4260F0FC12244FF82CBB52B415FF8768F660D0FC1D58C40A6D5B52B4151CB52673A0A0FC11E8AE7DA90C52B41443390E2921D0AC195AB1EE258C72B41C43B07FF6CAE09C198D97BFAFC652C41019544CC14D309C1FE13BB3D1E5C2D41A0EEACE674FF09C1F1B113FF48792E410E153770F0210AC1D26D72AA709B2E416299F5263C280AC189355C8A94682F414CE422D080440AC10FAB472EF1862F414A9FE144483D0AC10D7466488FB02F4107F181CAFC3D0AC1');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('38','18317364486.371','646147.561','39','39','Clark','11',NULL,'53011','53011','657','420509','345238','31027','0.091','0.051','33058','0.096','2180','0.06590','98944','0.287','11807','0.119','305837','25070','0.808','5199','1036','0.033','3148','412','0.013','10622','1138','0.037','1329','107','0.003','7262','1394','0','11841','1870','0.06','9.09','9.58','6.59','28.66','11.93','80.80','3.34','1.33','3.67','0.34','4.49','6.03','1428','1368','0.01','16091','36539','0.11','2120','0.10','1.08','10.18','11.48','County','5.07','356584','399070','sometimes','2','31027','9.10','42480','45893','11.50','62833','47.91','14866','SRID=2285;0106000000010000000103000000010000005F0100006B255FDEF38933414E4B73DB2FE014C1AC62EAED458B33418C2E393FBFE014C1D16744E39E8C3341D9351E7EB3DF14C1FCD326DF218E334111A3BBFACEDD14C1C079EBB5C78D3341127FEC729C8015C1ECC967C6D28B33413DC7F81BBEAF16C1B8338023AF8A33417274DF96B59918C19EEF11E2668A33414D061454560819C11111250F398633412EE42990130819C139E5C790B585334131AE45694A5919C1E3E68FB604843341E75013BBDA041AC1D12EC4C628843341517180A6064E1AC10652E6C58982334154BB0412E0411BC1CA5ADD963E823341DB7DDE95F03D1CC1E511175CE7813341F8B2C15E78731CC11B7611960F80334156A7E71CCE9C1DC14ACDBE991D80334113AC0DADC1E01DC19E71A8E2EC7F334185E33AFCF9681EC107C8C2A3D17E3341873E6050A91B1FC1B27F29CDBF7D33410F7DB5D50C0F20C1E94234D0F76B33418B917CC6AB1B20C10314EBD2704E334170CCF83A191B20C18269F61C322B3341A2159577F70B20C1D4D33699B41633417A8B38710AA01FC1A3A5219220FB3241778C01690D781FC1D4C7D151C5EF324127B165ED3F7E1FC1E2B3BB896EDB32410CD707314BA51FC17A6E664E0ECC3241443E5D95E9B01FC10DA8693E42C032411559E56578BA1FC125479E5D37B13241AB19ADF7EFA21FC1B15A7A9BA89C324183E12825E3611FC1DEB2660C898832419088A29D88401FC1107A79576F6B32411EC9FAC5DF1D1FC1ED2BB8958F543241EE79A835F3F51EC1A9EE06D13C2B324140C99EE2B2BF1EC196013A3FF11832415A4085B934AD1EC168824F131BF7314199C13B67F9A31EC1F06528C696D331412592DA6B806A1EC15FC170791DC731416D3E5D9CB04A1EC141960B2BCDAE3141DFB732E274F81DC1FC469D0113973141C3C0D740F1D01DC15452BDAFF37D3141436EF39690851DC1F27C41DE2B743141A2E17D60E5FF1CC19807E13825773141C7772A9E348B1CC1C85E385FB584314186F263ABF1CC1BC183A3770F1B84314153688ED276401BC19C2CA3C9E37C31412E66C6E5E4C51AC1B9CDE0F21964314113456D81061B1AC1B7443FF83D64314124F23D92D9C519C183705B7D256F314151054D2DD85919C1B8EC512C966F314159697CC8FA3419C1B156E7CCA77331416CFAF5CD363319C1F3AEA1523476314103873A25FB2D19C14FEFAAB812783141EF35F8B50D2619C1FEB6E7A2B4793141B1A0C3A5AA1919C1EC3E39B17D7B31416B695044891119C15812E2FCCA7D3141069E171EE40A19C1BE4E07994A803141AE984FA4430719C105EF2320D3853141FA24FA3552FB18C14CCC7969198B3141042C80D3F4F318C18269A4D5A28F3141545A877C91EF18C100B2FDA3E5913141BDFD43D884EC18C155A50528319331410A393DDF8DE918C14D2FFCD02D94314148C9F1B2FAE418C1928B4D662B97314144A014DE59D518C157F85047519931410DD3277C43CC18C1239393A9189A314151B2B12780CA18C1DD4D3048BE9B3141CC7BF60665C818C119750EA94A9F3141549F0FD9ABC718C19749722D3CA231412313D605BEC818C1F1B1AEE74EA631415F74FF2E99CF18C1131A069851AC31411E4B86140EDE18C18F3D27C6B4AE3141A72BE085EDDF18C1CB018A26AEB03141AD4B50552CE018C1F18A3CC67FB131419DD09B4EA0DF18C1A0704389F0B131417B5F22BA0DDD18C10EDDDB0436B231411A7A39B158D318C179DC86D0AAB13141817AF483EEC618C135954398ECAF3141D0F8F67E80BE18C11A91B16031AD31411B22D01155B518C1B8A150301DAA3141EE5A5BD979A918C1332F739382A93141BEE5137123A618C120F7CB9883A731419A841D7D319918C16A6C4C9E7DA431411A698C8B437D18C1F121AA598EA331417A3BD023E46918C1B9F057C2C8A33141F7802FF5A15F18C1C3137B29F9A53141133757536B4418C1A570D948A7A531419402E351323C18C15560189462A43141F8F43C99CC3918C11C851E47C49D31418A2A3D3C3A4718C1E2D664BCCB9B3141660E5091094A18C1581BD63A109B314195592E67964A18C1E2DAE018E09831419C21AAB3814818C125237EFDEA963141E23DFDC7914418C15891F1A6DA953141798269F2963F18C1385D6D00009531411F235FC8513418C1AD7959B02D953141183C3EDC6B2C18C1E2E6DB394296314184D25CC0BF2518C1676DD9D41398314120C1537C132018C121EC43FD159A3141E295C187D51C18C1A97018877E9E314144330511EF1C18C190F2B71459A031417FE5FDC2A71918C116696EEF16A13141B3E9D2B4C91518C16F6E9EC298A1314185009E2B4FFA17C1BD8EB7CAAA9F31415A951B45E0E517C1D226D0246B9F31416A544887B8D817C19A834860AF9E31413FEB449A55CE17C117138B44709F3141E07128BA80CA17C1CB4A180156A131410439C13C1ECA17C1F173ED0B82A431414292743A52CF17C16EDA67F0ADA53141396D20ED3BD217C1A4D83978C2AB314178CB21DB53CB17C1BBF515A9E0AD31415BCFDCE346C417C1ABECFE4672B031412470A545DAB117C12D5BF2CF39B13141FADB6629CEAA17C169AAD7EBC8B331413ECD0158589F17C1BA3760C1B9B431413D9DB51C879117C12C2D4AE1CEB431416A50F567678F17C195555302BDB4314112787427688E17C1E5F1FB18C2B231411AD0E7FC207217C18A9D5816E7B23141987C1413546A17C1A447C919FEB3314113A2BF647D6417C1CB3BBA33CDB53141EB86B661EC6217C1CBAD10A678B731413F80B4D03C6517C19FFF539097B83141E4841BF8186B17C1425B858834BC314199800423AA7117C1619FC68C04BF314141544F1E417017C16A9F200335C0314179B14A554E6A17C1D2CAB9FFCDC1314172E417FE376917C1237D5755D8C53141987AA9B2F45F17C10D6BAA4AFDC73141E5DCDD74EB6017C1AF53CAC73BCA3141C8D8EBD1D05A17C1A3BBA3798CCA3141B7D983D00E5517C16485C97185CB31415E3F55F4785317C1DF4524B4F3CC3141038011283B4C17C14E194B62D7CC314130A885D8A83B17C1424F5810A3CE3141F6F307D3873717C1CE8D9C8594D13141901EAC9E393917C103E6320C01DF31416A37EE8D6E5217C129E14C3B2FE33141EFD75A10DD5317C1B6FBB50498E5314197899216A65317C1E09C19EE5BE83141AEC79DE2475C17C111E06989B9ED3141FB2550C2CC6B17C1DDDCC8F41DEF3141A5E5CBC9567517C1055C6D4A9BEF31410D21BE97527E17C12AD95CDE60F031419F90BEBD308517C1AC2CCCA75DF13141711B8F5EAC8817C17EA9271E89F231414BCDCAEEA28917C19DFD9AAC50F43141E18F7B481F8517C1708D60BAE0F63141B98FB1CB1A6C17C17D216ACFE9F83141022BDB91E06317C15E4E2F0EA40032417FB66BCBC25017C1FC5892669D02324117CAAFD5CD5017C1AB96590117073241B8EF96DA0F5717C1550912363A0A3241C4B586EDB45C17C132F51BC4780E324149ABE147546017C139513851201032415C5B5294936017C104A606043B14324150A87D15825D17C1EBBC3E0D6916324136A1C03ACE5917C13FF7642554173241E1655A16925917C100C6F8E9971B324199E4888B386217C1B6BE9DEFAF1C3241C5E08BF2EA6117C1155256E5041F324143D0701FA75817C109C2953783223241FE43E4996A4E17C141151F83992532418788F97EC94717C1E3D8B960162732413C87B6162B3C17C11B3697363C2A32418B197CFB9A2D17C18411CA34622C32419242A5884B2817C17185C27FBA2E32414EE590E7332617C1B62C2EBA2C363241E3C1852C4D1817C12753B07ED139324177C2C03C9D0117C1FBF3B3DABF3E3241B679EFAAF1F716C1AFD1942ABA4132410DBABEACDFF716C189DA5B2A5D4732418089060E1E0517C1459D4AD92B49324142FDE1C39E0417C166AFBF60024B324107EA4836FE0517C1FC09CE03CA4D32416DCDEDBF570A17C12A2EE61C78513241774D60078E0A17C1496448E31554324104935088850517C1413108DDF75532410558911399FE16C1C85A62CC5C5632418CE261F568F416C135D282D1BF573241FCE1F8B8FEEB16C1C0FE03C6B057324156E31274B1E516C174125C7C11583241459051E305E316C13B6B6E460F5C32412EDABC5FA7D616C18C99E0475F5D32410979D41FCAD016C1B0E2F11DD3603241F35DD2D454B216C15753EE66636632416CD705FC1EA716C183426B42496A324195F2807915A116C11B309A76D46B3241BADC86EC0E9A16C1EE010E39456D3241FDF58D969D9816C1D134D30D496F32411CB12E1FC49216C11195B725E46F32419B03AC85F78F16C1FBBE72F7ED6F324183ADEDE1378C16C1A4703BFCF26D32411AD4ABB4CC7F16C19A1F6C77226D32412C6195810C7A16C1D65E3CF5F06C324104D47BBB6B7416C1050C0EADCA6E3241313AE6F86C6C16C1764FDDFAC2743241C2E64BC8E66016C1FF5049532F7832417856EB8C895816C12CE11CF77E7A3241E95F1C7F715616C1D3304949E67C324160E64D73605A16C1FAECE08C3D7F3241193BB553185B16C1B0EA8D47FB82324145E8247F9A5216C1F54F642B4285324174B9C94C0B5116C1459298DEE486324129C051D9E35316C153F41A4FA4883241855B33D9796716C11F596871578A3241F4513836776C16C17B6C9F21C4913241F80171355C6E16C1149AE9AE02933241E9904B314C6916C1EB5264AA4993324102689C0DCE6116C14746C333CC9132414EC1B469DB5516C1E040BCD37991324104EDC11DF14B16C11121588F269232412CAD4779894716C145940DE717943241B8B215D9B34516C1B9AD4AD5149632416D2F4C389E4716C1322F375783973241334CDEEA004D16C1D13AD1678A983241A9D0D3A4635416C1FB743319BD9A324147BBA45A335C16C1796E5818139C3241A3487500F85D16C18F1522F0959E324107FBD5DC695C16C161EB98C9979F324178BEDF529F5916C1EAA488E334A03241EBF5B0E3A95016C17A7264B337A13241BEE4813BED4A16C1BE55BDDA65A63241ACCF1CC5D34116C1AC8108BBD3AC3241F00E21D17D4D16C1A2CFB07B39B0324166DDDDD37F4916C1AC2B1F8B6EB4324136819762FD4B16C1CA45914197B632413A8E52439D4F16C196C832EC24BE3241A3FA6EBE6A5416C1C052A6B07DC43241E5416399835F16C17353D10720C6324119AFCF36636616C1C207E07B90C632411AAB6F4C277216C1BE59F99BABC632412CD7EA5EBC8216C1B101B349CCC7324162170727CC8816C1988FD703B8C93241D01FC69AC28A16C16FE26E666BCC324129EB04F2918816C1C421973734D03241F46BE65B8A8F16C1C112BD4E28D23241577E6AC7D89016C10583A8B99BD43241C13400DC1F8A16C1A7C381A2FED73241D832B6041C8416C15949BC4E84DD3241F5FCC623DA8416C11D602B172CDF32412B9F1F23798516C198F872EDDAE03241D8D4A5D94D8816C10AC51ADD92E03241A4CCB293699316C16504F5AD12E13241586FB31D939716C11855201FCEE13241D05EF57E869816C1E531001366E9324125C19262219916C1ED9C74BACCEC324186EA9EC70B9D16C1BA0D31C967F132415851B6D23EA416C15D62C205F9F4324191DF87074DA316C157B735DDECF93241C734AE76CAB416C187DB63856EFD32413D753BAAF5C216C1B79AD190230033413456704761C616C19DFE229B41033341AFA38B2FF6CC16C18B1E466F76043341FF04809D1ED116C1FDC218F7FB0633415455C7444FE216C18FB4E60AEC0A3341377D61348EEA16C1BBA0B4ECF30E3341501521C14EE416C10C307205A91033419EA54D5F67E316C1DD10A57F1D143341921776441BDC16C132910AFBEC16334175AC931407DC16C149D85F9F7D173341331A66561EDF16C1E5493B3F6017334112F47881E6EA16C1DEF8A9212E1833411B27F39EC8F216C111093423EF193341FFD30832AEF916C15878F56E5E1C334128A7B07E18FE16C194221B66C51D3341B35BB93A56FE16C13106FD6F69223341D176CDD404F416C1879ADBAE702433417AD9E390A2F516C1B908E7EDEE253341FCF5CF1675F216C1029F0886F1263341532F99840FF116C1A80582C4AF293341D9F5B25DBFF016C1F9AEE5DCEB313341EEA7283F02DF16C1CAD9EA8C493333415EEF5B39ACDA16C1F445896B8B3633417C8B30B8BEC816C1D42DDE3C14383341F1A19CDA68B916C1CE44E613753B334124F75D2BF9A616C1E7A959D7723C3341540154CAFA9B16C1E14CFF3A863D3341D709D517F69516C111029B680B3E33413E7EF50EF69016C1AAFA9493283E3341E864F1ACD98D16C19D8F8FC0B43C33411AACD88E587A16C1F6F33906223D3341A3A5A569B06F16C1B862AF31B03D334103E512E0A26A16C12AEB32FD1F3F33413E065F50156716C11957ECD95A42334185E59766626316C1604DDD24DF43334180276ACB946016C1266E0CCC7844334181B5661BAD5B16C16E9070C5394533418412311B694E16C19ABB53DA434633412BB3CA2C194A16C10354DD3E8F4733410B33FBEA003D16C1523577B5CA473341EE43F223D73516C1D9D8D9055E4633419C493DDC7C2C16C1BC6A4D75EB443341194B1F77692816C167148797663F3341017EE7D89D1916C16F460C318A3E33416B07DD72041516C1E56C6349E43D3341E77CD719680616C1545B1C511F3E3341FB1E585EFAF015C12E1F107AE13E3341DCAD03AE33E815C1E736B471C13E334159921F93E8E315C1EAB00BE68B3C33417A211D4E4DD815C17F08C340103B3341D54718FD4DD415C164444708973A3341113E2891EACF15C17DF5A36BFC3A33415C0D68AAD5CA15C16E58A84A993C334174B19E78F9C415C15369B7B4D73E334159ECC218E0C215C100F0A90FAE4333417FBFC95504C815C17B527307AB453341157809AE4AC415C1D7E97F8E0C493341C544CF7CD3AB15C15B1C4F2274493341A0423C2C64A215C1DA566F3D1D483341376409390B8E15C19BB561AC264A3341B12107A76D7B15C1965F9A8D574B33413AC05FD7946A15C1ADD560B88C4C334150EA9DBDA86715C12F3EAB2B2B5133410857D767566515C1C83D112337523341883633E2656315C107BF1379335533414DA4E0CEDA4E15C15B56CF004D5A3341B1A89B1FF74115C10DAD63C0575B3341CDEFAB66B33D15C16D05F0CA385C33414B5D498CD13515C1C92D7551C45C334187771B3C872D15C10FB3C0895C5D33410DD237C566FB14C1542F33DE1A5E3341D628284AFDF414C1F53A4A5C255F33416B8C094687F114C1CF9188A84860334102459ABD03F114C13DCABBD396623341DE47E94633F314C1D0369601A3653341B6BBBF840BF014C13C08B91DDA673341F533CEE686E914C1CD734F70D46A3341D6B99AA785DA14C13950EE06587033410449F1D342C214C1EF576EFDEC7233419F409821D2BC14C12916240A037533413A2C3AB4E9BA14C1CF787F6AA27633416B8FE3D09BBA14C1CABD0E8A4D7B33413F28B49D0CBE14C130EA842E687F33411752EDCF8BC414C1B423CAB1B3803341FA2A21EB81C514C1FCE8F0AA0382334188AE60A9F2C714C1037894D4CC843341687109728ACF14C13EFCD4E2578533419D834793D1CF14C1D4E21D0AFD8533418C8584F3B9CE14C1043AF05CA886334113249F9478CE14C16CAEF77A97873341B792F9C625CF14C13CE345314888334177B74E7646D014C1B693CF7DD388334114ECFB1AD9D114C1E379800AC3883341C88743D1A6D414C136C8B4CD0C883341355B9A5CB9D714C160BE91BAFE873341F1B5807CB9D914C13C40AAF82D883341B3AE2A5057DB14C16E0861C035893341C6F35F9FD5DE14C16B255FDEF38933414E4B73DB2FE014C1');
INSERT INTO "counties_pg" ("id","area","perimeter","county_","county_id","name","fips","lfips","stfid","stfid_num","sq_miles","acres","pop_100","pov_pop","pct_pov","povpcttotp","age_65_up","pct_65_up","poor_65_up","pct_poor65","age_17_und","pct_17_und","poor_17und","pct_poor17","white","white_poor","pctpov_wht","black","black_poor","pctpov_blk","amind","amind_poor","pctpov_ind","asian","asian_poor","pctpov_asn","pcisl","pcisl_poor","pctpov_pi","other","other_poor","pctpov_oth","mixed","mixed_poor","pctpov_mix","ipt_pov","ipt_65_up","ipt_poor65","ipt_17_und","ipt_poor17","iptpov_wht","iptpov_blk","iptpov_ind","iptpov_asn","iptpov_pi","iptpov_oth","iptpov_mix","farm_wrk","no_phone","pct_no_ph","hispanic","non_eng","pct_noneng","institutn","pctpov_hsp","ipt_no_ph","iptpov_hsp","ipt_noneng","type","iptpovtotp","pop2000","pop2005","dcases","dcases_num","p100n_00","p100p_00","p125n_00","p100n_06","p100p_06","p125n_06","p_ch_100","diff_num",the_geom) VALUES ('39','53164354840.305','1157173.936','40','40','Klickitat','39',NULL,'53039','53039','1907','1220486','19161','3236','0.171','0.005','2663','0.139','392','0.14720','5144','0.269','1174','0.228','16624','2402','0.742','46','19','0.006','639','302','0.093','118','8','0.003','83','29','0.009','1107','338','0','544','138','0.04','17.05','13.90','14.72','26.85','22.82','74.23','0.59','9.33','0.25','0.90','10.44','4.26','2079','246','0.03','1532','1907','0.11','113','0.13','3.29','13.41','10.61','County','0.53','19167','19563','usually','3','3236','17.00','4230','3404','17.40','4450','5.19','168','SRID=2285;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');
END;
