-- SQL Commands for the Demonstration
-- 
-- 4.1 - Simple Spatial SQL
-- 
--  create table points ( pt geometry, name varchar );
--  insert into points values ( 'POINT(0 0)', 'Origin' );
--  insert into points values ( 'POINT(5 0)', 'X Axis' );
--  insert into points values ( 'POINT(0 5)', 'Y Axis' );
--  select name, AsText(pt), Distance(pt, 'POINT(5 5)') from points; 
--  drop table points;
-- 
-- 4.2 - Loading Shape Files
-- 
--  cd \workshop\data
--  pg_setenv
--  shp2pgsql -i -s 3005 bc_pubs.shp bc_pubs > bc_pubs.sql
--  write bc_pubs.sql
--  pg_shpsql
--  psql -U postgres -f bc_data.sql bc
--    
-- 4.3 - Creating Spatial Indexes
-- 
--  create index bc_roads_gidx on bc_roads using gist ( the_geom );
--  \d bc_roads
--  create index bc_pubs_gidx on bc_pubs using gist ( the_geom );
--  create index bc_voting_areas_gidx on bc_voting_areas using gist ( the_geom );
--  create index bc_municipality_gidx on bc_municipality using gist ( the_geom );
--  create index bc_hospitals_gidx on bc_hospitals using gist ( the_geom );
--  vacuum analyze;
-- 
-- 4.4 - Using Spatial Indexes
-- 
--  select gid, name from bc_roads where crosses(the_geom, GeomFromText('LINESTRING(1220446 477473,1220417 477559)', 3005));
--  select gid, name from bc_roads where the_geom && GeomFromText('LINESTRING(1220446 477473,1220417 477559)', 3005) and crosses(the_geom, GeomFromText('LINESTRING(1220446 477473,1220417 477559)', 3005));
-- 
-- 4.5 - Indexes and Query Plans
-- 
--  explain select gid, name from bc_roads where crosses(the_geom, GeomFromText('LINESTRING(1220446 477473,1220417 477559)', 3005));
--  explain select gid, name from bc_roads where the_geom && GeomFromText('LINESTRING(1220446 477473,1220417 477559)', 3005) and crosses(the_geom, GeomFromText('LINESTRING(1220446 477473,1220417 477559)', 3005));
-- 
-- 4.6 - PostgreSQL Optimization
-- 
--   open postgresql.conf
-- 
-- 4.7 - Spatial Analysis in SQL
-- 
--  select sum(length(the_geom))/1000 as km_roads from bc_roads;
--  select area(the_geom)/10000 as hectares from bc_municipality where name = 'PRINCE GEORGE';
--  select name, area(the_geom)/10000 as hectares from bc_municipality order by hectares desc limit 1;
-- 
-- 4.8 - Data Integrity
-- 
--  select count(*) from bc_voting_areas where not isvalid(the_geom);
-- 
-- 4.9 - Distance Queries
-- 
--  select astext(the_geom) from bc_pubs where name ilike 'Tabor Arms%';
--  select sum(upbc) as unity_voters from bc_voting_areas where the_geom && setsrid(expand('POINT(1209385 996204)'::geometry, 2000), 3005) and distance(the_geom, geomfromtext('POINT(1209385 996204)', 3005)) < 2000; 
-- 
-- 4.10 - Spatial Joins
-- 
--  select m.name, sum(v.ndp) as ndp, sum(v.lib) as liberal, sum(v.gp) as green, sum(v.upbc) as unity, sum(v.vtotal) as total from bc_voting_areas v, bc_municipality m where v.the_geom && m.the_geom and intersects(v.the_geom, m.the_geom) group by m.name order by m.name;
-- 
-- 4.11 - Overlays 
-- 
--  create table pg_voting_areas as select intersection(v.the_geom, m.the_geom) as intersection_geom, area(v.the_geom) as va_area, v.*, m.name from bc_voting_areas v, bc_municipality m where v.the_geom && m.the_geom and intersects(v.the_geom, m.the_geom) and m.name = 'PRINCE GEORGE';
--  select sum(area(intersection_geom)) from pg_voting_areas;
--  select area(the_geom) from bc_municipality where name = 'PRINCE GEORGE';
-- 
-- 4.12 - Coordinate Projection
-- 
--  select proj4text from spatial_ref_sys where srid=3005;
--  select astext(the_geom) from bc_roads limit 1;
--  select astext(transform(the_geom,4326)) from bc_roads limit 1;
-- 
-- 5.1 - Exercises
-- 
--  What is the perimeter of the municipality of Vancouver?
--  select perimeter(the_geom) from bc_municipality where name = 'VANCOUVER';
--  
--  What is the total area of all voting areas in hectares?
--  select sum(area(the_geom))/10000 as hectares from bc_voting_areas;
--  
--  What is the total area of all voting areas with more than 100 voters in them?
--  select sum(area(the_geom))/10000 as hectares from bc_voting_areas where vtotal > 100;
--  
--  What is the length in kilometers of all roads named Douglas St?
--  select sum(length(the_geom))/1000 as kilometers from bc_roads where name = 'Douglas St';
-- 
-- 5.2 - Advanced Exercises
-- 
--  What is the length in kilometers of Douglas St in Victoria?
--  select sum(length(r.the_geom))/1000 as kilometers from bc_roads r, bc_municipality m where r.the_geom && m.the_geom and r.name = 'Douglas St' and m.name = 'VICTORIA';
--  
--  What two pubs have the most Green Party supporters within 500 meters of them?
--  select p.name, p.city, sum(v.gp) as greens from bc_pubs p, bc_voting_areas v where v.the_geom && setsrid(expand(p.the_geom, 500), 3005) and distance(v.the_geom, p.the_geom) < 500 group by p.name, p.city order by greens desc limit 2;
-- 
--  What is the name and latitude of the most southerly hospital in the province?
--  select name,y(transform(the_geom,4326)) as latitude from bc_hospitals order by latitude asc limit 1;
-- 
--  What were the percentage NDP and Liberal vote within the city limits of Prince George in the 2000 provincial election?
--  select 100*sum(v.ndp)/sum(v.vtotal) as ndp, 100*sum(v.lib)/sum(v.vtotal) as liberal from bc_voting_areas v, bc_municipality m where v.the_geom && m.the_geom and intersects(v.the_geom, m.the_geom) and m.name = 'PRINCE GEORGE';
-- 
--  What is the largest voting area polygon that has a hole?
--  select gid, id, area(the_geom) as area from bc_voting_areas where nrings(the_geom) > 1 order by area desc limit 1;
-- 
--  How many NDP voters live within 50 meters of Simcoe St in Victoria?
--  select sum(v.ndp) as ndp from bc_voting_areas v, bc_municipality m, bc_roads r where m.the_geom && r.the_geom and r.name = 'Simcoe St' and m.name = 'VICTORIA' and distance(r.the_geom, v.the_geom) < 50 and m.the_geom && v.the_geom;

-------------------------------------------
--weave database work
-------------------------------------------

-- create index king_precincts_gidx on king_precincts using gist ( the_geom );

-- select AddGeometryColumn('public','weave_green_2006','the_geom',4326,'POINT',2);
-- select DropGeometryColumn('public','weave_green_2006','the_geom');
-- update weave_green_2006 set the_geom = SETSRID(Makepoint(longitude, latitude),4326);
-- select count(*) from weave_green_2006 where not isvalid(the_geom);

--select addgeometrycolumn('','weave_2006','the_geom', 4326,'POINT',2);
--select addgeometrycolumn('','weave_2006','the_geom2', 2285,'POINT',2);
--update weave_2006 set the_geom = SETSRID(Makepoint(longitude, latitude),4326);
--update weave_2006 set the_geom2 = transform(the_geom,2285);
-- create index weave_2006_gidx on weave_2006 using gist ( the_geom2 );
-- create index weave_green_2006_gidx on weave_green_2006 using gist ( the_geom2 );
-- create index king_precincts_votdst_idx on king_precincts ( votdst );
-- select addgeometrycolumn('','wa_toxics_2006','the_geom', 4326,'POINT',2);
-- select addgeometrycolumn('','wa_toxics_2006','the_geom2', 2285,'POINT',2);
-- update wa_toxics_2006 set the_geom = SETSRID(Makepoint(longitude, latitude),4326);
-- update wa_toxics_2006 set the_geom2 = transform(the_geom,2285);
-- create index wa_toxics_2006_precinct_idx on wa_toxics_2006 using btree ( precinct );

--create index weave_2006_precinct_idx on weave_2006 using btree ( precinct );
--create index weave_green_2006_precinct_idx on weave_green_2006 using btree ( precinct );

-- select addgeometrycolumn('','all_members_2006','the_geom', 4326,'POINT',2);
-- select addgeometrycolumn('','all_members_2006','the_geom2', 2285,'POINT',2);
-- update all_members_2006 set the_geom = SETSRID(Makepoint(longitude, latitude),4326);
-- update all_members_2006 set the_geom2 = transform(the_geom,2285);
-- create index all_members_2006_precinct_idx on all_members_2006 using btree ( precinct );
-- CREATE INDEX all_members_2006_gidx ON all_members_2006 USING gist(the_geom2);

-- explain analyze 
-- select * 
-- into new_vd
-- from all_vd, ini2005 where 
-- all_vd ."county" ilike ini2005."County" and 
-- all_vd ."pname" = ini2005."Precinct"


-- select AddGeometryColumn('public','new_vd','the_geom',4326,'MULTIPOLYGON',2);
-- update new_vd set the_geom= transform(the_geom2,4326);
-- select DropGeometryColumn('public','new_vd','the_geom');

-- select AddGeometryColumn('public','all_vd','the_geom2',2285,'MULTIPOLYGON',2);
-- update all_vd set the_geom2= the_geom;
-- select DropGeometryColumn('public','all_vd','the_geom');
-- select AddGeometryColumn('public','all_vd','the_geom',4326,'MULTIPOLYGON',2);
-- update all_vd set the_geom= transform(the_geom2,4326);


-- c:\Program Files\PostgreSQL\8.0\bin>
-- pgsql2shp  -g the_geom2 -f new_vd -u weave -P gringo1! weave new_vd   

-- UPDATE new_vd set ini_group = 2 where perc912no  < 60 and perc912yes < 60;                                                                                                                                       
-- UPDATE new_vd set ini_group = 1 where perc912yes >= 60;                   
-- UPDATE new_vd set ini_group = 3 where perc912no  >= 60;                   


-- select addgeometrycolumn('','countyvoters2','the_geom', 4326,'POINT',2);
-- select addgeometrycolumn('','countyvoters2','the_geom2', 2285,'POINT',2);
-- update countyvoters2 set the_geom = SETSRID(Makepoint(longitude, latitude),4326);
-- update countyvoters2 set the_geom2 = transform(the_geom,2285);

-- extract housenumbers and streets
 -- update wec_2006 set housenumber = split_part("address",' ',1);
 -- update wec_2006 set street = split_part("address",' ',2) || ' ' || split_part("address",' ',3) || ' ' || split_part("address",' ',4) || ' ' || split_part("address",' ',5);
 -- update wec_2006 set street = trim("street");