#!/usr/bin/env python

#
# Convert geomoose/config.js into an RST document.
#
#
# Copyright (c) 2009-2014, Dan "Ducky" Little & GeoMOOSE.org
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#

import re

header = """
.. _configuration:

GeoMOOSE Configuration Options
==============================

Introduction
-------------
GeoMOOSE has a plethora of configuration options.  All of them can be changed in the mapbook and it is possible to highly customize the interface without writing a single line of code.  This document attempts to keep up with the various settings options in order to give the user more control over their GeoMOOSE installation.  Organization is arbitrarily alphabetisized (mostly).

How to Change a Setting
-----------------------
Every Mapbook has a <configuration> section.  In the <configuration> section there are multiple <param> fields.  The <param> fields are how settings are changed from their defaults.  For example, to add some HTML to the Links bar::

        <configuration>
                ...
                <param name="links_bar_html"><![CDATA[This is some html, with a <a href="http://www.google.com">link to Google!</a>]]></param>
                ...
        </configuration>


The Parameters
-----------------



"""

if(__name__ == "__main__"):
	print header

	for line in open('../js/geomoose/config.js', 'r'):

		# strip the leading white space
		line = line.strip()
		if(line[0:3] == '/**'):
			var_name, desc = line[3:-2].strip().split(' - ')

			print ' * ``%s``' % var_name
			print ''
			print '   '+desc
			print ''
	
		


print 'Autogenerated'
print '^^^^^^^^^^^^^'
print 'Generated from: docs/doc_config_js.py' 
