var info = {"examples":[{"link":"accessible.html","example":"accessible.html","title":"Accessible Map","shortdesc":"Example of an accessible map.","tags":"accessibility, tabindex","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.OSM"]},{"link":"animation.html","example":"animation.html","title":"View Animation","shortdesc":"Demonstrates animated pan, zoom, and rotation.","tags":"animation","requires":["ol.Map","ol.View","ol.animation","ol.control","ol.layer.Tile","ol.proj","ol.source.OSM"]},{"link":"arcgis-image.html","example":"arcgis-image.html","title":"Image ArcGIS MapServer","shortdesc":"Example of an image ArcGIS layer.","tags":"arcgis, image, dynamiclayer\"","requires":["ol.Map","ol.View","ol.layer.Tile","ol.layer.Image","ol.source.MapQuest","ol.source.ImageArcGISRest"]},{"link":"arcgis-tiled.html","example":"arcgis-tiled.html","title":"Tiled ArcGIS MapServer","shortdesc":"Example of a tiled ArcGIS layer.","tags":"arcgis, tile, tilelayer\"","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.MapQuest","ol.source.TileArcGISRest"]},{"link":"attributions.html","example":"attributions.html","title":"Attributions","shortdesc":"Example of a attributions visibily change on map resize, to collapse them on small maps.","tags":"attributions, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.control.Attribution","ol.layer.Tile","ol.source.OSM"]},{"link":"bing-maps.html","example":"bing-maps.html","title":"Bing Maps","shortdesc":"Example of a Bing Maps layer.","tags":"bing, bing-maps","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.BingMaps"]},{"link":"blend-modes.html","example":"blend-modes.html","title":"Blend Modes","shortdesc":"Shows how to change the canvas compositing / blending mode in post- and precompose eventhandlers.","tags":"blendmode, blend-mode, blend mode, blendingmode, blending-mode, blending mode, composition, compositing, canvas, vector","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.layer.Vector","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"box-selection.html","example":"box-selection.html","title":"Box Selection","shortdesc":"Using a DragBox interaction to select features.","tags":"DragBox, feature, selection, box","requires":["ol.Map","ol.View","ol.events.condition","ol.format.GeoJSON","ol.interaction.DragBox","ol.interaction.Select","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector"]},{"link":"button-title.html","example":"button-title.html","title":"Custom Tooltips","shortdesc":"This example shows how to customize the buttons tooltips with Bootstrap.","tags":"custom, tooltip","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.OSM"]},{"link":"canvas-tiles.html","example":"canvas-tiles.html","title":"Canvas Tiles","shortdesc":"Renders tiles with coordinates for debugging.","tags":"layers, openstreetmap, canvas","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.proj","ol.source.OSM","ol.source.TileDebug"]},{"link":"cartodb.html","example":"cartodb.html","title":"CartoDB source example","shortdesc":"Example of a cartodb map.","tags":"simple, openstreetmap, attribution","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.CartoDB","ol.source.OSM"]},{"link":"center.html","example":"center.html","title":"Advanced View Positioning","shortdesc":"This example demonstrates how a map's view can be adjusted so a geometry or coordinate is positioned at a specific pixel location.","tags":"center, rotation, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.format.GeoJSON","ol.geom.Point","ol.geom.SimpleGeometry","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"cluster.html","example":"cluster.html","title":"Clustered Features","shortdesc":"Example of using <code>ol.source.Cluster</code>.","tags":"cluster, vector","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.layer.Tile","ol.layer.Vector","ol.source.Cluster","ol.source.MapQuest","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style","ol.style.Text"]},{"link":"color-manipulation.html","example":"color-manipulation.html","title":"Color Manipulation","shortdesc":"Demonstrates color manipulation with a raster source.","tags":"color, hue, lightness, chroma","requires":["ol.Map","ol.View","ol.layer.Image","ol.source.Raster","ol.source.Stamen"]},{"link":"custom-controls.html","example":"custom-controls.html","title":"Custom Controls","shortdesc":"Shows how to create custom controls.","tags":"custom, control","requires":["ol.Map","ol.View","ol.control","ol.control.Control","ol.layer.Tile","ol.source.OSM"]},{"link":"custom-icon.html","example":"custom-icon.html","title":"Custom Icon","shortdesc":"Example using a custom attribution icon object","tags":"icon, element","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.OSM"]},{"link":"custom-interactions.html","example":"custom-interactions.html","title":"Custom Interactions","shortdesc":"Example of a custom interaction.","tags":"drag, feature, vector, editing, custom, interaction","requires":["ol.Feature","ol.Map","ol.View","ol.geom.LineString","ol.geom.Point","ol.geom.Polygon","ol.interaction","ol.interaction.Pointer","ol.layer.Tile","ol.layer.Vector","ol.source.TileJSON","ol.source.Vector","ol.style.Fill","ol.style.Icon","ol.style.Stroke","ol.style.Style"]},{"link":"d3.html","example":"d3.html","title":"d3 Integration","shortdesc":"Example of using ol3 and d3 together.","tags":"d3","requires":["ol.Map","ol.View","ol.extent","ol.layer.Image","ol.layer.Tile","ol.proj","ol.source.ImageCanvas","ol.source.Stamen"]},{"link":"device-orientation.html","example":"device-orientation.html","title":"Device Orientation","shortdesc":"Listen to DeviceOrientation events.","tags":"orientation, openstreetmap","requires":["ol.DeviceOrientation","ol.Map","ol.View","ol.control","ol.layer.Tile","ol.proj","ol.source.OSM"]},{"link":"drag-and-drop-image-vector.html","example":"drag-and-drop-image-vector.html","title":"Drag-and-Drop Image Vector","shortdesc":"Example of using the drag-and-drop interaction with a ol.source.ImageVector.","tags":"drag-and-drop-image-vector, gpx, geojson, igc, kml, topojson, vector, image","requires":["ol.Map","ol.View","ol.format.GPX","ol.format.GeoJSON","ol.format.IGC","ol.format.KML","ol.format.TopoJSON","ol.interaction","ol.interaction.DragAndDrop","ol.layer.Image","ol.layer.Tile","ol.source.BingMaps","ol.source.ImageVector","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"drag-and-drop.html","example":"drag-and-drop.html","title":"Drag-and-Drop","shortdesc":"Example of using the drag-and-drop interaction.","tags":"drag-and-drop, gpx, geojson, igc, kml, topojson","requires":["ol.Map","ol.View","ol.format.GPX","ol.format.GeoJSON","ol.format.IGC","ol.format.KML","ol.format.TopoJSON","ol.interaction","ol.interaction.DragAndDrop","ol.layer.Tile","ol.layer.Vector","ol.source.BingMaps","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"drag-rotate-and-zoom.html","example":"drag-rotate-and-zoom.html","title":"Drag, Rotate, and Zoom","shortdesc":"A single interaction to drag, rotate, and zoom.","tags":"drag, rotate, zoom, interaction","requires":["ol.Map","ol.View","ol.interaction","ol.interaction.DragRotateAndZoom","ol.layer.Tile","ol.source.MapQuest"]},{"link":"draw-and-modify-features.html","example":"draw-and-modify-features.html","title":"Draw and Modify Features","shortdesc":"Example of using the ol.interaction.Draw interaction together with the ol.interaction.Modify interaction.","tags":"draw, edit, modify, vector, featureoverlay","requires":["ol.Collection","ol.Map","ol.View","ol.events.condition","ol.interaction.Draw","ol.interaction.Modify","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"draw-features.html","example":"draw-features.html","title":"Draw Features","shortdesc":"Example of using the ol.interaction.Draw interaction.","tags":"draw, edit, freehand, vector","requires":["ol.Map","ol.View","ol.geom.Polygon","ol.interaction.Draw","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"dynamic-data.html","example":"dynamic-data.html","title":"Dynamic Data","shortdesc":"Example of dynamic data.","tags":"dynamic-data","requires":["ol.Feature","ol.Map","ol.View","ol.geom.MultiPoint","ol.geom.Point","ol.layer.Tile","ol.source.MapQuest","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"earthquake-clusters.html","example":"earthquake-clusters.html","title":"Earthquake Clusters","shortdesc":"Demonstrates the use of style geometries to render source features of a cluster.","tags":"KML, vector, style, geometry, cluster","requires":["ol.Map","ol.View","ol.extent","ol.format.KML","ol.interaction","ol.interaction.Select","ol.layer.Tile","ol.layer.Vector","ol.source.Cluster","ol.source.Stamen","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.RegularShape","ol.style.Stroke","ol.style.Style","ol.style.Text"]},{"link":"earthquake-custom-symbol.html","example":"earthquake-custom-symbol.html","title":"Earthquakes with custom symbols","shortdesc":"Demonstrates the use of `ol.render.toCanvas` to create custom icon symbols.","tags":"KML, vector, style, canvas, symbol","requires":["ol.Map","ol.View","ol.format.KML","ol.geom.Polygon","ol.layer.Tile","ol.layer.Vector","ol.render","ol.source.Stamen","ol.source.Vector","ol.style.Fill","ol.style.Icon","ol.style.Stroke","ol.style.Style"]},{"link":"epsg-4326.html","example":"epsg-4326.html","title":"EPSG:4326","shortdesc":"Example of a map in EPSG:4326.","tags":"epsg4326","requires":["ol.Map","ol.View","ol.control","ol.control.ScaleLine","ol.layer.Tile","ol.source.TileWMS"]},{"link":"export-map.html","example":"export-map.html","title":"Map Export","shortdesc":"Example of exporting a map as a PNG image.","tags":"export, png, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.format.GeoJSON","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector"]},{"link":"export-pdf.html","example":"export-pdf.html","title":"Export PDF example","shortdesc":"Example of exporting a map as a PDF.","tags":"export, pdf, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.format.WKT","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector"]},{"link":"feature-animation.html","example":"feature-animation.html","title":"Custom Animation","shortdesc":"Demonstrates how to animate features.","tags":"animation, vector, feature, flash","requires":["ol.Feature","ol.Map","ol.Observable","ol.View","ol.control","ol.easing","ol.geom.Point","ol.layer.Tile","ol.layer.Vector","ol.proj","ol.source.OSM","ol.source.Vector","ol.style.Circle","ol.style.Stroke","ol.style.Style"]},{"link":"feature-move-animation.html","example":"feature-move-animation.html","title":"Marker Animation","shortdesc":"Demonstrates how to move a feature along a line.","tags":"animation, feature, postcompose, polyline","requires":["ol.Feature","ol.Map","ol.View","ol.format.Polyline","ol.geom.Point","ol.layer.Tile","ol.layer.Vector","ol.source.BingMaps","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Icon","ol.style.Stroke","ol.style.Style"]},{"link":"flight-animation.html","example":"flight-animation.html","title":"Flight Animation","shortdesc":"Demonstrates how to animate flights with ´postcompose´.","tags":"animation, vector, feature, flights, arc","requires":["ol.Attribution","ol.Feature","ol.Map","ol.View","ol.geom.LineString","ol.layer.Tile","ol.layer.Vector","ol.proj","ol.source.Stamen","ol.source.Vector","ol.style.Stroke","ol.style.Style"]},{"link":"fractal.html","example":"fractal.html","title":"Fractal Rendering","shortdesc":"Example of a fractal.","tags":"fractal, vector","requires":["ol.Feature","ol.Map","ol.View","ol.geom.LineString","ol.layer.Vector","ol.source.Vector"]},{"link":"full-screen-drag-rotate-and-zoom.html","example":"full-screen-drag-rotate-and-zoom.html","title":"Full Screen Drag, Rotate, and Zoom","shortdesc":"Example of drag rotate and zoom control with full screen effect.","tags":"full-screen, drag, rotate, zoom, bing, bing-maps","requires":["ol.Map","ol.View","ol.control","ol.control.FullScreen","ol.interaction","ol.interaction.DragRotateAndZoom","ol.layer.Tile","ol.source.BingMaps"]},{"link":"full-screen-source.html","example":"full-screen-source.html","title":"Full Screen Control with extended source element","shortdesc":"Example of a full screen control with a source option definition.","tags":"full-screen, source, fullScreenSource, osm, osm-maps","requires":["ol.Map","ol.View","ol.control","ol.control.FullScreen","ol.layer.Tile","ol.source.OSM"]},{"link":"full-screen.html","example":"full-screen.html","title":"Full Screen Control","shortdesc":"Example of a full screen control.","tags":"full-screen, bing, bing-maps","requires":["ol.Map","ol.View","ol.control","ol.control.FullScreen","ol.layer.Tile","ol.source.BingMaps"]},{"link":"geojson.html","example":"geojson.html","title":"GeoJSON","shortdesc":"Example of GeoJSON features.","tags":"geojson, vector, openstreetmap","requires":["ol.Feature","ol.Map","ol.View","ol.control","ol.format.GeoJSON","ol.geom.Circle","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"geolocation-orientation.html","example":"geolocation-orientation.html","title":"Geolocation Tracking with Orientation","shortdesc":"Example of a geolocated and oriented map.","tags":"fullscreen, geolocation, orientation, mobile","requires":["ol.Geolocation","ol.Map","ol.Overlay","ol.View","ol.control","ol.geom.LineString","ol.layer.Tile","ol.proj","ol.source.OSM"]},{"link":"geolocation.html","example":"geolocation.html","title":"Geolocation","shortdesc":"Using geolocation to control a map view.","tags":"geolocation, openstreetmap","requires":["ol.Feature","ol.Geolocation","ol.Map","ol.View","ol.control","ol.geom.Point","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"mapserver-wms.html","example":"mapserver-wms.html","title":"MapServer WMS GetFeatureInfo (local MS4W layer)","shortdesc":"Using a local MapServer (MS4W) layer with WMS GetFeatureInfo requests","tags":"getfeatureinfo, forEachLayerAtPixel","requires":["ol.Map","ol.View","ol.layer.Image","ol.source.ImageWMS"]},{"link":"getfeatureinfo-image.html","example":"getfeatureinfo-image.html","title":"WMS GetFeatureInfo (Image Layer)","shortdesc":"Using an image WMS source with GetFeatureInfo requests","tags":"getfeatureinfo, forEachLayerAtPixel","requires":["ol.Map","ol.View","ol.layer.Image","ol.source.ImageWMS"]},{"link":"getfeatureinfo-layers.html","example":"getfeatureinfo-layers.html","title":"WMS GetFeatureInfo (Layers)","shortdesc":"Shows how to fetch features per layer name in a single WMS GetFeatureInfo request\n","requires":["ol.format.WMSGetFeatureInfo"]},{"link":"getfeatureinfo-tile.html","example":"getfeatureinfo-tile.html","title":"WMS GetFeatureInfo (Tile Layer)","shortdesc":"Issuing GetFeatureInfo requests with a WMS tiled source","tags":"getfeatureinfo, forEachLayerAtPixel","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.TileWMS"]},{"link":"gpx.html","example":"gpx.html","title":"GPX Data","shortdesc":"Example of using the GPX source.","tags":"GPX","requires":["ol.Map","ol.View","ol.format.GPX","ol.layer.Tile","ol.layer.Vector","ol.source.BingMaps","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"graticule.html","example":"graticule.html","title":"Map Graticule","shortdesc":"This example shows how to add a graticule overlay to a map.","tags":"graticule","requires":["ol.Graticule","ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.OSM","ol.style.Stroke"]},{"link":"heatmap-earthquakes.html","example":"heatmap-earthquakes.html","title":"Earthquakes Heatmap","shortdesc":"Demonstrates the use of a heatmap layer.","tags":"heatmap, kml, vector, style","requires":["ol.Map","ol.View","ol.format.KML","ol.layer.Heatmap","ol.layer.Tile","ol.source.Stamen","ol.source.Vector"]},{"link":"icon-color.html","example":"icon-color.html","title":"Icon Colors","shortdesc":"Example assigning a custom color to an icon","tags":"vector, style, icon, marker","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.layer.Tile","ol.layer.Vector","ol.proj","ol.source.TileJSON","ol.source.Vector","ol.style.Icon","ol.style.Style"]},{"link":"icon-negative.html","example":"icon-negative.html","title":"Icon Pixel Operations","shortdesc":"Canvas pixel operations on a point icon.","tags":"vector, style, icon, marker, canvas, select","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.interaction.Select","ol.layer.Tile","ol.layer.Vector","ol.source.Stamen","ol.source.Vector","ol.style.Icon","ol.style.Style"]},{"link":"icon-sprite-webgl.html","example":"icon-sprite-webgl.html","title":"Icon Sprites with WebGL","shortdesc":"Icon sprite with WebGL","tags":"webgl, icon, sprite, vector, point","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.layer.Vector","ol.source.Vector","ol.style.Icon","ol.style.Style"]},{"link":"icon.html","example":"icon.html","title":"Icon Symbolizer","shortdesc":"Example using an icon to symbolize a point.","tags":"vector, style, icon, marker, popup","requires":["ol.Feature","ol.Map","ol.Overlay","ol.View","ol.geom.Point","ol.layer.Tile","ol.layer.Vector","ol.source.TileJSON","ol.source.Vector","ol.style.Icon","ol.style.Style"]},{"link":"igc.html","example":"igc.html","title":"IGC Data","shortdesc":"Example of tracks recorded from multiple paraglider flights on the same day, read from an IGC file.","tags":"complex-geometry, closest-feature, igc, opencyclemap","requires":["ol.Attribution","ol.Feature","ol.Map","ol.View","ol.control","ol.format.IGC","ol.geom.LineString","ol.geom.Point","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"image-filter.html","example":"image-filter.html","title":"Image Filters","shortdesc":"Apply a filter to imagery","tags":"filter, image manipulation","requires":["ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.BingMaps"]},{"link":"image-load-events.html","example":"image-load-events.html","title":"Image Load Events","shortdesc":"Example using image load events.","tags":"image, events, loading","requires":["ol.Map","ol.View","ol.layer.Image","ol.source.ImageWMS"]},{"link":"image-vector-layer.html","example":"image-vector-layer.html","title":"Image Vector Layer","shortdesc":"Example of an image vector layer.","tags":"vector, image","requires":["ol.Map","ol.View","ol.format.GeoJSON","ol.layer.Image","ol.layer.Tile","ol.layer.Vector","ol.source.ImageVector","ol.source.MapQuest","ol.source.Vector","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"jsts.html","example":"jsts.html","title":"JSTS Integration","shortdesc":"Example on how to use JSTS with OpenLayers 3.","tags":"vector, jsts, buffer","requires":["ol.Feature","ol.Map","ol.View","ol.format.GeoJSON","ol.layer.Tile","ol.layer.Vector","ol.proj","ol.source.MapQuest","ol.source.Vector"]},{"link":"kml-earthquakes.html","example":"kml-earthquakes.html","title":"Earthquakes in KML","shortdesc":"Demonstrates the use of a Shape symbolizer to render earthquake locations.","tags":"KML, vector, style, tooltip","requires":["ol.Map","ol.View","ol.format.KML","ol.layer.Tile","ol.layer.Vector","ol.source.Stamen","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"kml-timezones.html","example":"kml-timezones.html","title":"Timezones in KML","shortdesc":"Demonstrates rendering timezones from KML.","tags":"KML, vector, style","requires":["ol.Map","ol.View","ol.format.KML","ol.layer.Tile","ol.layer.Vector","ol.source.Stamen","ol.source.Vector","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"kml.html","example":"kml.html","title":"KML","shortdesc":"Rendering KML with a vector source.","tags":"KML","requires":["ol.Map","ol.View","ol.format.KML","ol.layer.Tile","ol.layer.Vector","ol.proj","ol.source.BingMaps","ol.source.Vector"]},{"link":"layer-clipping-webgl.html","example":"layer-clipping-webgl.html","title":"Layer Clipping with WebGL","shortdesc":"Layer WebGL clipping example.","tags":"clipping, webgl, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.has","ol.layer.Tile","ol.source.OSM"]},{"link":"layer-clipping.html","example":"layer-clipping.html","title":"Layer Clipping","shortdesc":"Layer clipping example","tags":"clipping, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.OSM"]},{"link":"layer-extent.html","example":"layer-extent.html","title":"Limited Layer Extent","shortdesc":"Restricting layer rendering to a limited extent.","tags":"extent, tilejson","requires":["ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.TileJSON"]},{"link":"layer-group.html","example":"layer-group.html","title":"Layer Groups","shortdesc":"Example of a map with layer group.","tags":"tilejson, input, bind, group, layergroup","requires":["ol.Map","ol.View","ol.layer.Group","ol.layer.Tile","ol.proj","ol.source.MapQuest","ol.source.TileJSON"]},{"link":"layer-spy.html","example":"layer-spy.html","title":"Layer Spy","shortdesc":"View a portion of one layer over another","tags":"spy, image manipulation","requires":["ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.BingMaps"]},{"link":"layer-swipe.html","example":"layer-swipe.html","title":"Layer Swipe","shortdesc":"Example of a Layer swipe map.","tags":"swipe, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.BingMaps","ol.source.OSM"]},{"link":"layer-z-index.html","example":"layer-z-index.html","title":"Layer Z-Index","shortdesc":"Example of ordering layers using Z-index.","tags":"layer, ordering, z-index","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.layer.Vector","ol.source.Vector","ol.style.Fill","ol.style.RegularShape","ol.style.Stroke","ol.style.Style"]},{"link":"lazy-source.html","example":"lazy-source.html","title":"Lazy Source","shortdesc":"Example of setting a layer source after construction.","tags":"source","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.MapQuest"]},{"link":"line-arrows.html","example":"line-arrows.html","title":"LineString Arrows","shortdesc":"Example of drawing arrows for each line string segment.","tags":"draw, vector, arrow","requires":["ol.Map","ol.View","ol.geom.Point","ol.interaction.Draw","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector","ol.style.Icon","ol.style.Stroke","ol.style.Style"]},{"link":"localized-openstreetmap.html","example":"localized-openstreetmap.html","title":"Localized OpenStreetMap","shortdesc":"Example of a localized OpenStreetMap map with a custom tile server and a custom attribution.","tags":"localized-openstreetmap, openseamap, openstreetmap","requires":["ol.Attribution","ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.OSM"]},{"link":"mapbox-vector-tiles-advanced.html","example":"mapbox-vector-tiles-advanced.html","title":"Advanced Mapbox Vector Tiles","shortdesc":"Example of a Mapbox vector tiles map with custom tile grid.","tags":"mapbox, vector, tiles, mobile","requires":["ol.Attribution","ol.Map","ol.View","ol.format.MVT","ol.layer.VectorTile","ol.proj","ol.source.VectorTile","ol.style.Fill","ol.style.Icon","ol.style.Stroke","ol.style.Style","ol.style.Text","ol.tilegrid.TileGrid"]},{"link":"mapbox-vector-tiles.html","example":"mapbox-vector-tiles.html","title":"Mapbox Vector Tiles","shortdesc":"Example of a Mapbox vector tiles map.","tags":"simple, mapbox, vector, tiles","requires":["ol.Attribution","ol.Map","ol.View","ol.format.MVT","ol.layer.VectorTile","ol.source.VectorTile","ol.style.Fill","ol.style.Icon","ol.style.Stroke","ol.style.Style","ol.style.Text"]},{"link":"mapguide-untiled.html","example":"mapguide-untiled.html","title":"MapGuide Untiled","shortdesc":"Example of a untiled MapGuide map.","tags":"mapguide","requires":["ol.Map","ol.View","ol.layer.Image","ol.source.ImageMapGuide"]},{"link":"mapquest.html","example":"mapquest.html","title":"MapQuest","shortdesc":"Example of a MapQuest map.Shows how to create custom controls.","tags":"mapquest","requires":["ol.Map","ol.View","ol.layer.Group","ol.layer.Tile","ol.proj","ol.source.MapQuest"]},{"link":"measure.html","example":"measure.html","title":"Measure","shortdesc":"Example of using the ol.interaction.Draw interaction to create a simple measuring application.","tags":"draw, edit, measure, vector","requires":["ol.Map","ol.Observable","ol.Overlay","ol.Sphere","ol.View","ol.geom.LineString","ol.geom.Polygon","ol.interaction.Draw","ol.layer.Tile","ol.layer.Vector","ol.proj","ol.source.MapQuest","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"min-max-resolution.html","example":"min-max-resolution.html","title":"Layer Min/Max Resolution","shortdesc":"Show/hide layers depending on current view resolution.","tags":"minResolution, maxResolution, resolution","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.OSM","ol.source.TileJSON"]},{"link":"mobile-full-screen.html","example":"mobile-full-screen.html","title":"Full-Screen Mobile","shortdesc":"Example of a full screen map.","tags":"fullscreen, geolocation, mobile","requires":["ol.Geolocation","ol.Map","ol.View","ol.layer.Tile","ol.source.BingMaps"]},{"link":"modify-features.html","example":"modify-features.html","title":"Modify Features","shortdesc":"Editing features with the modify interaction.","tags":"modify, edit, vector","requires":["ol.Map","ol.View","ol.format.GeoJSON","ol.interaction","ol.interaction.Modify","ol.interaction.Select","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector"]},{"link":"modify-test.html","example":"modify-test.html","title":"Modify Features Test","shortdesc":"Example for testing feature modification.","tags":"modify, edit, vector","requires":["ol.Map","ol.View","ol.format.GeoJSON","ol.interaction","ol.interaction.Modify","ol.interaction.Select","ol.layer.Vector","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"mouse-position.html","example":"mouse-position.html","title":"Mouse Position","shortdesc":"Example of a mouse position control, outside the map.","tags":"mouse-position, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.control.MousePosition","ol.coordinate","ol.layer.Tile","ol.proj","ol.source.OSM"]},{"link":"moveend.html","example":"moveend.html","title":"Moveend Event","shortdesc":"Use of the moveend event.","tags":"moveend, map, event","requires":["ol.Map","ol.View","ol.control","ol.extent","ol.layer.Tile","ol.proj","ol.source.OSM"]},{"link":"navigation-controls.html","example":"navigation-controls.html","title":"Navigation Controls","shortdesc":"Shows how to add navigation controls.","tags":"control, navigation, extent","requires":["ol.Map","ol.View","ol.control","ol.control.ZoomToExtent","ol.layer.Tile","ol.source.OSM"]},{"link":"osm-vector-tiles.html","example":"osm-vector-tiles.html","title":"OSM Vector Tiles","shortdesc":"Using OpenStreetMap vector tiles.","tags":"vector, tiles, osm","requires":["ol.Map","ol.View","ol.format.TopoJSON","ol.layer.VectorTile","ol.proj","ol.source.VectorTile","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"overlay.html","example":"overlay.html","title":"Overlay","shortdesc":"Demonstrates overlays.","tags":"overlay, popup, bootstrap, popover, mapquest, openaerial","requires":["ol.Map","ol.Overlay","ol.View","ol.coordinate","ol.layer.Tile","ol.proj","ol.source.MapQuest"]},{"link":"overviewmap-custom.html","example":"overviewmap-custom.html","title":"Custom Overview Map","shortdesc":"Example of OverviewMap control with advanced customization.","tags":"overview, overviewmap","requires":["ol.Map","ol.View","ol.control","ol.control.OverviewMap","ol.interaction","ol.interaction.DragRotateAndZoom","ol.layer.Tile","ol.source.OSM"]},{"link":"overviewmap.html","example":"overviewmap.html","title":"Overview Map Control","shortdesc":"Example of OverviewMap control.","tags":"overview, overviewmap","requires":["ol.Map","ol.View","ol.control","ol.control.OverviewMap","ol.layer.Tile","ol.source.OSM"]},{"link":"permalink.html","example":"permalink.html","title":"Permalink","shortdesc":"Example on how to create permalinks.","tags":"permalink, openstreetmap, history","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.OSM"]},{"link":"polygon-styles.html","example":"polygon-styles.html","title":"Custom Polygon Styles","shortdesc":"Showing the vertices of a polygon with a custom style geometry.","tags":"polygon, vector, style, GeometryFunction","requires":["ol.Map","ol.View","ol.format.GeoJSON","ol.geom.MultiPoint","ol.layer.Vector","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"popup.html","example":"popup.html","title":"Popup","shortdesc":"Uses an overlay to create a popup.","tags":"overlay, popup, mapquest, openaerial","requires":["ol.Map","ol.Overlay","ol.View","ol.coordinate","ol.layer.Tile","ol.proj","ol.source.TileJSON"]},{"link":"preload.html","example":"preload.html","title":"Preload Tiles","shortdesc":"Example of tile preloading.","tags":"preload, bing","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.BingMaps"]},{"link":"raster.html","example":"raster.html","title":"Raster Source","shortdesc":"Demonstrates pixelwise operations with a raster source.","tags":"raster, pixel","requires":["ol.Map","ol.View","ol.layer.Image","ol.layer.Tile","ol.source.BingMaps","ol.source.Raster"]},{"link":"region-growing.html","example":"region-growing.html","title":"Region Growing","shortdesc":"Grow a region from a seed pixel","tags":"raster, region growing","requires":["ol.Map","ol.View","ol.layer.Image","ol.layer.Tile","ol.proj","ol.source.BingMaps","ol.source.Raster"]},{"link":"regularshape.html","example":"regularshape.html","title":"Regular Shapes","shortdesc":"Example of some Regular Shape styles.","tags":"vector, symbol, regularshape, style, square, cross, star, triangle, x","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.layer.Vector","ol.source.Vector","ol.style.Fill","ol.style.RegularShape","ol.style.Stroke","ol.style.Style"]},{"link":"render-geometry.html","example":"render-geometry.html","title":"Render geometries to a canvas","shortdesc":"Example of rendering geometries to an arbitrary canvas.","tags":"render, geometry, canvas","requires":["ol.geom.LineString","ol.geom.Point","ol.geom.Polygon","ol.render","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"reprojection-by-code.html","example":"reprojection-by-code.html","title":"Reprojection with EPSG.io Search","shortdesc":"Demonstrates client-side raster reprojection of MapQuest OSM to arbitrary projection","tags":"reprojection, projection, proj4js, mapquest, epsg.io","requires":["ol.Map","ol.View","ol.extent","ol.layer.Tile","ol.proj","ol.source.MapQuest","ol.source.TileImage"]},{"link":"reprojection-image.html","example":"reprojection-image.html","title":"Image Reprojection","shortdesc":"Demonstrates client-side reprojection of single image source.","tags":"reprojection, projection, proj4js, mapquest, image, imagestatic","requires":["ol.Map","ol.View","ol.extent","ol.layer.Image","ol.layer.Tile","ol.proj","ol.source.ImageStatic","ol.source.MapQuest"]},{"link":"reprojection-wgs84.html","example":"reprojection-wgs84.html","title":"OpenStreetMap Reprojection","shortdesc":"Demonstrates client-side reprojection of OpenStreetMap in WGS84.","tags":"reprojection, projection, openstreetmap, wgs84, tile","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.OSM"]},{"link":"reprojection.html","example":"reprojection.html","title":"Raster Reprojection","shortdesc":"Demonstrates client-side raster reprojection between various projections.","tags":"reprojection, projection, proj4js, mapquest, wms, wmts, hidpi","requires":["ol.Attribution","ol.Map","ol.View","ol.extent","ol.format.WMTSCapabilities","ol.layer.Tile","ol.proj","ol.source.MapQuest","ol.source.TileImage","ol.source.TileWMS","ol.source.WMTS","ol.source.XYZ","ol.tilegrid.TileGrid"]},{"link":"reusable-source.html","example":"reusable-source.html","title":"Reusable Source","shortdesc":"Updating a tile source by changing the URL.","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.XYZ"]},{"link":"rotation.html","example":"rotation.html","title":"View Rotation","shortdesc":"Example of a rotated map.","tags":"rotation, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.OSM"]},{"link":"scale-line.html","example":"scale-line.html","title":"Scale Line","shortdesc":"Example of a scale line.","tags":"scale-line, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.control.ScaleLine","ol.layer.Tile","ol.source.OSM"]},{"link":"scaleline-indiana-east.html","example":"scaleline-indiana-east.html","title":"OpenStreetMap Reprojection with ScaleLine Control","shortdesc":"Demonstrates client-side reprojection of OpenStreetMap to NAD83 Indiana East.","tags":"reprojection, projection, openstreetmap, nad83, tile, scaleline","requires":["ol.Map","ol.View","ol.control.ScaleLine","ol.layer.Tile","ol.proj","ol.source.OSM"]},{"link":"select-features.html","example":"select-features.html","title":"Select Features","shortdesc":"Example of using the Select interaction.","tags":"select, vector","requires":["ol.Map","ol.View","ol.events.condition","ol.format.GeoJSON","ol.interaction.Select","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector"]},{"link":"semi-transparent-layer.html","example":"semi-transparent-layer.html","title":"Semi-Transparent Layer","shortdesc":"Example of a map with a semi-transparent layer.","tags":"transparent, mapquest, tilejson","requires":["ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.MapQuest","ol.source.TileJSON"]},{"link":"shaded-relief.html","example":"shaded-relief.html","title":"Shaded Relief","shortdesc":"Calculate shaded relief from elevation data","tags":"raster, shaded relief","requires":["ol.Map","ol.View","ol.layer.Image","ol.layer.Tile","ol.source.OSM","ol.source.Raster","ol.source.XYZ"]},{"link":"side-by-side.html","example":"side-by-side.html","title":"Shared Views","shortdesc":"The three maps, one WebGL, one Canvas, one DOM, share the same center, resolution, rotation and layers.","tags":"side-by-side, canvas, webgl, dom, canvas, sync, object","requires":["ol.Map","ol.View","ol.has","ol.layer.Tile","ol.source.MapQuest"]},{"link":"simple.html","example":"simple.html","title":"Simple Map","shortdesc":"Example of a simple map.","tags":"simple, openstreetmap","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.OSM"]},{"link":"snap.html","example":"snap.html","title":"Snap Interaction","shortdesc":"Example of using the snap interaction together with draw and modify interactions.","tags":"draw, edit, modify, vector, snap","requires":["ol.Map","ol.View","ol.interaction","ol.interaction.Draw","ol.interaction.Modify","ol.interaction.Select","ol.interaction.Snap","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"sphere-mollweide.html","example":"sphere-mollweide.html","title":"Sphere Mollweide","shortdesc":"Example of a Sphere Mollweide map with a Graticule component.","tags":"graticule, Mollweide, projection, proj4js","requires":["ol.Graticule","ol.Map","ol.View","ol.format.GeoJSON","ol.layer.Vector","ol.proj.Projection","ol.source.Vector"]},{"link":"stamen.html","example":"stamen.html","title":"Stamen Tiles","shortdesc":"Example of a Stamen tile source.","tags":"stamen, watercolor, terrain-labels, two-layers","requires":["ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.Stamen"]},{"link":"static-image.html","example":"static-image.html","title":"Static Image","shortdesc":"Example of a static image layer.","tags":"static image, xkcd","requires":["ol.Attribution","ol.Map","ol.View","ol.extent","ol.layer.Image","ol.proj.Projection","ol.source.ImageStatic"]},{"link":"symbol-atlas-webgl.html","example":"symbol-atlas-webgl.html","title":"Symbols with WebGL","shortdesc":"Using symbols in an atlas with WebGL.","tags":"webgl, symbol, atlas, vector, point","requires":["ol.Feature","ol.Map","ol.View","ol.geom.Point","ol.layer.Vector","ol.source.Vector","ol.style.AtlasManager","ol.style.Circle","ol.style.Fill","ol.style.RegularShape","ol.style.Stroke","ol.style.Style"]},{"link":"synthetic-lines.html","example":"synthetic-lines.html","title":"Synthetic Lines","shortdesc":"Synthetic lines example.","tags":"vector","requires":["ol.Feature","ol.Map","ol.View","ol.geom.LineString","ol.layer.Vector","ol.source.Vector","ol.style.Stroke","ol.style.Style"]},{"link":"synthetic-points.html","example":"synthetic-points.html","title":"Synthetic Points","shortdesc":"Synthetic points example.","tags":"vector","requires":["ol.Feature","ol.Map","ol.View","ol.geom.LineString","ol.geom.Point","ol.layer.Vector","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"teleport.html","example":"teleport.html","title":"Teleporting Maps","shortdesc":"Example of moving a map from one target to another.","tags":"teleport, openstreetmap","requires":["ol.Map","ol.View","ol.control","ol.layer.Tile","ol.source.OSM"]},{"link":"tile-load-events.html","example":"tile-load-events.html","title":"Tile Load Events","shortdesc":"Example using tile load events.","tags":"tile, events, loading","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.TileJSON"]},{"link":"tilejson.html","example":"tilejson.html","title":"TileJSON","shortdesc":"Example of a TileJSON layer.","tags":"tilejson","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.TileJSON"]},{"link":"tileutfgrid.html","example":"tileutfgrid.html","title":"Tiled UTFGrid","shortdesc":"This example shows how to read data from a TileUTFGrid layer.","tags":"utfgrid, tileutfgrid, tilejson","requires":["ol.Map","ol.Overlay","ol.View","ol.layer.Tile","ol.source.TileJSON","ol.source.TileUTFGrid"]},{"link":"tissot.html","example":"tissot.html","title":"Tissot Indicatrix","shortdesc":"Draw Tissot's indicatrices on maps.","tags":"tissot, circle","requires":["ol.Feature","ol.Map","ol.Sphere","ol.View","ol.geom.Polygon","ol.layer.Tile","ol.layer.Vector","ol.source.TileWMS","ol.source.Vector"]},{"link":"topojson.html","example":"topojson.html","title":"TopoJSON","shortdesc":"Demonstrates rendering of features from a TopoJSON topology.","tags":"topojson, vector, style","requires":["ol.Map","ol.View","ol.format.TopoJSON","ol.layer.Tile","ol.layer.Vector","ol.source.TileJSON","ol.source.Vector","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"translate-features.html","example":"translate-features.html","title":"Translate Features","shortdesc":"Example of a translate features interaction.","tags":"drag, translate, feature, vector, editing","requires":["ol.Feature","ol.Map","ol.View","ol.format.GeoJSON","ol.interaction","ol.interaction.Select","ol.interaction.Translate","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector"]},{"link":"turf.html","example":"turf.html","title":"turf.js","shortdesc":"Example on how to use turf.js with OpenLayers 3.","tags":"vector, turfjs, along, distance","requires":["ol.Feature","ol.Map","ol.View","ol.format.GeoJSON","ol.layer.Tile","ol.layer.Vector","ol.proj","ol.source.MapQuest","ol.source.Vector"]},{"link":"vector-esri-edit.html","example":"vector-esri-edit.html","title":"Editable ArcGIS REST Feature Service","shortdesc":"Example of using an ArcGIS REST Feature Service in an editing application.","tags":"vector, esri, ArcGIS, REST, Feature, Service, loading, server, edit, updateFeature, addFeature","requires":["ol.Attribution","ol.Map","ol.View","ol.format.EsriJSON","ol.interaction","ol.interaction.Draw","ol.interaction.Modify","ol.interaction.Select","ol.layer.Tile","ol.layer.Vector","ol.loadingstrategy","ol.proj","ol.source.Vector","ol.source.XYZ"]},{"link":"vector-esri.html","example":"vector-esri.html","title":"ArcGIS REST Feature Service","shortdesc":"Example of using an ArcGIS REST Feature Service with a Tile strategy.","tags":"vector, esri, ArcGIS, REST, Feature, Service, loading, server","requires":["ol.Attribution","ol.Map","ol.View","ol.format.EsriJSON","ol.layer.Tile","ol.layer.Vector","ol.loadingstrategy","ol.proj","ol.source.Vector","ol.source.XYZ","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"vector-labels.html","example":"vector-labels.html","title":"Vector Labels","shortdesc":"Example of GeoJSON features with labels.","tags":"geojson, vector, openstreetmap, label","requires":["ol.Map","ol.View","ol.format.GeoJSON","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style","ol.style.Text"]},{"link":"vector-layer.html","example":"vector-layer.html","title":"Vector Layer","shortdesc":"Example of a countries vector layer with country information.","tags":"vector, osm, xml, loading, server","requires":["ol.Map","ol.View","ol.format.GeoJSON","ol.layer.Tile","ol.layer.Vector","ol.source.MapQuest","ol.source.Vector","ol.style.Fill","ol.style.Stroke","ol.style.Style","ol.style.Text"]},{"link":"vector-osm.html","example":"vector-osm.html","title":"OSM XML","shortdesc":"Example of using the OSM XML source.","tags":"vector, osm, xml, loading, server","requires":["ol.Map","ol.View","ol.control","ol.format.OSMXML","ol.layer.Tile","ol.layer.Vector","ol.loadingstrategy","ol.proj","ol.source.BingMaps","ol.source.Vector","ol.style.Circle","ol.style.Fill","ol.style.Stroke","ol.style.Style"]},{"link":"vector-wfs-getfeature.html","example":"vector-wfs-getfeature.html","title":"WFS - GetFeature","shortdesc":"Example of making a WFS GetFeature request with a filter.","tags":"vector, WFS, GetFeature, filter","requires":["ol.Map","ol.View","ol.format.ogc.filter","ol.format.WFS","ol.format.GeoJSON","ol.layer.Tile","ol.layer.Vector","ol.source.BingMaps","ol.source.Vector","ol.style.Stroke","ol.style.Style"]},{"link":"vector-wfs.html","example":"vector-wfs.html","title":"WFS","shortdesc":"Example of using WFS with a BBOX strategy.","tags":"vector, WFS, bbox, loading, server","requires":["ol.Map","ol.View","ol.format.GeoJSON","ol.layer.Tile","ol.layer.Vector","ol.loadingstrategy","ol.source.BingMaps","ol.source.Vector","ol.style.Stroke","ol.style.Style"]},{"link":"wkt.html","example":"wkt.html","title":"WKT","shortdesc":"Example of using the WKT parser.","tags":"wkt, well known text","requires":["ol.Map","ol.View","ol.format.WKT","ol.layer.Tile","ol.layer.Vector","ol.source.OSM","ol.source.Vector"]},{"link":"wms-capabilities.html","example":"wms-capabilities.html","title":"WMS Capabilities Parsing","shortdesc":"Example of parsing a WMS GetCapabilities response.","tags":"wms, capabilities, getcapabilities","requires":["ol.format.WMSCapabilities"]},{"link":"wms-custom-proj.html","example":"wms-custom-proj.html","title":"Custom Tiled WMS","shortdesc":"Example of using custom coordinate transform functions.","tags":"wms, tile, tilelayer, projection","requires":["ol.Attribution","ol.Map","ol.View","ol.control","ol.control.ScaleLine","ol.layer.Tile","ol.proj","ol.proj.Projection","ol.source.TileWMS"]},{"link":"wms-custom-tilegrid-512x256.html","example":"wms-custom-tilegrid-512x256.html","title":"WMS 512x256 Tiles","shortdesc":"Example of a WMS layer with 512x256px tiles.","tags":"wms, tile, non-square","requires":["ol.Map","ol.View","ol.extent","ol.layer.Tile","ol.proj","ol.source.MapQuest","ol.source.TileWMS","ol.tilegrid.TileGrid"]},{"link":"wms-image-custom-proj.html","example":"wms-image-custom-proj.html","title":"Single Image WMS with Proj4js","shortdesc":"Example of integrating Proj4js for coordinate transforms.","tags":"wms, single image, proj4js, projection","requires":["ol.Attribution","ol.Map","ol.View","ol.control","ol.control.ScaleLine","ol.layer.Image","ol.proj","ol.proj.Projection","ol.source.ImageWMS"]},{"link":"wms-image.html","example":"wms-image.html","title":"Single Image WMS","shortdesc":"Example of a single image WMS layer.","tags":"wms, image","requires":["ol.Map","ol.View","ol.layer.Image","ol.layer.Tile","ol.source.ImageWMS","ol.source.MapQuest"]},{"link":"wms-no-proj.html","example":"wms-no-proj.html","title":"WMS without Projection","shortdesc":"Example of two WMS layers using the projection EPSG:21781, which is unknown to the client.","tags":"wms, projection","requires":["ol.Attribution","ol.Map","ol.View","ol.layer.Image","ol.layer.Tile","ol.proj.Projection","ol.source.ImageWMS","ol.source.TileWMS"]},{"link":"wms-tiled-wrap-180.html","example":"wms-tiled-wrap-180.html","title":"Tiled WMS Wrapping","shortdesc":"Example of a tiled WMS layer that wraps across the 180° meridian.","tags":"wms, tile, dateline, wrap, 180","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.MapQuest","ol.source.TileWMS"]},{"link":"wms-tiled.html","example":"wms-tiled.html","title":"Tiled WMS","shortdesc":"Example of a tiled WMS layer.","tags":"wms, tile, tilelayer","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.MapQuest","ol.source.TileWMS"]},{"link":"wms-time.html","example":"wms-time.html","title":"WMS Time","shortdesc":"Example of smooth tile transitions when changing the time dimension of a tiled WMS layer.","tags":"wms, time, dimensions, transition","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.MapQuest","ol.source.TileWMS"]},{"link":"wmts-capabilities.html","example":"wmts-capabilities.html","title":"WMTS Capabilities Parsing","shortdesc":"Example of parsing a WMTS GetCapabilities response.","tags":"wmts, capabilities, getcapabilities","requires":["ol.format.WMTSCapabilities"]},{"link":"wmts-dimensions.html","example":"wmts-dimensions.html","title":"WMTS Tile Transitions","shortdesc":"Example of smooth tile transitions when changing the dimension of a WMTS layer.","tags":"wmts, parameter, transition","requires":["ol.Attribution","ol.Map","ol.View","ol.extent","ol.layer.Tile","ol.proj","ol.source.OSM","ol.source.WMTS","ol.tilegrid.WMTS"]},{"link":"wmts-hidpi.html","example":"wmts-hidpi.html","title":"High DPI WMTS","shortdesc":"Example of a WMTS based HiDPI layer.","tags":"hidpi, retina, wmts","requires":["ol.Map","ol.View","ol.format.WMTSCapabilities","ol.has","ol.layer.Tile","ol.source.WMTS"]},{"link":"wmts-ign.html","example":"wmts-ign.html","title":"IGN WMTS","shortdesc":"Demonstrates displaying IGN (France) WMTS layers.","tags":"french, ign, geoportail, wmts","requires":["ol.Attribution","ol.Map","ol.View","ol.control","ol.extent","ol.layer.Tile","ol.proj","ol.source.WMTS","ol.tilegrid.WMTS"]},{"link":"wmts-layer-from-capabilities.html","example":"wmts-layer-from-capabilities.html","title":"WMTS Layer from Capabilities","shortdesc":"Example of a WMTS source created from a WMTS capabilities document.","tags":"wmts, capabilities, getcapabilities","requires":["ol.Map","ol.View","ol.format.WMTSCapabilities","ol.layer.Tile","ol.source.OSM","ol.source.WMTS"]},{"link":"wmts.html","example":"wmts.html","title":"WMTS","shortdesc":"Example of a WMTS source.","tags":"wmts","requires":["ol.Attribution","ol.Map","ol.View","ol.control","ol.extent","ol.layer.Tile","ol.proj","ol.source.OSM","ol.source.WMTS","ol.tilegrid.WMTS"]},{"link":"xyz-esri-4326-512.html","example":"xyz-esri-4326-512.html","title":"ArcGIS REST with 512x512 Tiles","shortdesc":"Example of a XYZ source in EPSG:4326 using Esri 512x512 tiles.","tags":"xyz, esri, tilesize, custom projection","requires":["ol.Attribution","ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.XYZ"]},{"link":"xyz-esri.html","example":"xyz-esri.html","title":"XYZ Esri","shortdesc":"Example of a XYZ source using Esri tiles.","tags":"xyz, esri, arcgis rest","requires":["ol.Attribution","ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.XYZ"]},{"link":"xyz-retina.html","example":"xyz-retina.html","title":"XYZ Retina Tiles","shortdesc":"Example of Retina / HiDPI mercator tiles (512x512px) available as XYZ.","tags":"retina, hidpi, xyz, maptiler, @2x, devicePixelRatio","requires":["ol.Attribution","ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.source.OSM","ol.source.XYZ"]},{"link":"xyz.html","example":"xyz.html","title":"XYZ","shortdesc":"Example of a XYZ source.","tags":"xyz","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.XYZ"]},{"link":"zoom-constrained.html","example":"zoom-constrained.html","title":"Constrained Zoom","shortdesc":"Example of a zoom constrained view.","tags":"bing, zoom, minZoom, maxZoom","requires":["ol.Map","ol.View","ol.layer.Tile","ol.source.BingMaps"]},{"link":"zoomify.html","example":"zoomify.html","title":"Zoomify","shortdesc":"Example of a Zoomify source.","tags":"zoomify, deep zoom, pixel, projection","requires":["ol.Map","ol.View","ol.layer.Tile","ol.proj","ol.proj.Projection","ol.source.Zoomify"]},{"link":"zoomslider.html","example":"zoomslider.html","title":"Zoom Sliders","shortdesc":"Example of various ZoomSlider controls.","tags":"zoom, zoomslider, slider, style, styling, css, control","requires":["ol.Map","ol.View","ol.control.ZoomSlider","ol.layer.Tile","ol.source.MapQuest"]}],"index":{"3":{"54":1,"119":1},"180":{"134":1},"4326":{"27":1,"143":1},"21781":{"133":1},"example":{"0":1,"2":1,"3":1,"4":1,"5":1,"8":1,"10":1,"11":1,"12":1,"15":1,"16":1,"17":1,"19":1,"20":1,"22":1,"23":1,"24":1,"27":1,"28":1,"29":1,"33":1,"34":1,"35":1,"36":1,"37":1,"38":1,"43":1,"44":1,"46":1,"49":1,"50":1,"52":1,"53":1,"54":1,"58":1,"59":1,"61":1,"63":1,"64":1,"65":1,"66":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"74":1,"76":1,"77":1,"82":1,"83":1,"84":1,"87":1,"90":1,"91":1,"97":1,"98":1,"100":1,"101":1,"104":1,"105":1,"106":1,"107":1,"108":1,"110":1,"111":1,"112":1,"113":1,"114":1,"115":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"128":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1,"137":1,"138":1,"139":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"of":{"0":1,"2":1,"3":1,"4":1,"5":1,"10":1,"12":1,"16":1,"17":1,"19":1,"20":1,"22":1,"23":1,"24":1,"25":1,"26":1,"27":1,"28":1,"29":1,"33":1,"34":1,"35":1,"36":1,"37":1,"38":1,"43":1,"45":1,"50":1,"53":1,"55":1,"61":1,"62":1,"63":1,"64":1,"65":1,"66":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"74":1,"77":1,"78":1,"82":1,"83":1,"85":1,"87":1,"90":1,"91":1,"92":1,"93":1,"94":1,"97":1,"98":1,"99":1,"100":1,"101":1,"104":1,"105":1,"106":1,"107":1,"108":1,"112":1,"114":1,"117":1,"118":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"128":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1,"137":1,"138":1,"139":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"an":{"0":1,"2":1,"40":1,"46":1,"49":1,"50":1,"53":1,"86":1,"91":1,"109":1,"120":1,"121":1},"accessible":{"0":1},"map":{"0":1,"1":1,"2":1,"3":1,"4":1,"5":1,"6":1,"7":1,"8":1,"9":1,"10":1,"11":1,"12":1,"13":1,"14":1,"15":1,"16":1,"17":1,"18":1,"19":1,"20":1,"21":1,"22":1,"23":1,"24":1,"25":1,"26":1,"27":1,"28":1,"29":1,"30":1,"31":1,"32":1,"33":1,"34":1,"35":1,"36":1,"37":1,"38":1,"39":1,"40":1,"42":1,"43":1,"44":1,"45":1,"46":1,"47":1,"48":1,"49":1,"50":1,"51":1,"52":1,"53":1,"54":1,"55":1,"56":1,"57":1,"58":1,"59":1,"60":1,"61":1,"62":1,"63":1,"64":1,"65":1,"66":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"73":1,"74":1,"75":1,"76":1,"77":1,"78":1,"79":1,"80":1,"81":1,"82":1,"83":1,"84":1,"85":1,"86":1,"87":1,"88":1,"89":1,"90":1,"92":1,"93":1,"94":1,"95":1,"96":1,"97":1,"98":1,"99":1,"100":1,"101":1,"102":1,"103":1,"104":1,"105":1,"106":1,"107":1,"108":1,"109":1,"110":1,"111":1,"112":1,"113":1,"114":1,"115":1,"116":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1,"138":1,"139":1,"140":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"accessibility":{"0":1},"tabindex":{"0":1},"ol":{"0":1,"1":1,"2":1,"3":1,"4":1,"5":1,"6":1,"7":1,"8":1,"9":1,"10":1,"11":1,"12":1,"13":1,"14":1,"15":1,"16":1,"17":1,"18":1,"19":1,"20":1,"21":1,"22":1,"23":1,"24":1,"25":1,"26":1,"27":1,"28":1,"29":1,"30":1,"31":1,"32":1,"33":1,"34":1,"35":1,"36":1,"37":1,"38":1,"39":1,"40":1,"41":1,"42":1,"43":1,"44":1,"45":1,"46":1,"47":1,"48":1,"49":1,"50":1,"51":1,"52":1,"53":1,"54":1,"55":1,"56":1,"57":1,"58":1,"59":1,"60":1,"61":1,"62":1,"63":1,"64":1,"65":1,"66":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"73":1,"74":1,"75":1,"76":1,"77":1,"78":1,"79":1,"80":1,"81":1,"82":1,"83":1,"84":1,"85":1,"86":1,"87":1,"88":1,"89":1,"90":1,"91":1,"92":1,"93":1,"94":1,"95":1,"96":1,"97":1,"98":1,"99":1,"100":1,"101":1,"102":1,"103":1,"104":1,"105":1,"106":1,"107":1,"108":1,"109":1,"110":1,"111":1,"112":1,"113":1,"114":1,"115":1,"116":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"128":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1,"137":1,"138":1,"139":1,"140":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"view":{"0":1,"1":1,"2":1,"3":1,"4":1,"5":1,"6":1,"7":1,"8":1,"9":1,"10":1,"11":1,"12":1,"13":1,"14":1,"15":1,"16":1,"17":1,"18":1,"19":1,"20":1,"21":1,"22":1,"23":1,"24":1,"25":1,"26":1,"27":1,"28":1,"29":1,"30":1,"31":1,"32":1,"33":1,"34":1,"35":1,"36":1,"37":1,"38":1,"39":1,"40":1,"42":1,"43":1,"44":1,"45":1,"46":1,"47":1,"48":1,"49":1,"50":1,"51":1,"52":1,"53":1,"54":1,"55":1,"56":1,"57":1,"58":1,"59":1,"60":1,"61":1,"62":1,"63":1,"64":1,"65":1,"66":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"73":1,"74":1,"75":1,"76":1,"77":1,"78":1,"79":1,"80":1,"81":1,"82":1,"83":1,"84":1,"85":1,"86":1,"87":1,"88":1,"89":1,"90":1,"92":1,"93":1,"94":1,"95":1,"96":1,"97":1,"98":1,"99":1,"100":1,"101":1,"102":1,"103":1,"104":1,"105":1,"106":1,"107":1,"108":1,"109":1,"110":1,"111":1,"112":1,"113":1,"114":1,"115":1,"116":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1,"138":1,"139":1,"140":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"control":{"0":1,"1":1,"4":1,"9":1,"11":1,"14":1,"18":1,"27":1,"28":1,"29":1,"30":1,"34":1,"35":1,"36":1,"37":1,"38":1,"39":1,"50":1,"58":1,"59":1,"63":1,"67":1,"73":1,"77":1,"78":1,"79":1,"82":1,"83":1,"84":1,"97":1,"98":1,"99":1,"112":1,"124":1,"129":1,"131":1,"140":1,"142":1,"149":1},"layer":{"0":1,"1":1,"2":1,"3":1,"4":1,"5":1,"6":1,"7":1,"8":1,"9":1,"10":1,"11":1,"12":1,"13":1,"14":1,"15":1,"16":1,"17":1,"18":1,"19":1,"20":1,"21":1,"22":1,"23":1,"24":1,"25":1,"26":1,"27":1,"28":1,"29":1,"30":1,"31":1,"32":1,"33":1,"34":1,"35":1,"36":1,"37":1,"38":1,"39":1,"40":1,"41":1,"42":1,"43":1,"44":1,"45":1,"46":1,"47":1,"48":1,"49":1,"50":1,"51":1,"52":1,"53":1,"54":1,"55":1,"56":1,"57":1,"58":1,"59":1,"60":1,"61":1,"62":1,"63":1,"64":1,"65":1,"66":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"73":1,"74":1,"75":1,"76":1,"77":1,"78":1,"79":1,"80":1,"81":1,"82":1,"83":1,"84":1,"85":1,"86":1,"87":1,"88":1,"89":1,"90":1,"92":1,"93":1,"94":1,"95":1,"96":1,"97":1,"98":1,"99":1,"100":1,"101":1,"102":1,"103":1,"104":1,"105":1,"106":1,"107":1,"108":1,"109":1,"110":1,"111":1,"112":1,"113":1,"114":1,"115":1,"116":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1,"138":1,"139":1,"140":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"tile":{"0":1,"1":1,"2":1,"3":1,"4":1,"5":1,"7":1,"8":1,"9":1,"10":1,"11":1,"12":1,"14":1,"15":1,"16":1,"17":1,"18":1,"19":1,"20":1,"21":1,"22":1,"23":1,"24":1,"25":1,"26":1,"27":1,"28":1,"29":1,"30":1,"31":1,"32":1,"34":1,"35":1,"36":1,"37":1,"38":1,"39":1,"42":1,"43":1,"44":1,"45":1,"46":1,"47":1,"49":1,"50":1,"51":1,"53":1,"54":1,"55":1,"56":1,"57":1,"58":1,"59":1,"60":1,"61":1,"62":1,"63":1,"65":1,"66":1,"67":1,"68":1,"71":1,"72":1,"73":1,"74":1,"75":1,"77":1,"78":1,"79":1,"81":1,"82":1,"83":1,"84":1,"86":1,"87":1,"88":1,"89":1,"92":1,"93":1,"94":1,"95":1,"96":1,"97":1,"98":1,"99":1,"100":1,"101":1,"102":1,"103":1,"104":1,"105":1,"107":1,"112":1,"113":1,"114":1,"115":1,"116":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"129":1,"130":1,"132":1,"133":1,"134":1,"135":1,"136":1,"138":1,"139":1,"140":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"source":{"0":1,"1":1,"2":1,"3":1,"4":1,"5":1,"6":1,"7":1,"8":1,"9":1,"10":1,"11":1,"12":1,"13":1,"14":1,"15":1,"16":1,"17":1,"18":1,"19":1,"20":1,"21":1,"22":1,"23":1,"24":1,"25":1,"26":1,"27":1,"28":1,"29":1,"30":1,"31":1,"32":1,"33":1,"34":1,"35":1,"36":1,"37":1,"38":1,"39":1,"40":1,"42":1,"43":1,"44":1,"45":1,"46":1,"47":1,"48":1,"49":1,"50":1,"51":1,"52":1,"53":1,"54":1,"55":1,"56":1,"57":1,"58":1,"59":1,"60":1,"61":1,"62":1,"63":1,"64":1,"65":1,"66":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"73":1,"74":1,"75":1,"76":1,"77":1,"78":1,"79":1,"80":1,"81":1,"82":1,"83":1,"84":1,"85":1,"86":1,"87":1,"88":1,"89":1,"90":1,"92":1,"93":1,"94":1,"95":1,"96":1,"97":1,"98":1,"99":1,"100":1,"101":1,"102":1,"103":1,"104":1,"105":1,"106":1,"107":1,"108":1,"109":1,"110":1,"111":1,"112":1,"113":1,"114":1,"115":1,"116":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1,"138":1,"139":1,"140":1,"141":1,"142":1,"143":1,"144":1,"145":1,"146":1,"147":1,"148":1,"149":1},"osm":{"0":1,"1":1,"4":1,"7":1,"8":1,"9":1,"10":1,"11":1,"14":1,"15":1,"18":1,"28":1,"29":1,"30":1,"35":1,"37":1,"38":1,"39":1,"44":1,"50":1,"58":1,"59":1,"63":1,"67":1,"73":1,"77":1,"78":1,"79":1,"80":1,"82":1,"83":1,"84":1,"92":1,"94":1,"97":1,"98":1,"99":1,"102":1,"104":1,"112":1,"123":1,"124":1,"127":1,"138":1,"141":1,"142":1,"145":1},"demonstrates":{"1":1,"11":1,"13":1,"25":1,"26":1,"30":1,"31":1,"32":1,"45":1,"55":1,"56":1,"81":1,"88":1,"92":1,"93":1,"94":1,"95":1,"99":1,"117":1,"140":1},"animated":{"1":1},"pan":{"1":1},"zoom":{"1":1,"21":1,"34":1,"147":1,"148":1,"149":1},"and":{"1":1,"6":1,"17":1,"19":1,"20":1,"21":1,"22":1,"34":1,"38":1,"67":1,"103":1,"105":1},"rotation":{"1":1,"11":1,"97":1,"103":1},"animation":{"1":1,"30":1,"31":1,"32":1},"proj":{"1":1,"9":1,"17":1,"18":1,"30":1,"32":1,"38":1,"44":1,"46":1,"51":1,"54":1,"57":1,"60":1,"61":1,"62":1,"68":1,"71":1,"72":1,"77":1,"78":1,"80":1,"81":1,"86":1,"89":1,"92":1,"93":1,"95":1,"99":1,"101":1,"106":1,"107":1,"108":1,"119":1,"120":1,"121":1,"124":1,"129":1,"130":1,"131":1,"133":1,"138":1,"140":1,"142":1,"143":1,"144":1,"145":1,"148":1},"image":{"2":1,"13":1,"17":1,"19":1,"28":1,"40":1,"51":1,"52":1,"53":1,"62":1,"70":1,"88":1,"89":1,"93":1,"102":1,"108":1,"131":1,"132":1,"133":1},"arcgis":{"2":1,"3":1,"120":1,"121":1,"143":1,"144":1},"mapserver":{"2":1,"3":1},"dynamiclayer":{"2":1},"mapquest":{"2":1,"3":1,"12":1,"21":1,"22":1,"23":1,"24":1,"53":1,"54":1,"61":1,"65":1,"66":1,"71":1,"72":1,"75":1,"81":1,"86":1,"92":1,"93":1,"95":1,"100":1,"101":1,"103":1,"105":1,"118":1,"119":1,"122":1,"123":1,"130":1,"132":1,"134":1,"135":1,"136":1,"149":1},"imagearcgisrest":{"2":1},"a":{"3":1,"4":1,"5":1,"7":1,"10":1,"11":1,"13":1,"15":1,"16":1,"19":1,"21":1,"25":1,"27":1,"28":1,"29":1,"31":1,"33":1,"35":1,"36":1,"38":1,"39":1,"41":1,"42":1,"44":1,"45":1,"46":1,"47":1,"49":1,"51":1,"55":1,"57":1,"60":1,"61":1,"62":1,"63":1,"65":1,"67":1,"68":1,"69":1,"70":1,"71":1,"72":1,"74":1,"77":1,"85":1,"86":1,"88":1,"89":1,"91":1,"96":1,"97":1,"98":1,"101":1,"104":1,"106":1,"107":1,"108":1,"112":1,"114":1,"115":1,"117":1,"118":1,"121":1,"123":1,"125":1,"126":1,"128":1,"130":1,"132":1,"134":1,"135":1,"136":1,"137":1,"138":1,"139":1,"141":1,"142":1,"143":1,"144":1,"146":1,"147":1,"148":1},"tiled":{"3":1,"42":1,"115":1,"129":1,"134":1,"135":1,"136":1},"tilelayer":{"3":1,"129":1,"135":1},"tilearcgisrest":{"3":1},"attributions":{"4":1},"visibily":{"4":1},"change":{"4":1,"6":1},"on":{"4":1,"47":1,"50":1,"54":1,"73":1,"84":1,"116":1,"119":1},"resize":{"4":1},"to":{"4":1,"6":1,"7":1,"8":1,"14":1,"18":1,"21":1,"25":1,"26":1,"30":1,"31":1,"32":1,"39":1,"41":1,"44":1,"46":1,"49":1,"51":1,"54":1,"55":1,"60":1,"71":1,"72":1,"79":1,"84":1,"86":1,"91":1,"92":1,"99":1,"112":1,"115":1,"119":1,"133":1},"collapse":{"4":1},"them":{"4":1},"small":{"4":1},"maps":{"4":1,"5":1,"34":1,"35":1,"36":1,"103":1,"112":1,"116":1},"openstreetmap":{"4":1,"9":1,"10":1,"11":1,"18":1,"28":1,"29":1,"37":1,"39":1,"58":1,"59":1,"63":1,"67":1,"77":1,"80":1,"84":1,"94":1,"97":1,"98":1,"99":1,"104":1,"112":1,"122":1},"attribution":{"4":1,"10":1,"15":1,"32":1,"50":1,"67":1,"68":1,"69":1,"95":1,"108":1,"120":1,"121":1,"129":1,"131":1,"133":1,"138":1,"140":1,"142":1,"143":1,"144":1,"145":1},"bing":{"5":1,"34":1,"36":1,"87":1,"147":1},"bingmaps":{"5":1,"19":1,"20":1,"31":1,"34":1,"36":1,"43":1,"51":1,"57":1,"62":1,"63":1,"74":1,"87":1,"88":1,"89":1,"124":1,"125":1,"126":1,"147":1},"shows":{"6":1,"8":1,"14":1,"41":1,"44":1,"71":1,"79":1,"115":1},"how":{"6":1,"8":1,"11":1,"14":1,"30":1,"31":1,"32":1,"41":1,"44":1,"54":1,"71":1,"79":1,"84":1,"115":1,"119":1},"the":{"6":1,"8":1,"19":1,"20":1,"22":1,"23":1,"25":1,"26":1,"43":1,"45":1,"50":1,"55":1,"72":1,"75":1,"77":1,"78":1,"85":1,"96":1,"100":1,"103":1,"105":1,"124":1,"127":1,"133":1,"134":1,"136":1,"138":1},"canvas":{"6":1,"9":1,"26":1,"47":1,"91":1,"103":1},"compositing":{"6":1},"blending":{"6":1},"mode":{"6":1},"in":{"6":1,"27":1,"41":1,"55":1,"56":1,"94":1,"109":1,"120":1,"143":1},"post":{"6":1},"precompose":{"6":1},"eventhandlers":{"6":1},"blend":{"6":1},"modes":{"6":1},"blendmode":{"6":1},"blendingmode":{"6":1},"composition":{"6":1},"vector":{"6":1,"7":1,"11":1,"12":1,"16":1,"19":1,"20":1,"22":1,"23":1,"25":1,"26":1,"28":1,"29":1,"30":1,"31":1,"32":1,"33":1,"37":1,"39":1,"43":1,"45":1,"46":1,"47":1,"48":1,"49":1,"50":1,"53":1,"54":1,"55":1,"56":1,"57":1,"64":1,"66":1,"68":1,"69":1,"72":1,"75":1,"76":1,"80":1,"85":1,"90":1,"100":1,"105":1,"106":1,"109":1,"110":1,"111":1,"116":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1},"feature":{"6":1,"7":1,"12":1,"16":1,"24":1,"30":1,"31":1,"32":1,"33":1,"37":1,"39":1,"46":1,"47":1,"48":1,"49":1,"50":1,"54":1,"64":1,"76":1,"90":1,"109":1,"110":1,"111":1,"116":1,"118":1,"119":1,"120":1,"121":1},"geom":{"6":1,"11":1,"12":1,"16":1,"23":1,"24":1,"26":1,"30":1,"31":1,"32":1,"33":1,"37":1,"38":1,"39":1,"46":1,"47":1,"48":1,"49":1,"50":1,"64":1,"66":1,"72":1,"85":1,"90":1,"91":1,"109":1,"110":1,"111":1,"116":1},"point":{"6":1,"11":1,"12":1,"16":1,"24":1,"30":1,"31":1,"39":1,"46":1,"47":1,"48":1,"49":1,"50":1,"64":1,"66":1,"90":1,"91":1,"109":1,"111":1},"style":{"6":1,"11":1,"12":1,"16":1,"19":1,"20":1,"22":1,"23":1,"24":1,"25":1,"26":1,"30":1,"31":1,"32":1,"37":1,"39":1,"43":1,"44":1,"45":1,"46":1,"47":1,"48":1,"49":1,"50":1,"53":1,"55":1,"56":1,"64":1,"66":1,"68":1,"69":1,"72":1,"76":1,"80":1,"85":1,"90":1,"91":1,"105":1,"109":1,"110":1,"111":1,"117":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"149":1},"circle":{"6":1,"11":1,"12":1,"19":1,"20":1,"22":1,"23":1,"24":1,"25":1,"30":1,"31":1,"37":1,"39":1,"43":1,"50":1,"55":1,"72":1,"76":1,"85":1,"91":1,"105":1,"109":1,"111":1,"116":1,"122":1,"124":1},"fill":{"6":1,"11":1,"12":1,"16":1,"19":1,"20":1,"22":1,"23":1,"24":1,"25":1,"26":1,"31":1,"37":1,"39":1,"43":1,"50":1,"53":1,"55":1,"56":1,"64":1,"68":1,"69":1,"72":1,"76":1,"80":1,"85":1,"90":1,"91":1,"105":1,"109":1,"111":1,"117":1,"121":1,"122":1,"123":1,"124":1},"stroke":{"6":1,"11":1,"12":1,"16":1,"19":1,"20":1,"22":1,"23":1,"24":1,"25":1,"26":1,"30":1,"31":1,"32":1,"37":1,"39":1,"43":1,"44":1,"50":1,"53":1,"55":1,"56":1,"64":1,"66":1,"68":1,"69":1,"72":1,"76":1,"80":1,"85":1,"90":1,"91":1,"105":1,"109":1,"110":1,"111":1,"117":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1},"using":{"7":1,"12":1,"15":1,"17":1,"19":1,"20":1,"22":1,"23":1,"39":1,"40":1,"43":1,"49":1,"52":1,"64":1,"72":1,"80":1,"100":1,"105":1,"109":1,"113":1,"120":1,"121":1,"124":1,"126":1,"127":1,"129":1,"133":1,"143":1,"144":1},"dragbox":{"7":1},"interaction":{"7":1,"16":1,"19":1,"20":1,"21":1,"22":1,"23":1,"25":1,"34":1,"47":1,"66":1,"72":1,"75":1,"76":1,"82":1,"100":1,"105":1,"118":1,"120":1},"select":{"7":1,"25":1,"47":1,"75":1,"76":1,"100":1,"105":1,"118":1,"120":1},"features":{"7":1,"12":1,"22":1,"23":1,"25":1,"30":1,"37":1,"41":1,"75":1,"76":1,"100":1,"117":1,"118":1,"122":1},"box":{"7":1},"selection":{"7":1},"events":{"7":1,"18":1,"22":1,"52":1,"100":1,"113":1},"condition":{"7":1,"22":1,"100":1},"format":{"7":1,"11":1,"19":1,"20":1,"25":1,"26":1,"28":1,"29":1,"31":1,"37":1,"41":1,"43":1,"45":1,"50":1,"53":1,"54":1,"55":1,"56":1,"57":1,"68":1,"69":1,"75":1,"76":1,"80":1,"85":1,"95":1,"100":1,"106":1,"117":1,"118":1,"119":1,"120":1,"121":1,"122":1,"123":1,"124":1,"125":1,"126":1,"127":1,"128":1,"137":1,"139":1,"141":1},"geojson":{"7":1,"11":1,"19":1,"20":1,"28":1,"37":1,"53":1,"54":1,"75":1,"76":1,"85":1,"100":1,"106":1,"118":1,"119":1,"122":1,"123":1,"125":1,"126":1},"this":{"8":1,"11":1,"44":1,"115":1},"customize":{"8":1},"buttons":{"8":1},"tooltips":{"8":1},"with":{"8":1,"9":1,"13":1,"19":1,"22":1,"26":1,"32":1,"34":1,"35":1,"38":1,"40":1,"42":1,"48":1,"54":1,"57":1,"58":1,"61":1,"67":1,"68":1,"75":1,"82":1,"85":1,"88":1,"92":1,"99":1,"101":1,"105":1,"106":1,"109":1,"119":1,"121":1,"122":1,"123":1,"125":1,"126":1,"130":1,"131":1,"143":1},"bootstrap":{"8":1,"81":1},"custom":{"8":1,"14":1,"15":1,"16":1,"26":1,"30":1,"46":1,"67":1,"68":1,"71":1,"82":1,"85":1,"129":1,"143":1},"tooltip":{"8":1,"55":1},"renders":{"9":1},"tiles":{"9":1,"68":1,"69":1,"80":1,"87":1,"107":1,"130":1,"143":1,"144":1,"145":1},"coordinates":{"9":1},"for":{"9":1,"66":1,"76":1,"131":1},"debugging":{"9":1},"layers":{"9":1,"41":1,"64":1,"73":1,"103":1,"107":1,"133":1,"140":1},"tiledebug":{"9":1},"cartodb":{"10":1},"simple":{"10":1,"69":1,"72":1,"104":1},"s":{"11":1,"116":1},"can":{"11":1},"be":{"11":1},"adjusted":{"11":1},"so":{"11":1},"geometry":{"11":1,"25":1,"50":1,"85":1,"91":1},"or":{"11":1},"coordinate":{"11":1,"77":1,"81":1,"86":1,"129":1,"131":1},"is":{"11":1,"133":1},"positioned":{"11":1},"at":{"11":1},"specific":{"11":1},"pixel":{"11":1,"47":1,"88":1,"89":1,"148":1},"location":{"11":1},"advanced":{"11":1,"68":1,"82":1},"positioning":{"11":1},"center":{"11":1,"103":1},"simplegeometry":{"11":1},"code":{"12":1},"cluster":{"12":1,"25":1},"clustered":{"12":1},"text":{"12":1,"25":1,"68":1,"69":1,"122":1,"123":1,"127":1},"color":{"13":1,"46":1},"manipulation":{"13":1,"51":1,"62":1},"raster":{"13":1,"88":1,"89":1,"92":1,"95":1,"102":1},"hue":{"13":1},"lightness":{"13":1},"chroma":{"13":1},"stamen":{"13":1,"17":1,"25":1,"26":1,"32":1,"45":1,"47":1,"55":1,"56":1,"107":1},"create":{"14":1,"26":1,"71":1,"72":1,"84":1,"86":1},"controls":{"14":1,"71":1,"79":1,"149":1},"icon":{"15":1,"16":1,"26":1,"31":1,"46":1,"47":1,"48":1,"49":1,"66":1,"68":1,"69":1},"object":{"15":1,"103":1},"element":{"15":1,"35":1},"interactions":{"16":1,"105":1},"drag":{"16":1,"19":1,"20":1,"21":1,"34":1,"118":1},"editing":{"16":1,"75":1,"118":1,"120":1},"linestring":{"16":1,"32":1,"33":1,"38":1,"50":1,"66":1,"72":1,"91":1,"110":1,"111":1},"polygon":{"16":1,"23":1,"26":1,"72":1,"85":1,"91":1,"116":1},"pointer":{"16":1},"tilejson":{"16":1,"46":1,"49":1,"60":1,"61":1,"73":1,"86":1,"101":1,"113":1,"114":1,"115":1,"117":1},"ol3":{"17":1},"d3":{"17":1},"together":{"17":1,"22":1,"105":1},"integration":{"17":1,"54":1},"extent":{"17":1,"25":1,"60":1,"78":1,"79":1,"92":1,"93":1,"95":1,"108":1,"130":1,"138":1,"140":1,"142":1},"imagecanvas":{"17":1},"listen":{"18":1},"deviceorientation":{"18":1},"device":{"18":1},"orientation":{"18":1,"38":1},"drop":{"19":1,"20":1},"imagevector":{"19":1,"53":1},"gpx":{"19":1,"20":1,"43":1},"igc":{"19":1,"20":1,"50":1},"kml":{"19":1,"20":1,"25":1,"26":1,"45":1,"55":1,"56":1,"57":1},"topojson":{"19":1,"20":1,"80":1,"117":1},"draganddrop":{"19":1,"20":1},"single":{"21":1,"41":1,"93":1,"131":1,"132":1},"rotate":{"21":1,"34":1},"dragrotateandzoom":{"21":1,"34":1,"82":1},"draw":{"22":1,"23":1,"66":1,"72":1,"105":1,"116":1,"120":1},"modify":{"22":1,"75":1,"76":1,"105":1,"120":1},"edit":{"22":1,"23":1,"72":1,"75":1,"76":1,"105":1,"120":1},"featureoverlay":{"22":1},"collection":{"22":1},"freehand":{"23":1},"dynamic":{"24":1},"data":{"24":1,"43":1,"50":1,"102":1,"115":1},"multipoint":{"24":1,"85":1},"use":{"25":1,"26":1,"45":1,"54":1,"55":1,"78":1,"119":1},"geometries":{"25":1,"91":1},"render":{"25":1,"26":1,"55":1,"91":1},"earthquake":{"25":1,"55":1},"clusters":{"25":1},"regularshape":{"25":1,"64":1,"90":1,"109":1},"tocanvas":{"26":1},"symbols":{"26":1,"109":1},"earthquakes":{"26":1,"45":1,"55":1},"symbol":{"26":1,"90":1,"109":1},"epsg":{"27":1,"92":1,"133":1,"143":1},"epsg4326":{"27":1},"scaleline":{"27":1,"98":1,"99":1,"129":1,"131":1},"tilewms":{"27":1,"42":1,"95":1,"116":1,"129":1,"130":1,"133":1,"134":1,"135":1,"136":1},"exporting":{"28":1,"29":1},"as":{"28":1,"29":1,"145":1},"png":{"28":1},"export":{"28":1,"29":1},"pdf":{"29":1},"wkt":{"29":1,"127":1},"animate":{"30":1,"32":1},"flash":{"30":1},"observable":{"30":1,"72":1},"easing":{"30":1},"move":{"31":1},"along":{"31":1,"119":1},"line":{"31":1,"66":1,"98":1},"marker":{"31":1,"46":1,"47":1,"49":1},"postcompose":{"31":1,"32":1},"polyline":{"31":1},"flights":{"32":1,"50":1},"flight":{"32":1},"arc":{"32":1},"fractal":{"33":1},"rendering":{"33":1,"56":1,"57":1,"60":1,"91":1,"117":1},"full":{"34":1,"35":1,"36":1,"74":1},"screen":{"34":1,"35":1,"36":1,"74":1},"effect":{"34":1},"fullscreen":{"34":1,"35":1,"36":1,"38":1,"74":1},"option":{"35":1},"definition":{"35":1},"extended":{"35":1},"fullscreensource":{"35":1},"geolocated":{"38":1},"oriented":{"38":1},"geolocation":{"38":1,"39":1,"74":1},"tracking":{"38":1},"mobile":{"38":1,"68":1,"74":1},"overlay":{"38":1,"44":1,"49":1,"72":1,"81":1,"86":1,"115":1},"wms":{"40":1,"41":1,"42":1,"95":1,"128":1,"129":1,"130":1,"131":1,"132":1,"133":1,"134":1,"135":1,"136":1},"getfeatureinfo":{"40":1,"41":1,"42":1},"requests":{"40":1,"42":1},"foreachlayeratpixel":{"40":1,"42":1},"imagewms":{"40":1,"52":1,"131":1,"132":1,"133":1},"fetch":{"41":1},"per":{"41":1},"name":{"41":1},"request":{"41":1,"125":1},"wmsgetfeatureinfo":{"41":1},"issuing":{"42":1},"add":{"44":1,"79":1},"graticule":{"44":1,"106":1},"heatmap":{"45":1},"assigning":{"46":1},"colors":{"46":1},"operations":{"47":1,"88":1},"sprite":{"48":1},"webgl":{"48":1,"58":1,"103":1,"109":1},"sprites":{"48":1},"symbolize":{"49":1},"symbolizer":{"49":1,"55":1},"popup":{"49":1,"81":1,"86":1},"tracks":{"50":1},"recorded":{"50":1},"from":{"50":1,"56":1,"89":1,"102":1,"112":1,"115":1,"117":1,"141":1},"multiple":{"50":1},"paraglider":{"50":1},"same":{"50":1,"103":1},"day":{"50":1},"read":{"50":1,"115":1},"file":{"50":1},"complex":{"50":1},"closest":{"50":1},"opencyclemap":{"50":1},"apply":{"51":1},"filter":{"51":1,"125":1},"imagery":{"51":1},"filters":{"51":1},"load":{"52":1,"113":1},"loading":{"52":1,"113":1,"120":1,"121":1,"123":1,"124":1,"126":1},"jsts":{"54":1},"openlayers":{"54":1,"119":1},"buffer":{"54":1},"shape":{"55":1,"90":1},"locations":{"55":1},"timezones":{"56":1},"clipping":{"58":1,"59":1},"has":{"58":1,"103":1,"139":1},"restricting":{"60":1},"limited":{"60":1},"group":{"61":1,"71":1},"groups":{"61":1},"input":{"61":1},"bind":{"61":1},"layergroup":{"61":1},"portion":{"62":1},"one":{"62":1,"103":1,"112":1},"over":{"62":1},"another":{"62":1,"112":1},"spy":{"62":1},"swipe":{"63":1},"ordering":{"64":1},"z":{"64":1},"index":{"64":1},"setting":{"65":1},"after":{"65":1},"construction":{"65":1},"lazy":{"65":1},"drawing":{"66":1},"arrows":{"66":1},"each":{"66":1},"string":{"66":1},"segment":{"66":1},"arrow":{"66":1},"localized":{"67":1},"server":{"67":1,"120":1,"121":1,"123":1,"124":1,"126":1},"openseamap":{"67":1},"mapbox":{"68":1,"69":1},"grid":{"68":1},"mvt":{"68":1,"69":1},"vectortile":{"68":1,"69":1,"80":1},"tilegrid":{"68":1,"95":1,"130":1,"138":1,"140":1,"142":1},"untiled":{"70":1},"mapguide":{"70":1},"imagemapguide":{"70":1},"measuring":{"72":1},"application":{"72":1,"120":1},"measure":{"72":1},"sphere":{"72":1,"106":1,"116":1},"show":{"73":1},"hide":{"73":1},"depending":{"73":1},"current":{"73":1},"resolution":{"73":1,"103":1},"min":{"73":1},"max":{"73":1},"minresolution":{"73":1},"maxresolution":{"73":1},"testing":{"76":1},"modification":{"76":1},"test":{"76":1},"mouse":{"77":1},"position":{"77":1},"outside":{"77":1},"mouseposition":{"77":1},"moveend":{"78":1},"event":{"78":1},"navigation":{"79":1},"zoomtoextent":{"79":1},"overlays":{"81":1},"popover":{"81":1},"openaerial":{"81":1,"86":1},"overviewmap":{"82":1,"83":1},"customization":{"82":1},"overview":{"82":1,"83":1},"permalinks":{"84":1},"permalink":{"84":1},"history":{"84":1},"showing":{"85":1},"vertices":{"85":1},"styles":{"85":1,"90":1},"geometryfunction":{"85":1},"uses":{"86":1},"preloading":{"87":1},"preload":{"87":1},"pixelwise":{"88":1},"grow":{"89":1},"region":{"89":1},"seed":{"89":1},"growing":{"89":1},"some":{"90":1},"regular":{"90":1},"shapes":{"90":1},"square":{"90":1,"130":1},"cross":{"90":1},"star":{"90":1},"triangle":{"90":1},"x":{"90":1},"arbitrary":{"91":1,"92":1},"client":{"92":1,"93":1,"94":1,"95":1,"99":1,"133":1},"side":{"92":1,"93":1,"94":1,"95":1,"99":1,"103":1},"reprojection":{"92":1,"93":1,"94":1,"95":1,"99":1},"projection":{"92":1,"93":1,"94":1,"95":1,"99":1,"106":1,"108":1,"129":1,"131":1,"133":1,"143":1,"148":1},"io":{"92":1},"search":{"92":1},"proj4js":{"92":1,"93":1,"95":1,"106":1,"131":1},"tileimage":{"92":1,"95":1},"imagestatic":{"93":1,"108":1},"wgs84":{"94":1},"between":{"95":1},"various":{"95":1,"149":1},"projections":{"95":1},"wmts":{"95":1,"137":1,"138":1,"139":1,"140":1,"141":1,"142":1},"hidpi":{"95":1,"139":1,"145":1},"wmtscapabilities":{"95":1,"137":1,"139":1,"141":1},"xyz":{"95":1,"96":1,"102":1,"120":1,"121":1,"143":1,"144":1,"145":1,"146":1},"updating":{"96":1},"by":{"96":1,"103":1},"changing":{"96":1,"136":1,"138":1},"url":{"96":1},"reusable":{"96":1},"rotated":{"97":1},"scale":{"98":1},"nad83":{"99":1},"indiana":{"99":1},"east":{"99":1},"semi":{"101":1},"transparent":{"101":1},"calculate":{"102":1},"shaded":{"102":1},"relief":{"102":1},"elevation":{"102":1},"three":{"103":1},"dom":{"103":1},"share":{"103":1},"shared":{"103":1},"views":{"103":1},"sync":{"103":1},"snap":{"105":1},"mollweide":{"106":1},"component":{"106":1},"watercolor":{"107":1},"terrain":{"107":1},"labels":{"107":1,"122":1},"two":{"107":1,"133":1},"static":{"108":1},"xkcd":{"108":1},"atlas":{"109":1},"atlasmanager":{"109":1},"synthetic":{"110":1,"111":1},"lines":{"110":1},"points":{"111":1},"moving":{"112":1},"target":{"112":1},"teleporting":{"112":1},"teleport":{"112":1},"tileutfgrid":{"115":1},"utfgrid":{"115":1},"tissot":{"116":1},"indicatrices":{"116":1},"indicatrix":{"116":1},"topology":{"117":1},"translate":{"118":1},"turf":{"119":1},"js":{"119":1},"turfjs":{"119":1},"distance":{"119":1},"rest":{"120":1,"121":1,"143":1,"144":1},"service":{"120":1,"121":1},"editable":{"120":1},"esri":{"120":1,"121":1,"143":1,"144":1},"updatefeature":{"120":1},"addfeature":{"120":1},"esrijson":{"120":1,"121":1},"loadingstrategy":{"120":1,"121":1,"124":1,"126":1},"strategy":{"121":1,"126":1},"label":{"122":1},"countries":{"123":1},"country":{"123":1},"information":{"123":1},"xml":{"123":1,"124":1},"osmxml":{"124":1},"making":{"125":1},"wfs":{"125":1,"126":1},"getfeature":{"125":1},"ogc":{"125":1},"bbox":{"126":1},"parser":{"127":1},"well":{"127":1},"known":{"127":1},"parsing":{"128":1,"137":1},"getcapabilities":{"128":1,"137":1,"141":1},"response":{"128":1,"137":1},"capabilities":{"128":1,"137":1,"141":1},"wmscapabilities":{"128":1},"transform":{"129":1},"functions":{"129":1},"512x256px":{"130":1},"512x256":{"130":1},"non":{"130":1},"integrating":{"131":1},"transforms":{"131":1},"which":{"133":1},"unknown":{"133":1},"without":{"133":1},"that":{"134":1},"wraps":{"134":1},"across":{"134":1},"meridian":{"134":1},"wrapping":{"134":1},"dateline":{"134":1},"wrap":{"134":1},"smooth":{"136":1,"138":1},"transitions":{"136":1,"138":1},"when":{"136":1,"138":1},"time":{"136":1},"dimension":{"136":1,"138":1},"dimensions":{"136":1},"transition":{"136":1,"138":1},"parameter":{"138":1},"based":{"139":1},"high":{"139":1},"dpi":{"139":1},"retina":{"139":1,"145":1},"displaying":{"140":1},"ign":{"140":1},"france":{"140":1},"french":{"140":1},"geoportail":{"140":1},"created":{"141":1},"document":{"141":1},"512x512":{"143":1},"tilesize":{"143":1},"mercator":{"145":1},"512x512px":{"145":1},"available":{"145":1},"maptiler":{"145":1},"2x":{"145":1},"devicepixelratio":{"145":1},"constrained":{"147":1},"minzoom":{"147":1},"maxzoom":{"147":1},"zoomify":{"148":1},"deep":{"148":1},"zoomslider":{"149":1},"sliders":{"149":1},"slider":{"149":1},"styling":{"149":1},"css":{"149":1}}}