<?php
?>

<!DOCTYPE html>
<html>
<head>
  <title>gvSIGCE downloads Map</title>
  <meta charset="utf-8" />
  <link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-0.7.2/leaflet.css" />   
  <link rel="stylesheet" href="style.css" />
  <link rel="stylesheet" href="gvsigce.css" />
</head>
<body>
  <div id="page">
  <div><a href="http://gvsigce.org" id="gvsigcelogo">Your logo</a></div>
  <div id="header" class="header"> <div id="banner">gvSIG CE downloads</div></div>
    <div id="datepickerstart">Start Date: <input type="text" id="datepickerstartval" size="10" class="normaltext"><span class="error1 normaltext"> Invalid Date</span></div>
    <div id="datepickerstop">End Date: <input type="text" id="datepickerstopval" size="10" class="normaltext"><span class="error2 normaltext"> Invalid Date</span></div>
    <div id="refreshbutton" class="bigtext">Query by dates</div>
  <div id="text"></div>
  <div id="map"></div>
  <div id="footer" class="footer"></div>
  <script src="leaflet.js"></script>
 <!-- <link rel="stylesheet" href="//code.jquery.com/ui/1.10.4/themes/smoothness/jquery-ui.css"> -->
 <link href="css/normalize.css" rel="stylesheet" type="text/css"/>

 <link href="css/datepicker.css" rel="stylesheet" type="text/css"/> 
 <script src="//code.jquery.com/jquery-1.10.2.js"></script>
 <script src="//code.jquery.com/ui/1.10.4/jquery-ui.js"></script>


 <script>  
 // hide error message
$('.error1').hide();
$('.error2').hide();
 function ValidateDate(dtValue) {
   var dtRegex = new RegExp(/^(\b\d{1,2}[\/-]\d{1,2}[\/-]\d{4}\b)?$/);
   // /\b\d{1,2}[\/-]\d{1,2}[\/-]\d{4}\b/
   // /^([0-9]{1,2}\-\[0-9]{1,2}\-\[0-9]{4})?$
 return dtRegex.test(dtValue); }

 $(function() {
   $( "#datepickerstartval" ).datepicker({
      firstDay: 1,
      inline: true,
      showOtherMonths: true
   });
   $( "#datepickerstopval" ).datepicker({
      firstDay: 1,
      inline: true,
      showOtherMonths: true
   });
 });
 
 
 // add function to button
 $("#refreshbutton").click( function() {
   var startdt= $("#datepickerstartval").val();
   var stopdt = $("#datepickerstopval").val()
   var d_startdt = new Date(startdt);
   var d_stopdt = new Date(stopdt);
 if (d_startdt > d_stopdt){
   alert (" Your start date is before the end date plese fix this");
 }
 else {
   if(ValidateDate(startdt)) { 
     $('.error1').hide();
     if(ValidateDate(stopdt)) { 
       $('.error2').hide(); 
       mapqueryp = "start="+startdt+"&stop="+stopdt;
       $('#map').append('<div id="busy-symbol"><img id="img-spinner" src="img/ajax-loader.gif" alt="Loading new data..."/></div>');
       refreshLayer(mapqueryp);
     }
     else {$('.error2').show();
       // event.preventDefault();
     }
   }
   else {$('.error1').show();
     // event.preventDefault();
   }

   }
 }
 )
 // get geojson data via postgres query
  <?php echo 'var countries = '; include 'get_countries_with_stats.php'; ?>

  var mapqueryp = ""; //"start=2014-03-20&stop=2014-04-20";
  var curzoom, newradius;
  var map = new L.Map("map", {center: [35,-0], zoom: 2, zoomControl: false, attributionControl: false})
  var terraatri = L.control.attribution({position: 'bottomleft'}).addTo(map);
  // removeAttribution(
  terraatri.setPrefix('Map created by <a href="http://terragis.net">Terra GIS LTD</a> using Leaflet Viewer, original data from Sourceforge loaded into PostGIS');
  
  L.tileLayer('http://{s}.www.toolserver.org/tiles/bw-mapnik/{z}/{x}/{y}.png').addTo(map); //will be our basemap
  var info = L.control({ position: 'topleft' });



  info.onAdd = function (map) {
    this._div = L.DomUtil.create('div', 'info');
    this.update();
    return this._div;
  };

  info.update = function (props) {
    this._div.innerHTML = '<h4>Country</h4>' +  (props ?
      '<b>' + props.name + '</b><br><b>gvSIGCE downloads: ' + props.dl + '</b>'
      : 'To see downloads hover over a country');
  };

  info.addTo(map);


  var zoomc = L.control.zoom({position: 'topright'});
  zoomc.addTo(map);

function refreshLayer(mapqueryp) {
    geojson.clearLayers();
    $.getJSON("get_countries_with_stats.php?"+mapqueryp, function (data) {
        geojson.addData(data);
        $( "div" ).remove( "#busy-symbol" );
    })
}


function getColor(d) {
    return d > 1000 ? '#800026' :
           d > 500  ? '#BD0026' :
           d > 200  ? '#E31A1C' :
           d > 100  ? '#FC4E2A' :
           d > 50   ? '#FD8D3C' :
           d > 20   ? '#FEB24C' :
           d > 10   ? '#FED976' :
           d > 0    ? '#FFEDA0' :
                      '#FFF';
}


  function style(feature) {           
      return {
          opacity: 0.65,
          color: '#666',
          weight: 1.3,
          fillOpacity: 0.65,
          fillColor:  getColor(feature.properties.dl)
      };
  }
  
  

  function highlightFeature(e) {
    var layer = e.target;

    layer.setStyle({
      weight: 8,
      color: '#666',
      opacity: 1,
      fillColor: '#12599B',
      dashArray: '1',
      weight: 2.5,
      fillOpacity: 0.8
    });

    if (!L.Browser.ie && !L.Browser.opera) {
      layer.bringToFront();
    }

    info.update(layer.feature.properties);
  }

  var geojson;

  function resetHighlight(e) {
    geojson.resetStyle(e.target);
    info.update();
  }

  function zoomToFeature(e) {
    map.fitBounds(e.target.getBounds());
  }

  function onEachFeature(feature, layer) {
    layer.on({
      mouseover: highlightFeature,
      mouseout: resetHighlight,
      click: zoomToFeature
    });
  }

  geojson = L.geoJson(countries, {
    style: style,
    onEachFeature: onEachFeature
  }).addTo(map);
    var legend = L.control({position: 'bottomright'});

    legend.onAdd = function (map) {

      var div = L.DomUtil.create('div', 'info legend'),
        grades = [1, 10, 20, 50, 100, 200, 500, 1000],
        labels = [],
        from, to;

      for (var i = 0; i < grades.length; i++) {
        from = grades[i];
        to = grades[i + 1];

        labels.push(
          '<i style="background:' + getColor(from + 1) + '"></i> ' +
          from + (to ? '&ndash;' + to : '+'));
      }

      div.innerHTML = labels.join('<br>');
      return div;
    };

    legend.addTo(map);


  </script>
 <div id="datepicker"></div>
 </body>
</html>