<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>MapServer WMS Layer on Top of Commercial maps</title>
    <style type="text/css">
	#mapandlegend {
            width: 1140;
            height: 700;
            position:relative;			
        }
        #map {
            width: 900;
            height: 600;
            border: 1px solid black;
        }
		#thelegend {
            width: 220;
            height: 220;
            border: 1px solid black;
            position:absolute;
            top:10px;
            right:0px;	
        }
		#nodeList {
            width: 220;
            height: 160;
            position:absolute;
            top:250px;
            right:0px;	
           	font-size: 0.7em;
           	font: 0.7em "Lucida Grande", Verdana, Lucida, Helvetica, Arial, sans-serif;            		
        }
    .style1 {
	font-family: Arial, Helvetica, sans-serif;
	font-weight: bold;
}
    .style2 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 24px;
}

    </style>
    <script src="../../openlayers2/OpenLayers.js"></script> 
    <!-- include the Google V3.2 API , no key needed but still need to include the API--> 
    <script src="http://maps.google.com/maps/api/js?sensor=false&v=3.2"></script>   
    <script type="text/javascript" src="../identify/ext-3.4.0/adapter/ext/ext-base.js"></script>
    <script type="text/javascript" src="../identify/ext-3.4.0/ext-all.js"></script>         
    <script type="text/javascript">
        var map;
        var options = {
                projection: new OpenLayers.Projection("EPSG:3857"),
                units: "m",
                maxResolution: 156543.0339,
                maxExtent: new OpenLayers.Bounds(-13776237,5870705,-13270618,6177605)
        };
        // GM - these controls will make for an editable polyon overlay on the map
        var vectorlayer = new OpenLayers.Layer.Vector("Selected Area");
        var editcontrol = new OpenLayers.Control.ModifyFeature(vectorlayer);
        var drawcontrol = new OpenLayers.Control.DrawFeature(vectorlayer,OpenLayers.Handler.Polygon);
        // avoid pink tiles
        OpenLayers.IMAGE_RELOAD_ATTEMPTS = 3;
        OpenLayers.Util.onImageLoadErrorColor = "transparent";
      
        window.onload = function(){
            map = new OpenLayers.Map( 'map',  options );

            //GM - having this set to "visible" makes more sense
            //GM - I also fixed the syntax for singleTile
            var Members = new OpenLayers.Layer.WMS( "members", "/cgi-bin/mapserv.exe?map=c:/class/data/mapfiles/map_file_library/elections.map", {layers: 'members', 'transparent': true}, {isBaseLayer: false, 'opacity': 0.7, 'visibility': true, singleTile:true} );

            var g_streets = new OpenLayers.Layer.Google( "Google Roads", {numZoomLevels: 20});
            g_streets.buffer = 0; 
            // map.addLayer(g_streets); // add to map no tile buffer                  	 
            var bounds = new OpenLayers.Bounds(-13776237,5870705,-13270618,6177605); 
            map.addLayers([g_streets,Members]);                      	 
            map.zoomToExtent(bounds);                    
            map.addControl( new OpenLayers.Control.LayerSwitcher() );
            mp=new OpenLayers.Control.MousePosition();
            mp.displayProjection = new OpenLayers.Projection("EPSG:3857");
            map.addControl(mp);
            // GM - add those vector layers and controls to the map
            map.addLayer(vectorlayer);
            map.addControl(editcontrol);
            map.addControl(drawcontrol);
          }

        // GM - the functions for manipulating the digitizer
        function startPolygon() {
            // toggle controls appropriately
            editcontrol.deactivate();
            drawcontrol.activate();
            hideForm();
            // clear any features
            vectorlayer.destroyFeatures();
        }
        function editPolygon() {
            // toggle controls appropriately
            editcontrol.activate();
            drawcontrol.deactivate();
            hideForm();
            // select the feature
            editcontrol.selectControl.select(vectorlayer.features[0]);
        }
        function donePolygon() {
            // toggle controls appropriately
            editcontrol.deactivate();
            drawcontrol.deactivate();
            // if there's a feature digitized, show the form
            vectorlayer.features[0] ? showForm() : hideForm();
        }
        // GM - some quickies to make it easier to toggle the form to match the "is anything digitized?" state
        function showForm() {
            var form = document.getElementById('submit_polygon');
            form.style.display = 'block';
            form.elements['wkt'].value = vectorlayer.features[0].geometry.toString();
        }
        function hideForm() {
            var form = document.getElementById('submit_polygon');
            form.style.display = 'none';
            form.elements['wkt'].value = '';
        }
        // GM - the AJAX stuff for submitting the polygon
        function submitPolygon(form) {
            // no WKT? then nothing to submit, forget it
            if (!form.elements['wkt'].value) return false;
            // translate the form into a request and make the AJAX call
            data = '';
            data += 'organizer=' + document.forms['submit_polygon'].elements['organizer'].value;
            data += '&';
            data += 'wkt=' + document.forms['submit_polygon'].elements['wkt'].value;
            var theorganizer = document.forms['submit_polygon'].elements['organizer'].value;
            var thewkt = document.forms['submit_polygon'].elements['wkt'].value;
            Ext.Ajax.request({
                url: 'save_polygon.php',
                params: {
                    organizer: theorganizer,
                    wkt: thewkt 
                },
                success: function(xhr) {
                    submittedPolygon(xhr);
                }
            })             
            // new OpenLayers.Ajax.Request('save_polygon.php',{method:'post', postBody:data, onComplete:submittedPolygon});
            // hide the submit form, and purge the old polygon
            hideForm();
            startPolygon();
            donePolygon();
            // all done; don't let the form actually submit
            return false;
        }
        function submittedPolygon(request) {
            // reload the members layer, as it has been modified
            map.getLayersByName('members')[0].redraw(true);
            // the text is just the number of affected people
            var howmany = parseInt(request.responseText);
            alert('Assigned ' + howmany + ' voters to an organizer.');
        }
        // GM - add some action handlers to smooth the workflow
        // GM - when they submit a polygon, switch to editing mode automatically
        // GM - when they leave editing mode, open the form automatically
        vectorlayer.events.register('featureadded',vectorlayer,editPolygon);
        vectorlayer.events.register('afterfeaturemodified',vectorlayer,donePolygon);
    </script>
  </head>
  <body>
    <div id="title">
      <h1 class="style2">Elections</h1>
    </div>
    <div id="tags"></div>
    <div id="shortdesc"> </div>
	<div id="mapandlegend">
	<div id="map"></div>
    <div id="thelegend"><span class="style1">Legend</span>
    	<div><img src="/cgi-bin/mapserv.exe?map=c:/class/data/mapfiles/map_file_library/elections.map"&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=members&format=image/png" alt="legend"></div>
	</div>
 	<div id="nodeList"></div>
	</div>
    <!-- GM - the form for submitting the point. note the 'wkt' field which is populated by showForm() and hideForm() -->
        <form id="submit_polygon" name="submit_polygon" action="javascript:void(0);" method="post" onSubmit="return submitPolygon(this);" style="display:none;" >
        <input type="hidden" name="wkt" value="" />
        <select name="organizer">
        <option value="1">Karsten</option>
        <option value="4">Gregor</option>
        <option value="9">Doug</option>
        <option value="16">Tim</option>
        </select>
        <input type="submit" value="set organizer for the selected members" />
        </form>
    <!-- GM - the buttons for selecting the digitizer mode -->
        <p>
        <a href="javascript:void(0);" onClick="startPolygon();">draw</a>
        <a href="javascript:void(0);" onClick="editPolygon();">edit</a>
        <a href="javascript:void(0);" onClick="donePolygon();">done</a>
        <p/>
    <div id="docs"></div>
  </body>
</html>                                        