<?php
/******************************************************************************
 *
 * Purpose: execute query
 * Author:  Armin Burger
 *
 ******************************************************************************
 *
 * Copyright (c) 2003-2007 Armin Burger
 *
 * This file is part of p.mapper.
 *
 * p.mapper is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * p.mapper is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/

require_once("../group.php");
require_once("../pmsession.php");
require_once("../globals.php");
require_once("../common.php");
require_once("../query/squery.php");
require_once("../query/search.php");

$mode = $_REQUEST['mode'];

//pm_logDebug(3, $_REQUEST, "REQUEST array in x_info.php");

$jsonPMResult = $_SESSION['JSON_Results'];

// Run QUERY
$mapQuery = new Query($map);
$mapQuery->q_processQuery();
$queryResult = $mapQuery->q_returnQueryResult();
//$numResultsTotal = $mapQuery->q_returnNumResultsTotal();

$result = "{\"mode\":\"$mode\", \"queryResult\":$queryResult}";


if (in_array('selectionManagement', $_SESSION['plugins'])) {
	require_once("../../plugins/common/selectTools.inc.php");
	
	$selectMethod = isset($_REQUEST['selectMethod']) && $_REQUEST['selectMethod'] ? $_REQUEST['selectMethod'] : false;

	if ($selectMethod) {
		$queryResult = SelectTools::mixSelection($selectMethod, $jsonPMResult, $queryResult);
		if ($queryResult) {
			$_SESSION['JSON_Results'] = $queryResult;
		} else {
			unset($_SESSION['JSON_Results']);
			unset($_SESSION['resultlayers']);
			unset($queryResult);
		}
		SelectTools::updateHighlightJson($queryResult);
		
		if ($queryResult) {
			$result = "{\"mode\":\"$mode\", \"queryResult\":$queryResult}";
		} else {
			$result = "{\"mode\":\"$mode\", \"queryResult\":0}";
		}
	}
}

header("Content-type: text/plain; charset=$defCharset");
echo $result;
?>