

/*******************************************************************
 sorttable.js
 
 http://www.kryogenix.org/code/browser/sorttable/
 
 Code downloaded from the Browser Experiments section of 
 kryogenix.org is licenced under the so-called MIT licence. 
 The licence is below.

 Copyright (c) 1997-date Stuart Langridge

 Permission is hereby granted, free of charge, to any person 
 obtaining a copy of this software and associated documentation 
 files (the "Software"), to deal in the Software without 
 restriction, including without limitation the rights to use, 
 copy, modify, merge, publish, distribute, sublicense, and/or 
 sell copies of the Software, and to permit persons to whom the 
 Software is furnished to do so, subject to the following conditions:

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER  
 DEALINGS IN THE SOFTWARE.

********************************************************************/


/* This notice must be untouched at all times.

wz_jsgraphics.js    v. 2.3
The latest version is available at
http://www.walterzorn.com
or http://www.devira.com
or http://www.walterzorn.de

Copyright (c) 2002-2004 Walter Zorn. All rights reserved.
Created 3. 11. 2002 by Walter Zorn (Web: http://www.walterzorn.com )
Last modified: 29. 9. 2004

Performance optimizations for Internet Explorer
by Thomas Frank and John Holdsworth.
fillPolygon method implemented by Matthieu Haller.

High Performance JavaScript Graphics Library.
Provides methods
- to draw lines, rectangles, ellipses, polygons
  with specifiable line thickness,
- to fill rectangles and ellipses
- to draw text.
NOTE: Operations, functions and branching have rather been optimized
to efficiency and speed than to shortness of source code.

LICENSE: LGPL

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License (LGPL) as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
or see http://www.gnu.org/copyleft/lesser.html 
*/


/************************************************************
                    Slider control creator
              By Mark Wilton-Jones 12-13/10/2002
Version 1.1 updated 22/10/2003 to provide hand cursor option
*************************************************************

Please see http://www.howtocreate.co.uk/jslibs/ for details and a demo of this script
Please see http://www.howtocreate.co.uk/jslibs/termsOfUse.html for terms of use
*/

 Array.prototype.indexOf=function(n){for(var i=0;i<this.length;i++){if(this[i]===n){return i;}};return-1;};Array.prototype.lastIndexOf=function(n){var i=this.length;while(i--){if(this[i]===n){return i;}};return-1;};Array.prototype.forEach=function(f){var i=this.length,j,l=this.length;for(i=0;i<l;i++){if((j=this[i])){f(j);}}};Array.prototype.insert=function(i,v){if(i>=0){var a=this.slice(),b=a.splice(i);a[i]=value;return a.concat(b);}};Array.prototype.remove=function(v){if(this.indexOf(v)>-1){return this.splice(this.indexOf(v),1);}};Array.prototype.unique=function(){var a=[],i;this.sort();for(i=0;i<this.length;i++){if(this[i]!==this[i+1]){a[a.length]=this[i];}};return a;};Array.prototype.addunique=function(v){if(this.indexOf(v)<0){this[this.length]=v;};return this.length;};Array.prototype.pushunique=function(){for(var i=0,j=0,b=this.length,a=arguments;i<a.length;i++,j++){if(this.indexOf(a[i])<0){this[b+j]=a[i];}else{j--}};return this.length;};if(typeof Array.prototype.concat==='undefined'){Array.prototype.concat=function(a){for(var i=0,b=this.copy();i<a.length;i++){b[b.length]=a[i];};return b;};};if(typeof Array.prototype.copy==='undefined'){Array.prototype.copy=function(a){var a=[],i=this.length;while(i--){a[i]=(typeof this[i].copy!=='undefined')?this[i].copy():this[i];};return a;};};if(typeof Array.prototype.pop==='undefined'){Array.prototype.pop=function(){var b=this[this.length-1];this.length--;return b;};};if(typeof Array.prototype.push==='undefined'){Array.prototype.push=function(){for(var i=0,b=this.length,a=arguments;i<a.length;i++){this[b+i]=a[i];};return this.length;};};if(typeof Array.prototype.shift==='undefined'){Array.prototype.shift=function(){for(var i=0,b=this[0];i<this.length-1;i++){this[i]=this[i+1];};this.length--;return b;};};if(typeof Array.prototype.slice==='undefined'){Array.prototype.slice=function(a,c){var i=0,b,d=[];if(!c){c=this.length;};if(c<0){c=this.length+c;};if(a<0){a=this.length-a;};if(c<a){b=a;a=c;c=b;};for(i;i<c-a;i++){d[i]=this[a+i];};return d;};};if(typeof Array.prototype.splice==='undefined'){Array.prototype.splice=function(a,c){var i=0,e=arguments,d=this.copy(),f=a;if(!c){c=this.length-a;};for(i;i<e.length-2;i++){this[a+i]=e[i+2];};for(a;a<this.length-c;a++){this[a+e.length-2]=d[a-c];};this.length-=c-e.length+2;return d.slice(f,f+c);};};if(typeof Array.prototype.unshift==='undefined'){Array.prototype.unshift=function(a){this.reverse();var b=this.push(a);this.reverse();return b;};}
 var SORT_COLUMN_INDEX;function sortables_init(){if(!document.getElementsByTagName)return;var tbls=document.getElementsByTagName("table");for(ti=0;ti<tbls.length;ti++){thisTbl=tbls[ti];if(thisTbl.className=="sortable"){ts_makeSortable(thisTbl);}}};function ts_makeSortable(table){if(table.rows&&table.rows.length>0){var firstRow=table.rows[0];};if(!firstRow)return;for(var i=0;i<firstRow.cells.length;i++){var cell=firstRow.cells[i];var txt=ts_getInnerText(cell);var headerHtml='<a href="#" class="sortheader" onclick="ts_resortTable(this);return false;"><span class="sortheaderlabel">'+txt+'</span><span class="sortarrow">&nbsp;&nbsp;&nbsp;</span></a>';cell.className='sortheader';cell.innerHTML=headerHtml;}};function ts_getInnerText(el){if(typeof el=="string")return el;if(typeof el=="undefined"){return el};if(el.innerText)return el.innerText;var str="";var cs=el.childNodes;var l=cs.length;for(var i=0;i<l;i++){switch(cs[i].nodeType){case 1: str+=ts_getInnerText(cs[i]);break;case 3: str+=cs[i].nodeValue;break;}};return str;};function ts_alignTables(){var tableList=document.getElementsByTagName("table");for(var t=0;t<tableList.length;t++){if(tableList[t].className=='sortable'){ts_alignCols(tableList[t]);}}};function ts_alignCols(table){if(!table.rows[1])return false;var colList=table.rows[1].cells;for(var cl=0;cl<colList.length;cl++){var itm=ts_getInnerText(table.rows[1].cells[cl]);align="left";if(table.rows[1].cells[cl].className=='zoomlink')align="center";if(itm.match(/^\d\d[\/-]\d\d[\/-]\d\d\d\d$/))align="right";if(itm.match(/^\d\d[\/-]\d\d[\/-]\d\d$/))align="right";if(itm.match(/^[$]/))align="right";if(itm.match(/^[\d\.]+$/))align="right";for(var r=0;r<table.rows.length;r++){if(table.rows[r].cells[cl]){table.rows[r].cells[cl].style.textAlign=align;}}}};function ts_resortTable(lnk){var span;for(var ci=0;ci<lnk.childNodes.length;ci++){if(lnk.childNodes[ci].tagName&&lnk.childNodes[ci].tagName.toLowerCase()=='span')span=lnk.childNodes[ci];};var spantext=ts_getInnerText(span);var td=lnk.parentNode;var column=td.cellIndex;var table=getParent(td,'TABLE');if(table.rows.length<=1)return;var itm=ts_getInnerText(table.rows[1].cells[column]);sortfn=ts_sort_caseinsensitive;if(itm.match(/^\d\d[\/-]\d\d[\/-]\d\d\d\d$/))sortfn=ts_sort_date;if(itm.match(/^\d\d[\/-]\d\d[\/-]\d\d$/))sortfn=ts_sort_date;if(itm.match(/^[$]/))sortfn=ts_sort_currency;if(itm.match(/^[\d\.]+$/))sortfn=ts_sort_numeric;SORT_COLUMN_INDEX=column;var firstRow=new Array();var newRows=new Array();for(i=0;i<table.rows[0].length;i++){firstRow[i]=table.rows[0][i];};for(j=1;j<table.rows.length;j++){newRows[j-1]=table.rows[j];};newRows.sort(sortfn);if(span.getAttribute("sortdir")=='down'){ARROW='&nbsp;&nbsp;<img src="images/upsimple.png">';newRows.reverse();span.setAttribute('sortdir','up');}else{ARROW='&nbsp;&nbsp;<img src="images/downsimple.png">';span.setAttribute('sortdir','down');};for(i=0;i<newRows.length;i++){if(!newRows[i].className||(newRows[i].className&&(newRows[i].className.indexOf('sortbottom')==-1)))table.tBodies[0].appendChild(newRows[i]);};for(i=0;i<newRows.length;i++){if(newRows[i].className&&(newRows[i].className.indexOf('sortbottom')!=-1))table.tBodies[0].appendChild(newRows[i]);};var allspans=document.getElementsByTagName("span");for(var ci=0;ci<allspans.length;ci++){if(allspans[ci].className=='sortarrow'){if(getParent(allspans[ci],"table")==getParent(lnk,"table")){allspans[ci].innerHTML='&nbsp;&nbsp;&nbsp;';}}};span.innerHTML=ARROW;};function getParent(el,pTagName){if(el==null)return null;else if(el.nodeType==1&&el.tagName.toLowerCase()==pTagName.toLowerCase())return el;else return getParent(el.parentNode,pTagName);};function ts_sort_date(a,b){aa=ts_getInnerText(a.cells[SORT_COLUMN_INDEX]);bb=ts_getInnerText(b.cells[SORT_COLUMN_INDEX]);if(aa.length==10){dt1=aa.substr(6,4)+aa.substr(3,2)+aa.substr(0,2);}else{yr=aa.substr(6,2);if(parseInt(yr)<50){yr='20'+yr;}else{yr='19'+yr;};dt1=yr+aa.substr(3,2)+aa.substr(0,2);};if(bb.length==10){dt2=bb.substr(6,4)+bb.substr(3,2)+bb.substr(0,2);}else{yr=bb.substr(6,2);if(parseInt(yr)<50){yr='20'+yr;}else{yr='19'+yr;};dt2=yr+bb.substr(3,2)+bb.substr(0,2);};if(dt1==dt2)return 0;if(dt1<dt2)return-1;return 1;};function ts_sort_currency(a,b){aa=ts_getInnerText(a.cells[SORT_COLUMN_INDEX]).replace(/[^0-9.]/g,'');bb=ts_getInnerText(b.cells[SORT_COLUMN_INDEX]).replace(/[^0-9.]/g,'');return parseFloat(aa)-parseFloat(bb);};function ts_sort_numeric(a,b){aa=parseFloat(ts_getInnerText(a.cells[SORT_COLUMN_INDEX]));if(isNaN(aa))aa=0;bb=parseFloat(ts_getInnerText(b.cells[SORT_COLUMN_INDEX]));if(isNaN(bb))bb=0;return aa-bb;};function ts_sort_caseinsensitive(a,b){aa=ts_getInnerText(a.cells[SORT_COLUMN_INDEX]).toLowerCase();bb=ts_getInnerText(b.cells[SORT_COLUMN_INDEX]).toLowerCase();if(aa==bb)return 0;if(aa<bb)return-1;return 1;};function ts_sort_default(a,b){aa=ts_getInnerText(a.cells[SORT_COLUMN_INDEX]);bb=ts_getInnerText(b.cells[SORT_COLUMN_INDEX]);if(aa==bb)return 0;if(aa<bb)return-1;return 1;};function addEvent(elm,evType,fn,useCapture){if(elm.addEventListener){elm.addEventListener(evType,fn,useCapture);return true;}else if(elm.attachEvent){var r=elm.attachEvent("on"+evType,fn);return r;}else{alert("Handler could not be removed");}}
 var jg_ok,jg_ie,jg_fast,jg_dom,jg_moz;function _chkDHTM(wnd,x,i){x=wnd.document.body||null;jg_ie=x&&typeof x.insertAdjacentHTML !="undefined"&&wnd.document.createElement;jg_dom=(x&&!jg_ie&&typeof x.appendChild !="undefined"&&typeof wnd.document.createRange !="undefined"&&typeof(i=wnd.document.createRange()).setStartBefore !="undefined"&&typeof i.createContextualFragment !="undefined");jg_fast=jg_ie&&wnd.document.all&&!wnd.opera;jg_moz=jg_dom&&typeof x.style.MozOpacity !="undefined";jg_ok=!!(jg_ie||jg_dom);};function _pntCnvDom(){var x=this.wnd.document.createRange();x.setStartBefore(this.cnv);x=x.createContextualFragment(jg_fast?this._htmRpc(): this.htm);if(this.cnv)this.cnv.appendChild(x);this.htm="";};function _pntCnvIe(){if(this.cnv)this.cnv.insertAdjacentHTML("BeforeEnd",jg_fast?this._htmRpc(): this.htm);this.htm="";};function _pntDoc(){this.wnd.document.write(jg_fast?this._htmRpc(): this.htm);this.htm='';};function _pntN(){;};function _mkDiv(x,y,w,h){this.htm+='<div style="position:absolute;'+'left:'+x+'px;'+'top:'+y+'px;'+'width:'+w+'px;'+'height:'+h+'px;'+'clip:rect(0,'+w+'px,'+h+'px,0);'+'background-color:'+this.color+(!jg_moz?';overflow:hidden' : '')+';"><\/div>';};function _mkDivIe(x,y,w,h){this.htm+='%%'+this.color+';'+x+';'+y+';'+w+';'+h+';';};function _mkDivPrt(x,y,w,h){this.htm+='<div style="position:absolute;'+'border-left:'+w+'px solid '+this.color+';'+'left:'+x+'px;'+'top:'+y+'px;'+'width:0px;'+'height:'+h+'px;'+'clip:rect(0,'+w+'px,'+h+'px,0);'+'background-color:'+this.color+(!jg_moz?';overflow:hidden' : '')+';"><\/div>';};var _regex=/%%([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);/g;function _htmRpc(){return this.htm.replace(_regex,'<div style="overflow:hidden;position:absolute;background-color:'+'$1;left:$2px;top:$3px;width:$4px;height:$5px"></div>\n');};function _htmPrtRpc(){return this.htm.replace(_regex,'<div style="overflow:hidden;position:absolute;background-color:'+'$1;left:$2px;top:$3px;width:$4px;height:$5px;border-left:$4px solid $1"></div>\n');};function _mkLin(x1,y1,x2,y2){if(x1>x2){var _x2=x2;var _y2=y2;x2=x1;y2=y1;x1=_x2;y1=_y2;};var dx=x2-x1,dy=Math.abs(y2-y1),x=x1,y=y1,yIncr=(y1>y2)?-1 : 1;if(dx>=dy){var pr=dy<<1,pru=pr-(dx<<1),p=pr-dx,ox=x;while(dx>0){--dx;++x;if(p>0){this._mkDiv(ox,y,x-ox,1);y+=yIncr;p+=pru;ox=x;}else p+=pr;};this._mkDiv(ox,y,x2-ox+1,1);}else{var pr=dx<<1,pru=pr-(dy<<1),p=pr-dy,oy=y;if(y2<=y1){while(dy>0){--dy;if(p>0){this._mkDiv(x++,y,1,oy-y+1);y+=yIncr;p+=pru;oy=y;}else{y+=yIncr;p+=pr;}};this._mkDiv(x2,y2,1,oy-y2+1);}else{while(dy>0){--dy;y+=yIncr;if(p>0){this._mkDiv(x++,oy,1,y-oy);p+=pru;oy=y;}else p+=pr;};this._mkDiv(x2,oy,1,y2-oy+1);}}};function _mkLin2D(x1,y1,x2,y2){if(x1>x2){var _x2=x2;var _y2=y2;x2=x1;y2=y1;x1=_x2;y1=_y2;};var dx=x2-x1,dy=Math.abs(y2-y1),x=x1,y=y1,yIncr=(y1>y2)?-1 : 1;var s=this.stroke;if(dx>=dy){if(dx>0&&s-3>0){var _s=(s*dx*Math.sqrt(1+dy*dy/(dx*dx))-dx-(s>>1)*dy)/dx;_s=(!(s-4)?Math.ceil(_s): Math.round(_s))+1;}else var _s=s;var ad=Math.ceil(s/2);var pr=dy<<1,pru=pr-(dx<<1),p=pr-dx,ox=x;while(dx>0){--dx;++x;if(p>0){this._mkDiv(ox,y,x-ox+ad,_s);y+=yIncr;p+=pru;ox=x;}else p+=pr;};this._mkDiv(ox,y,x2-ox+ad+1,_s);}else{if(s-3>0){var _s=(s*dy*Math.sqrt(1+dx*dx/(dy*dy))-(s>>1)*dx-dy)/dy;_s=(!(s-4)?Math.ceil(_s): Math.round(_s))+1;}else var _s=s;var ad=Math.round(s/2);var pr=dx<<1,pru=pr-(dy<<1),p=pr-dy,oy=y;if(y2<=y1){++ad;while(dy>0){--dy;if(p>0){this._mkDiv(x++,y,_s,oy-y+ad);y+=yIncr;p+=pru;oy=y;}else{y+=yIncr;p+=pr;}};this._mkDiv(x2,y2,_s,oy-y2+ad);}else{while(dy>0){--dy;y+=yIncr;if(p>0){this._mkDiv(x++,oy,_s,y-oy+ad);p+=pru;oy=y;}else p+=pr;};this._mkDiv(x2,oy,_s,y2-oy+ad+1);}}};function _mkLinDott(x1,y1,x2,y2){if(x1>x2){var _x2=x2;var _y2=y2;x2=x1;y2=y1;x1=_x2;y1=_y2;};var dx=x2-x1,dy=Math.abs(y2-y1),x=x1,y=y1,yIncr=(y1>y2)?-1 : 1,drw=true;if(dx>=dy){var pr=dy<<1,pru=pr-(dx<<1),p=pr-dx;while(dx>0){--dx;if(drw)this._mkDiv(x,y,1,1);drw=!drw;if(p>0){y+=yIncr;p+=pru;}else p+=pr;++x;}}else{var pr=dx<<1,pru=pr-(dy<<1),p=pr-dy;while(dy>0){--dy;if(drw)this._mkDiv(x,y,1,1);drw=!drw;y+=yIncr;if(p>0){++x;p+=pru;}else p+=pr;}};if(drw)this._mkDiv(x,y,1,1);};function _mkOv(left,top,width,height){var a=(++width)>>1,b=(++height)>>1,wod=width&1,hod=height&1,cx=left+a,cy=top+b,x=0,y=b,ox=0,oy=b,aa2=(a*a)<<1,aa4=aa2<<1,bb2=(b*b)<<1,bb4=bb2<<1,st=(aa2>>1)*(1-(b<<1))+bb2,tt=(bb2>>1)-aa2*((b<<1)-1),w,h;while(y>0){if(st<0){st+=bb2*((x<<1)+3);tt+=bb4*(++x);}else if(tt<0){st+=bb2*((x<<1)+3)-aa4*(y-1);tt+=bb4*(++x)-aa2*(((y--)<<1)-3);w=x-ox;h=oy-y;if((w&2)&&(h&2)){this._mkOvQds(cx,cy,x-2,y+2,1,1,wod,hod);this._mkOvQds(cx,cy,x-1,y+1,1,1,wod,hod);}else this._mkOvQds(cx,cy,x-1,oy,w,h,wod,hod);ox=x;oy=y;}else{tt-=aa2*((y<<1)-3);st-=aa4*(--y);}};w=a-ox+1;h=(oy<<1)+hod;y=cy-oy;this._mkDiv(cx-a,y,w,h);this._mkDiv(cx+ox+wod-1,y,w,h);};function _mkOv2D(left,top,width,height){var s=this.stroke;width+=s+1;height+=s+1;var a=width>>1,b=height>>1,wod=width&1,hod=height&1,cx=left+a,cy=top+b,x=0,y=b,aa2=(a*a)<<1,aa4=aa2<<1,bb2=(b*b)<<1,bb4=bb2<<1,st=(aa2>>1)*(1-(b<<1))+bb2,tt=(bb2>>1)-aa2*((b<<1)-1);if(s-4<0&&(!(s-2)||width-51>0&&height-51>0)){var ox=0,oy=b,w,h,pxw;while(y>0){if(st<0){st+=bb2*((x<<1)+3);tt+=bb4*(++x);}else if(tt<0){st+=bb2*((x<<1)+3)-aa4*(y-1);tt+=bb4*(++x)-aa2*(((y--)<<1)-3);w=x-ox;h=oy-y;if(w-1){pxw=w+1+(s&1);h=s;}else if(h-1){pxw=s;h+=1+(s&1);}else pxw=h=s;this._mkOvQds(cx,cy,x-1,oy,pxw,h,wod,hod);ox=x;oy=y;}else{tt-=aa2*((y<<1)-3);st-=aa4*(--y);}};this._mkDiv(cx-a,cy-oy,s,(oy<<1)+hod);this._mkDiv(cx+a+wod-s,cy-oy,s,(oy<<1)+hod);}else{var _a=(width-(s<<1))>>1,_b=(height-(s<<1))>>1,_x=0,_y=_b,_aa2=(_a*_a)<<1,_aa4=_aa2<<1,_bb2=(_b*_b)<<1,_bb4=_bb2<<1,_st=(_aa2>>1)*(1-(_b<<1))+_bb2,_tt=(_bb2>>1)-_aa2*((_b<<1)-1),pxl=new Array(),pxt=new Array(),_pxb=new Array();pxl[0]=0;pxt[0]=b;_pxb[0]=_b-1;while(y>0){if(st<0){pxl[pxl.length]=x;pxt[pxt.length]=y;st+=bb2*((x<<1)+3);tt+=bb4*(++x);}else if(tt<0){pxl[pxl.length]=x;st+=bb2*((x<<1)+3)-aa4*(y-1);tt+=bb4*(++x)-aa2*(((y--)<<1)-3);pxt[pxt.length]=y;}else{tt-=aa2*((y<<1)-3);st-=aa4*(--y);};if(_y>0){if(_st<0){_st+=_bb2*((_x<<1)+3);_tt+=_bb4*(++_x);_pxb[_pxb.length]=_y-1;}else if(_tt<0){_st+=_bb2*((_x<<1)+3)-_aa4*(_y-1);_tt+=_bb4*(++_x)-_aa2*(((_y--)<<1)-3);_pxb[_pxb.length]=_y-1;}else{_tt-=_aa2*((_y<<1)-3);_st-=_aa4*(--_y);_pxb[_pxb.length-1]--;}}};var ox=-wod,oy=b,_oy=_pxb[0],l=pxl.length,w,h;for(var i=0;i<l;i++){if(typeof _pxb[i] !="undefined"){if(_pxb[i]<_oy||pxt[i]<oy){x=pxl[i];this._mkOvQds(cx,cy,x,oy,x-ox,oy-_oy,wod,hod);ox=x;oy=pxt[i];_oy=_pxb[i];}}else{x=pxl[i];this._mkDiv(cx-x,cy-oy,1,(oy<<1)+hod);this._mkDiv(cx+ox+wod,cy-oy,1,(oy<<1)+hod);ox=x;oy=pxt[i];}};this._mkDiv(cx-a,cy-oy,1,(oy<<1)+hod);this._mkDiv(cx+ox+wod,cy-oy,1,(oy<<1)+hod);}};function _mkOvDott(left,top,width,height){var a=(++width)>>1,b=(++height)>>1,wod=width&1,hod=height&1,hodu=hod^1,cx=left+a,cy=top+b,x=0,y=b,aa2=(a*a)<<1,aa4=aa2<<1,bb2=(b*b)<<1,bb4=bb2<<1,st=(aa2>>1)*(1-(b<<1))+bb2,tt=(bb2>>1)-aa2*((b<<1)-1),drw=true;while(y>0){if(st<0){st+=bb2*((x<<1)+3);tt+=bb4*(++x);}else if(tt<0){st+=bb2*((x<<1)+3)-aa4*(y-1);tt+=bb4*(++x)-aa2*(((y--)<<1)-3);}else{tt-=aa2*((y<<1)-3);st-=aa4*(--y);};if(drw&&y>=hodu)this._mkOvQds(cx,cy,x,y,1,1,wod,hod);drw=!drw;}};function _mkRect(x,y,w,h){var s=this.stroke;this._mkDiv(x,y,w,s);this._mkDiv(x+w,y,s,h);this._mkDiv(x,y+h,w+s,s);this._mkDiv(x,y+s,s,h-s);};function _mkRectDott(x,y,w,h){this.drawLine(x,y,x+w,y);this.drawLine(x+w,y,x+w,y+h);this.drawLine(x,y+h,x+w,y+h);this.drawLine(x,y,x,y+h);};function jsgFont(){this.PLAIN='font-weight:normal;';this.BOLD='font-weight:bold;';this.ITALIC='font-style:italic;';this.ITALIC_BOLD=this.ITALIC+this.BOLD;this.BOLD_ITALIC=this.ITALIC_BOLD;};var Font=new jsgFont();function jsgStroke(){this.DOTTED=-1;};var Stroke=new jsgStroke();function jsGraphics(cnv,wnd){this.setColor=function(x){this.color=x.toLowerCase();};this.setStroke=function(x){this.stroke=x;if(!(x+1)){this.drawLine=_mkLinDott;this._mkOv=_mkOvDott;this.drawRect=_mkRectDott;}else if(x-1>0){this.drawLine=_mkLin2D;this._mkOv=_mkOv2D;this.drawRect=_mkRect;}else{this.drawLine=_mkLin;this._mkOv=_mkOv;this.drawRect=_mkRect;}};this.setPrintable=function(arg){this.printable=arg;if(jg_fast){this._mkDiv=_mkDivIe;this._htmRpc=arg?_htmPrtRpc : _htmRpc;}else this._mkDiv=arg?_mkDivPrt : _mkDiv;};this.setFont=function(fam,sz,sty){this.ftFam=fam;this.ftSz=sz;this.ftSty=sty||Font.PLAIN;};this.drawPolyline=this.drawPolyLine=function(x,y){for(var i=x.length-1;i;){--i;this.drawLine(x[i],y[i],x[i+1],y[i+1]);}};this.fillRect=function(x,y,w,h){this._mkDiv(x,y,w,h);};this.drawPolygon=function(x,y){this.drawPolyline(x,y);this.drawLine(x[x.length-1],y[x.length-1],x[0],y[0]);};this.drawEllipse=this.drawOval=function(x,y,w,h){this._mkOv(x,y,w,h);};this.fillEllipse=this.fillOval=function(left,top,w,h){var a=w>>1,b=h>>1,wod=w&1,hod=h&1,cx=left+a,cy=top+b,x=0,y=b,oy=b,aa2=(a*a)<<1,aa4=aa2<<1,bb2=(b*b)<<1,bb4=bb2<<1,st=(aa2>>1)*(1-(b<<1))+bb2,tt=(bb2>>1)-aa2*((b<<1)-1),xl,dw,dh;if(w)while(y>0){if(st<0){st+=bb2*((x<<1)+3);tt+=bb4*(++x);}else if(tt<0){st+=bb2*((x<<1)+3)-aa4*(y-1);xl=cx-x;dw=(x<<1)+wod;tt+=bb4*(++x)-aa2*(((y--)<<1)-3);dh=oy-y;this._mkDiv(xl,cy-oy,dw,dh);this._mkDiv(xl,cy+y+hod,dw,dh);oy=y;}else{tt-=aa2*((y<<1)-3);st-=aa4*(--y);}};this._mkDiv(cx-a,cy-oy,w,(oy<<1)+hod);};this.fillArc=function(iL,iT,iW,iH,fAngA,fAngZ){var a=iW>>1,b=iH>>1,iOdds=(iW&1)|((iH&1)<<16),cx=iL+a,cy=iT+b,x=0,y=b,ox=x,oy=y,aa2=(a*a)<<1,aa4=aa2<<1,bb2=(b*b)<<1,bb4=bb2<<1,st=(aa2>>1)*(1-(b<<1))+bb2,tt=(bb2>>1)-aa2*((b<<1)-1),xEndA,yEndA,xEndZ,yEndZ,iSects=(1<<(Math.floor((fAngA %=360.0)/180.0)<<3))|(2<<(Math.floor((fAngZ %=360.0)/180.0)<<3))|((fAngA>=fAngZ)<<16),aBndA=new Array(b+1),aBndZ=new Array(b+1);fAngA*=Math.PI/180.0;fAngZ*=Math.PI/180.0;xEndA=cx+Math.round(a*Math.cos(fAngA));yEndA=cy+Math.round(-b*Math.sin(fAngA));_mkLinVirt(aBndA,cx,cy,xEndA,yEndA);xEndZ=cx+Math.round(a*Math.cos(fAngZ));yEndZ=cy+Math.round(-b*Math.sin(fAngZ));_mkLinVirt(aBndZ,cx,cy,xEndZ,yEndZ);while(y>0){if(st<0){st+=bb2*((x<<1)+3);tt+=bb4*(++x);}else if(tt<0){st+=bb2*((x<<1)+3)-aa4*(y-1);ox=x;tt+=bb4*(++x)-aa2*(((y--)<<1)-3);this._mkArcDiv(ox,y,oy,cx,cy,iOdds,aBndA,aBndZ,iSects);oy=y;}else{tt-=aa2*((y<<1)-3);st-=aa4*(--y);if(y&&(aBndA[y] !=aBndA[y-1]||aBndZ[y] !=aBndZ[y-1])){this._mkArcDiv(x,y,oy,cx,cy,iOdds,aBndA,aBndZ,iSects);ox=x;oy=y;}}};this._mkArcDiv(x,0,oy,cx,cy,iOdds,aBndA,aBndZ,iSects);if(iOdds>>16){if(iSects>>16){var xl=(yEndA<=cy||yEndZ>cy)?(cx-x): cx;this._mkDiv(xl,cy,x+cx-xl+(iOdds & 0xffff),1);}else if((iSects & 0x01)&&yEndZ>cy)this._mkDiv(cx-x,cy,x,1);}};this.fillPolygon=function(array_x,array_y){var i;var y;var miny,maxy;var x1,y1;var x2,y2;var ind1,ind2;var ints;var n=array_x.length;if(!n)return;miny=array_y[0];maxy=array_y[0];for(i=1;i<n;i++){if(array_y[i]<miny)miny=array_y[i];if(array_y[i]>maxy)maxy=array_y[i];};for(y=miny;y<=maxy;y++){var polyInts=new Array();ints=0;for(i=0;i<n;i++){if(!i){ind1=n-1;ind2=0;}else{ind1=i-1;ind2=i;};y1=array_y[ind1];y2=array_y[ind2];if(y1<y2){x1=array_x[ind1];x2=array_x[ind2];}else if(y1>y2){y2=array_y[ind1];y1=array_y[ind2];x2=array_x[ind1];x1=array_x[ind2];}else continue;if((y>=y1)&&(y<y2))polyInts[ints++]=Math.round((y-y1)*(x2-x1)/(y2-y1)+x1);else if((y==maxy)&&(y>y1)&&(y<=y2))polyInts[ints++]=Math.round((y-y1)*(x2-x1)/(y2-y1)+x1);};polyInts.sort(_CompInt);for(i=0;i<ints;i+=2)this._mkDiv(polyInts[i],y,polyInts[i+1]-polyInts[i]+1,1);}};this.drawString=function(txt,x,y){this.htm+='<div style="position:absolute;white-space:nowrap;'+'left:'+x+'px;'+'top:'+y+'px;'+'font-family:'+this.ftFam+';'+'font-size:'+this.ftSz+';'+'color:'+this.color+';'+this.ftSty+'">'+txt+'<\/div>';};this.drawStringRect=function(txt,x,y,width,halign){this.htm+='<div style="position:absolute;overflow:hidden;'+'left:'+x+'px;'+'top:'+y+'px;'+'width:'+width+'px;'+'text-align:'+halign+';'+'font-family:'+this.ftFam+';'+'font-size:'+this.ftSz+';'+'color:'+this.color+';'+this.ftSty+'">'+txt+'<\/div>';};this.drawImage=function(imgSrc,x,y,w,h,a){this.htm+='<div style="position:absolute;'+'left:'+x+'px;'+'top:'+y+'px;'+(w?('width:'+w+'px;'): '')+(h?('height:'+h+'px;'):'')+'">'+'<img src="'+imgSrc+'"'+(w?(' width="'+w+'"'):'')+(h?(' height="'+h+'"'):'')+(a?(' '+a): '')+'>'+'<\/div>';};this.clear=function(){this.htm="";if(this.cnv)this.cnv.innerHTML="";};this._mkOvQds=function(cx,cy,x,y,w,h,wod,hod){var xl=cx-x,xr=cx+x+wod-w,yt=cy-y,yb=cy+y+hod-h;if(xr>xl+w){this._mkDiv(xr,yt,w,h);this._mkDiv(xr,yb,w,h);}else w=xr-xl+w;this._mkDiv(xl,yt,w,h);this._mkDiv(xl,yb,w,h);};this._mkArcDiv=function(x,y,oy,cx,cy,iOdds,aBndA,aBndZ,iSects){var xrDef=cx+x+(iOdds & 0xffff),y2,h=oy-y,xl,xr,w;if(!h)h=1;x=cx-x;if(iSects & 0xff0000){y2=cy-y-h;if(iSects & 0x00ff){if(iSects & 0x02){xl=Math.max(x,aBndZ[y]);w=xrDef-xl;if(w>0)this._mkDiv(xl,y2,w,h);};if(iSects & 0x01){xr=Math.min(xrDef,aBndA[y]);w=xr-x;if(w>0)this._mkDiv(x,y2,w,h);}}else this._mkDiv(x,y2,xrDef-x,h);y2=cy+y+(iOdds>>16);if(iSects & 0xff00){if(iSects & 0x0100){xl=Math.max(x,aBndA[y]);w=xrDef-xl;if(w>0)this._mkDiv(xl,y2,w,h);};if(iSects & 0x0200){xr=Math.min(xrDef,aBndZ[y]);w=xr-x;if(w>0)this._mkDiv(x,y2,w,h);}}else this._mkDiv(x,y2,xrDef-x,h);}else{if(iSects & 0x00ff){if(iSects & 0x02)xl=Math.max(x,aBndZ[y]);else xl=x;if(iSects & 0x01)xr=Math.min(xrDef,aBndA[y]);else xr=xrDef;y2=cy-y-h;w=xr-xl;if(w>0)this._mkDiv(xl,y2,w,h);};if(iSects & 0xff00){if(iSects & 0x0100)xl=Math.max(x,aBndA[y]);else xl=x;if(iSects & 0x0200)xr=Math.min(xrDef,aBndZ[y]);else xr=xrDef;y2=cy+y+(iOdds>>16);w=xr-xl;if(w>0)this._mkDiv(xl,y2,w,h);}}};this.setStroke(1);this.setFont("verdana,geneva,helvetica,sans-serif","12px",Font.PLAIN);this.color="#000000";this.htm="";this.wnd=wnd||window;if(!jg_ok)_chkDHTM(this.wnd);if(jg_ok){if(cnv){if(typeof(cnv)=="string")this.cont=document.all?(this.wnd.document.all[cnv]||null): document.getElementById?(this.wnd.document.getElementById(cnv)||null): null;else if(cnv==window.document)this.cont=document.getElementsByTagName("body")[0];else this.cont=cnv;this.cnv=this.wnd.document.createElement("div");this.cnv.style.fontSize=0;this.cont.appendChild(this.cnv);this.paint=jg_dom?_pntCnvDom : _pntCnvIe;}else this.paint=_pntDoc;}else this.paint=_pntN;this.setPrintable(false);};function _mkLinVirt(aLin,x1,y1,x2,y2){var dx=Math.abs(x2-x1),dy=Math.abs(y2-y1),x=x1,y=y1,xIncr=(x1>x2)?-1 : 1,yIncr=(y1>y2)?-1 : 1,p,i=0;if(dx>=dy){var pr=dy<<1,pru=pr-(dx<<1);p=pr-dx;while(dx>0){--dx;if(p>0){aLin[i++]=x;y+=yIncr;p+=pru;}else p+=pr;x+=xIncr;}}else{var pr=dx<<1,pru=pr-(dy<<1);p=pr-dy;while(dy>0){--dy;y+=yIncr;aLin[i++]=x;if(p>0){x+=xIncr;p+=pru;}else p+=pr;}};for(var len=aLin.length,i=len-i;i;)aLin[len-(i--)]=x;};function _CompInt(x,y){return(x-y);}
 var myslider;var slScale;function createZSlider(sliderElemId){if(_$(sliderElemId)){myslider=new slider(sliderElemId,140,14,'#666666',1,'#000000',2,'#666666',14,20,'#999999',1,'<img src="images/slider_updown.gif" style="display:block;margin:auto;" alt=""/>',false,'sliderMove','sliderStop',true);}};function sliderMove(sliderPosition){currScale=PM.scale;if(PM.zsliderVertical)sliderPosition=1-sliderPosition;slScale=sliderx2Scale(sliderPosition);var strlenSlScale=parseInt(slScale).toString().length;var redFact=Math.pow(10,strlenSlScale-2);slScale=Math.round(slScale/redFact)*redFact;_$("scaleform").scale.value=slScale;var scaleRatio=currScale/slScale;PM.ZoomBox.resizeMap(scaleRatio);PM.ZoomBox.resizeRefBox(scaleRatio);};function sliderx2Scale(x){var sliderScale=(1-x)*PM.s1+(x*PM.s2)-(x*(1-x)*PM.s1);return sliderScale;};function sliderStop(){PM.Map.zoom2scale(slScale);mouseIsPressed=false;return false;};function getSliderPosition(curscale){var s1=PM.s1;var s2=PM.s2;var eqPart=Math.sqrt((s2*s2)+(4*s1*curscale)-(4*s1*s2));var pos=((2*s1)-s2+eqPart)/(2*s1);if(pos<0||pos>1){pos=((2*s1)-s2-eqPart)/(2*s1);};if(pos>1||isNaN(pos))pos=1;if(PM.zsliderVertical)pos=1-pos;return pos;};var mouseIsPressed=false;var MWJ_slider_controls=0;function sliderMousePos(e){if(!e){e=window.event;};if(!e||(typeof(e.pageX)!='number'&&typeof(e.clientX)!='number')){return [0,0];};if(typeof(e.pageX)=='number'){var xcoord=e.pageX;var ycoord=e.pageY;}else{var xcoord=e.clientX;var ycoord=e.clientY;if(!((window.navigator.userAgent.indexOf('Opera')+1)||(window.ScriptEngine&&ScriptEngine().indexOf('InScript')+1)||window.navigator.vendor=='KDE')){if(document.documentElement&&(document.documentElement.scrollTop||document.documentElement.scrollLeft)){xcoord+=document.documentElement.scrollLeft;ycoord+=document.documentElement.scrollTop;}else if(document.body&&(document.body.scrollTop||document.body.scrollLeft)){xcoord+=document.body.scrollLeft;ycoord+=document.body.scrollTop;}}};return [xcoord,ycoord];};function slideIsDown(e){window.msStartCoord=sliderMousePos(e);window.lyStartCoord=this.style?[parseInt(this.style.left),parseInt(this.style.top)]:[parseInt(this.left),parseInt(this.top)];if(document.captureEvents&&Event.MOUSEMOVE){document.captureEvents(Event.MOUSEMOVE);document.captureEvents(Event.MOUSEUP);};window.storeMOUSEMOVE=document.onmousemove;window.storeMOUSEUP=document.onmouseup;window.storeLayer=this;mouseIsPressed=true;document.onmousemove=slideIsMove;document.onmouseup=slideIsMove;return false;};function slideIsMove(e){if(mouseIsPressed){var msMvCo=sliderMousePos(e);if(!e){e=window.event?window.event :(new Object());};var theLayer=window.storeLayer.style?window.storeLayer.style : window.storeLayer;var oPix=document.childNodes?'px' : 0;if(window.storeLayer.hor){var theNewPos=window.lyStartCoord[0]+(msMvCo[0]-window.msStartCoord[0]);if(theNewPos<0){theNewPos=0;};if(theNewPos>window.storeLayer.maxLength){theNewPos=window.storeLayer.maxLength;};theLayer.left=theNewPos+oPix;}else{var theNewPos=window.lyStartCoord[1]+(msMvCo[1]-window.msStartCoord[1]);if(theNewPos<0){theNewPos=0;};if(theNewPos>window.storeLayer.maxLength){theNewPos=window.storeLayer.maxLength;};theLayer.top=theNewPos+oPix;};if(e.type&&e.type.toLowerCase()=='mousemove'){if(window.storeLayer.moveFunc){window.storeLayer.moveFunc(theNewPos/window.storeLayer.maxLength);}}else{document.onmousemove=storeMOUSEMOVE;document.onmouseup=window.storeMOUSEUP;if(window.storeLayer.stopFunc){window.storeLayer.stopFunc(theNewPos/window.storeLayer.maxLength);}}}};function setSliderPosition(oPortion){if(isNaN(oPortion)||oPortion<0){oPortion=0;};if(oPortion>1){oPortion=1;};var theDiv=document.getElementById(this.id);if(!theDiv){return false};if(theDiv.style){theDiv=theDiv.style;};oPortion=Math.round(oPortion*this.maxLength);var oPix=document.childNodes?'px' : 0;if(this.align){theDiv.left=oPortion+oPix;}else{theDiv.top=oPortion+oPix;}};function slider(sliderElemId,oThght,oTwdth,oTcol,oTBthk,oTBcol,oTRthk,oTRcol,oBhght,oBwdth,oBcol,oBthk,oBtxt,oAlgn,oMf,oSf,oCrs){var sliderStr=('<div style="position:relative;left:0px;top:0px;height:'+(oThght+(2*oTBthk))+'px;width:'+(oTwdth+(2*oTBthk))+'px;background-color:'+oTBcol+';font-size:0px;">'+'<div style="position:relative;left:'+oTBthk+'px;top:'+oTBthk+'px;height:'+oThght+'px;width:'+oTwdth+'px;background-color:'+oTcol+';font-size:0px;">'+'<div style="position:absolute;left:'+(oAlgn?0:Math.floor((oTwdth-oTRthk)/2))+'px;top:'+(oAlgn?Math.floor((oThght-oTRthk)/2):0)+'px;height:'+(oAlgn?oTRthk:oThght)+'px;width:'+(oAlgn?oTwdth:oTRthk)+'px;background-color:'+oTRcol+';font-size:0px;"><\/div>'+'<div style="position:absolute;left:'+(oAlgn?0:Math.floor((oTwdth-(oBwdth+(2*oBthk)))/2))+'px;top:'+(oAlgn?Math.floor((oThght-(oBhght+(2*oBthk)))/2):0)+'px;height:'+(oBhght+(2*oBthk))+'px;width:'+(oBwdth+(2*oBthk))+'px;font-size:0px;" ondragstart="return false;" onselectstart="return false;" onmouseover="this.hor='+oAlgn+';this.maxLength='+((oAlgn?oTwdth:oThght)-((oAlgn?oBwdth:oBhght)+(2*oBthk)))+';this.moveFunc='+oMf+';this.stopFunc='+oSf+';this.onmousedown=slideIsDown;" id="MWJ_slider_controls'+MWJ_slider_controls+'">'+'<div style="border-top:'+oBthk+'px solid #ffffff;border-left:'+oBthk+'px solid #ffffff;border-right:'+oBthk+'px solid #000000;border-bottom:'+oBthk+'px solid #000000;">'+'<div style="height:'+oBhght+'px;width:'+oBwdth+'px;font-size:0px;background-color:'+oBcol+';cursor:'+(oCrs?'pointer;cursor:move':'default')+';">'+'<span style="width:100%;text-align:center;">'+oBtxt+'<\/span><\/div><\/div><\/div><\/div><\/div>');document.getElementById(sliderElemId).innerHTML=sliderStr;this.id='MWJ_slider_controls'+MWJ_slider_controls;this.maxLength=(oAlgn?oTwdth:oThght)-((oAlgn?oBwdth:oBhght)+(2*oBthk));this.align=oAlgn;this.setPosition=setSliderPosition;MWJ_slider_controls++;}
