<?php

function shutDownFunction() {
	// Get last error and test if it's timeout error
	$error = error_get_last();
	if ($error && $error['type'] == 1)	 {
		$ret['errTimeout'] = false;
		$ret['memorySize'] = false;

		if (strripos($error['message'], 'Maximum execution time') === 0) {
			$ret['errTimeout'] = true;
		} else if (strripos($error['message'], 'Allowed memory size') === 0) {
			$ret['memorySize'] = true;
		}
			
		echo json_encode($ret);
	}
}

function readIniFile($path) {
	$ini = array();
	
	if (file_exists($path)) {
		$ini = parse_ini_file($path, true);
	}
	
	if (!$ini) {
		$ini['exportLayer']['bCanceled'] = 0;
		$ini['exportLayer']['progress'] = 0;
	}
	
	return $ini;
}

function writeIniFile($path, $tab) {
	$handle = fopen($path, 'w+');
	if ($handle) {
		foreach ($tab as $section => $elements) {
			fwrite($handle, "[$section]\r\n");
			foreach ($elements as $element => $value) {
				fwrite($handle, "$element = $value\r\n");
			}
		}
		
	fclose($handle);
	}
}

function initIniFile($pathIniFile) {
	$ini = readIniFile($pathIniFile);
	writeIniFile($pathIniFile, $ini);
}

function isExportCanceled ($pathIniFile) {
	$ini = readIniFile($pathIniFile);
	return $ini['exportLayer']['bCanceled'];
}

function getProgress ($pathIniFile) {
	$ini = readIniFile($pathIniFile);
	return $ini['exportLayer']['progress'];
}

function cancelExport($pathIniFile) {
	$ini = readIniFile($pathIniFile);
	$ini['exportLayer']['bCanceled'] = 1;
	writeIniFile($pathIniFile, $ini);
}

function setProgress($pathIniFile, $value) {
	$ini = readIniFile($pathIniFile);
	$ini['exportLayer']['progress'] = $value;
	writeIniFile($pathIniFile, $ini);
}

function getAttrType($dns, $schema, $table, $attrArray) {
	$result = false;

	if ($schema && $table && $attrArray && is_array($attrArray)) {
		$query = "SELECT column_name, data_type, character_maximum_length
		FROM information_schema.tables as t
		LEFT JOIN information_schema.columns as c USING (table_schema, table_name)
		WHERE table_schema = '$schema' and table_name = '$table' AND column_name";
		 
		if (isset($attrArray[1])) {
			$attrString = implode("','", $attrArray);
	 		$query .= " IN ('$attrString')";
		} else {
			$query .= " = '$attrString'";
		}

		try {
			$pdo = new PDO($dns['dsn'], $dns['user'], $dns['password']);
	 		$pdo->exec("SET client_encoding = 'WIN1252';");
	 		$qresult = $pdo->query($query);

	 		if ($qresult->rowCount() != 0) {
		 		$result = array();
		 		while ($row = $qresult->fetch()) {
			 		$result[$row[0]] = array();
			 		switch ($row[1]) {
			 			case 'boolean' :
			 			$result[$row[0]]['type'] = 'L';
			 			$result[$row[0]]['length'] = 0;
			 			$result[$row[0]]['prec'] = 0;
			 			break;
		
			 			case 'date' :
			 					$result[$row[0]]['type'] = 'D';
			 					$result[$row[0]]['length'] = 0;
			 					$result[$row[0]]['prec'] = 0;
			 					break;
		
			 			case 'bigint' :
			 			case 'integer' :
			 			case 'smallint' :
			 			case 'double precision' :
			 			case 'serial' :
			 			case 'numeric' :
		 				case 'real' :
		 					$result[$row[0]]['type'] = 'N';
		 					$result[$row[0]]['length'] = 0;
		 					$result[$row[0]]['prec'] = 0;
		 					break;
		 									
		 				case 'character' :
		 				case 'text' :
		 				case 'character varying' :
		 					$result[$row[0]]['type'] = 'C';
		
		 					if ($row[2]) {
		 						$result[$row[0]]['length'] = intval($row[2]);
			 				} else {
			 					$result[$row[0]]['length'] = 0;
			 				}
			 				
			 				$result[$row[0]]['prec'] = 0;
			 				break;
			 		}
		 		}
		 	}

		} catch (PDOException $e) {
	 		$result = false;
		}
	}

	if (is_array($result) && !count($result)) {
		$result = false;
	}
	
	return $result;
}

function addAttDbf (&$dbfArray, $attrHeader, $attrValue) {
	if (isset($dbfArray[$attrHeader])) {
		
		switch ($dbfArray[$attrHeader]['type']) {
			case 'C' :
				if ($attrValue) {
				$strlen = strlen($attrValue);
				if ($strlen > $dbfArray[$attrHeader]['length']) {
					$dbfArray[$attrHeader]['length'] = $strlen;
				}
					$dbfArray[$attrHeader]['value'][] = $attrValue;
				} else {
					$dbfArray[$attrHeader]['value'][] = '';
				}
				break;

			case 'N' :
				if (is_numeric($attrValue)) {
					$valArray = explode('.', $attrValue);
					$strlen = strlen($valArray[0]);
					if ($strlen > $dbfArray[$attrHeader]['length']) {
						$dbfArray[$attrHeader]['length'] = $strlen;
					}
			
					if (isset($valArray[1])) {
						$strlen = strlen($valArray[1]);
						if ($strlen > $dbfArray[$attrHeader]['prec']) {
							$dbfArray[$attrHeader]['prec'] = $strlen;
						}
					}
				
					$dbfArray[$attrHeader]['value'][] = $attrValue;
				} else {
					$dbfArray[$attrHeader]['value'][] = '';
				}
				break;

			case 'L' :
				if ($attrValue === true) {
					$dbfArray[$attrHeader]['value'][] = 'T';
				} else if ($attrValue === false) {
					$dbfArray[$attrHeader]['value'][] = 'F';
				} else {
					$dbfArray[$attrHeader]['value'][] = '';
				}
				break;

			default :
				if ($attrValue) {
					$dbfArray[$attrHeader]['value'][] = $attrValue;
				} else {
					$dbfArray[$attrHeader]['value'][] = '';
				}
				break;
		}
	}
}

function createDbfFile($fileName, $dbfArray) {
	$fieldDef = array();
	$attrArray = array();
	$i = 1;

	foreach ($dbfArray as $header => $val) {
		$attrArray[] = $header;
		$attName = $header;
	
		if (strlen($attName) > 10) {
			$attName = substr($attName, 0, 8);
			$attName .= "_$i";
			$i++;
		}

		switch ($val['type']) {
			case 'C' :
				$fieldDef[] = array($attName, 'C', $val['length']);
				break;
	
			case 'N' :
				$fieldDef[] = array($attName, 'N', $val['length'], $val['prec']);
				break;
	
			default :
				$fieldDef[] = array($attName, $val['type']);
				break;
		}
	}

	$dbFile = dbase_create($fileName, $fieldDef);

	$count = count($dbfArray[$attrArray[0]]['value']);
	for ($i = 0; $i < $count; $i++) {
		$dbfVal = array();
		foreach ($attrArray as $att) {
			$dbfVal[] = $dbfArray[$att]['value'][$i];
		}
		dbase_add_record($dbFile, $dbfVal);
	}

	dbase_close($dbFile);
	unset($dbFile);
}

?>