/******************************************************************************
 *
 * Purpose: Export all layer's objects
 * Author:  Julien BONNET, SIRAP
 *
 ******************************************************************************
 *
 * Copyright (c) 2013 SIRAP
 *
 * This file is part of p.mapper.
 *
 * p.mapper is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * p.mapper is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/
$.extend(PM.Plugin,
{
	ExportLayer :
	{
		bCancel: false,
		dlgOptionsExportLayer: {width:400, height:200, left:250, top:250, resizeable:true, newsize:true, container:'pmExportLayerContainer', name:_p('expLayer_title')},

		init: function() {

		},

		cmExportLayer: function(gid) {
			var layerName = gid.replace('ligrp_', '');

			$.ajax({
				url: PM_PLUGIN_LOCATION + '/exportlayer/x_exportLayer2.php',
				type: "POST",
				data: SID + '&action=isExportInProgress',
		        dataType: 'json',
		        success: function(response) {
		        	if (response.bOk) {
		        		if (!response.inProgress) {
		        			$.ajax({
		        				url: PM_PLUGIN_LOCATION + '/exportLayer/x_getDlgExpLayer.php',
		        				type: "POST",
		        				data: SID + '&layer=' + layerName,
		        		        dataType: 'html',
		        		        success: function(response) {
		        		        	PM.Dlg.createDnRDlg(PM.Plugin.ExportLayer.dlgOptionsExportLayer, PM.Plugin.ExportLayer.dlgOptionsExportLayer.name, false);
		        		        	$('#' + PM.Plugin.ExportLayer.dlgOptionsExportLayer.container + '_MSG').html(response);
		        		        	$('#expLayerBtn input[name=cancel]').hide();
		        		        	$('#expLayerBtn div').hide();
		        		        	$('#expLayerResult').hide();
		        		        	PM.Plugin.ExportLayer.setProgressBarValue(0);
		        				},
		        	            error: function (XMLHttpRequest, textStatus, errorThrown) {
		        	                if (window.console) console.log(errorThrown);
		        	            }
		        			});
		        		} else {
		        			alert(_p('expLayer_exportInProgress'));
		        		}
		        	}
				},
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	if (window.console) console.log(errorThrown);
	            }
			});
		},

		exportLayer: function() {
			var layerName;
			var filter = '';
			var count = 0;
			var url;
			var param;
			var timer;

			$('#' +  PM.Plugin.ExportLayer.dlgOptionsExportLayer.container + " " + ".jqmdClose").hide();
			$('#expLayerResult').hide();
			$('#expLayerBtn div').hide();
			$('#expLayerBtn input[name=export]').hide();
			$('#expLayerBtn input[name=cancel]').show();
			PM.Plugin.ExportLayer.setProgressBarValue(0);

			url =  PM_PLUGIN_LOCATION + '/exportlayer/x_exportLayer.php';
			layerName = $('#' + PM.Plugin.ExportLayer.dlgOptionsExportLayer.container + '_MSG input[name=layerName]').val();

			$('#' + PM.Plugin.ExportLayer.dlgOptionsExportLayer.container + '_MSG .checkFiler:checked').each(function() {
				if (filter != '') {
					filter += ',';
				}
				filter += $(this).val();
				count += parseInt($(this).parent().parent().find('.tdCount').text());
			});

			param = SID;
			param += '&layer=' + layerName;
			param += '&filter=' + filter;
			param += '&nbObj=' + count;

			timer = setInterval(function(){
				$.ajax({
					url: PM_PLUGIN_LOCATION + '/exportlayer/x_exportLayer2.php',
					type: "POST",
					data: SID + '&action=getProgress',
			        dataType: 'json',
			        success: function(response) {
			        	if(response.bOk) {
			        		var progress = Math.round(response.progress);
			        		PM.Plugin.ExportLayer.setProgressBarValue(progress);
			        	}
					},
		            error: function (XMLHttpRequest, textStatus, errorThrown) {
		            	if (window.console) console.log(errorThrown);
		            }
				});

			},3000);

			$.ajax({
				url: url,
				type: "POST",
				data: param,
		        dataType: 'json',
		        success: function(response) {
		        	if (response.bOk) {
		        		$('#expLayerResult').html('<a href="' + response.tempFileLocation + '">' + _p('Download') + '</a>').removeClass('expLayerError').addClass('expLayerValid').show();
		        	} else {
		        		var errMsg = _p('expLayer_error');
		        		if (response.err != undefined) {
		        			errMsg = response.err;
		        		}

		        		$('#expLayerResult').text(errMsg).removeClass('expLayerValid').addClass('expLayerError').show();
		        	}
				},
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	var errMsg = _p('expLayer_error');

	            	if (XMLHttpRequest.response) {
	            		var jsonResp = JSON.parse(XMLHttpRequest.response);
	            		if (typeof(jsonResp) != undefined) {
	            			if (typeof(jsonResp.errTimeout) != undefined && jsonResp.errTimeout == true) {
	            				errMsg = _p('expLayer_errTimeout');
	            			} else if (typeof(jsonResp.memorySize) != undefined && jsonResp.memorySize == true) {
	            				errMsg = _p('expLayer_errMemory');
	            			}
	            		}
	            	}

	            	$('#expLayerResult').text(errMsg).removeClass('expLayerValid').addClass('expLayerError').show();

	            	if (window.console) console.log(errorThrown);
	            },
	            complete: function (XMLHttpRequest, textStatus) {
	            	clearInterval(timer);
	            	PM.Plugin.ExportLayer.closeExport();
	            	PM.Plugin.ExportLayer.setProgressBarValue(100);
	            	$('#' +  PM.Plugin.ExportLayer.dlgOptionsExportLayer.container + " " + ".jqmdClose").show();
	        		$('#expLayerBtn input[name=cancel]').hide();
	        		$('#expLayerBtn div').hide();
	        		$('#expLayerBtn input[name=export]').show();
	            }
			});
		},

		cancelExport: function() {
			$.ajax({
				url: PM_PLUGIN_LOCATION + '/exportlayer/x_exportLayer2.php',
				type: "POST",
				data: SID + '&action=cancelExport',
		        dataType: 'json',
		        success: function(response) {
		        	if (response.bOk) {
		        		$('#expLayerBtn input[name=cancel]').hide();
		        		$('#expLayerBtn input[name=export]').hide();
		        		$('#expLayerBtn div').show();
		        	}
				},
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	alert('Cancel Error');
	            	if (window.console) console.log(errorThrown);
	            },
	            complete: function (XMLHttpRequest, textStatus) {

	            }
			});
		},

		setProgressBarValue: function(progressValue) {
			$('#expLayerProgressBar .progress').css('width', progressValue + '%');
			$('#expLayerProgressBar .progressText').text(progressValue + '%');
		},

		closeExport: function() {
			$.ajax({
				url: PM_PLUGIN_LOCATION + '/exportlayer/x_exportLayer2.php',
				type: "POST",
				data: SID + '&action=closeExport',
		        dataType: 'json',
		        success: function(response) {
				},
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	if (window.console) console.log(errorThrown);
	            }
			});
		},

		checkAllFiler: function() {
			if ($('#expLayerCheckAll').is(':checked')) {
				$('#' + this.dlgOptionsExportLayer.container + '_MSG .checkFiler').attr('checked', true);
			} else {
				$('#' + this.dlgOptionsExportLayer.container + '_MSG .checkFiler').attr('checked', false);
			}
		}
	}
});

