<?php
/******************************************************************************
 *
* Purpose: Export all layer's objects
* Author:  Julien BONNET, SIRAP
*
******************************************************************************
*
* Copyright (c) 2013 SIRAP
*
* This is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version. See the COPYING file.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with p.mapper; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
******************************************************************************/

require_once('../../incphp/group.php');
require_once('../../incphp/pmsession.php');
require_once('../../incphp/common.php');
require_once('../../incphp/globals.php');

// prevent XSS
if (isset($_REQUEST['PM_INCPHP'])) exit();

require_once(dirname(__FILE__) . '/../common/groupsAndLayers.php');
require_once(dirname(__FILE__) . '/../common/easyMDB2.inc.php');
require_once('exportLayer.inc.php');

$ret['bOk'] = false;
$bOk = true;
$typeList = array(MS_SHP_POINT, MS_SHP_ARC, MS_SHP_POLYGON);
$tempDir = '';
$fileToZip = array();
$prjDir = $_SESSION['PM_PLUGIN_REALPATH'] . '/export/shp/';
$progress = 0;

// Function to execute when script ending
register_shutdown_function('shutdownFunction');

// init parameters from configuration
$plugConf = isset($_SESSION['pluginsConfig']['exportLayer']) ? $_SESSION['pluginsConfig']['exportLayer'] : array();

$timeLimit = isset($plugConf['timeLimit']) && $plugConf['timeLimit'] ? $plugConf['timeLimit'] : 60;
$nbObjLimit = isset($plugConf['nbObjLimit']) && $plugConf['nbObjLimit'] ? $plugConf['nbObjLimit'] : 150000;

// get request parameters
$layer = isset($_REQUEST['layer']) ? $_REQUEST['layer'] : '';
$nbObj = isset($_REQUEST['nbObj']) ? $_REQUEST['nbObj'] : 0;

if (isset($_SESSION['exportLayer']['exportInProgress']) && $_SESSION['exportLayer']['exportInProgress']) {
	$bOk = false;
	$ret['err'] = _p('expLayer_exportInProgress');
}

if ($bOk && !$layer) {
	$bOk = false;
}

$mslayers = '';
$nbLayer = 0;
if ($bOk) {
	$mslayers = getLayersByGroupOrLayerName($map, $layer);
	$nbLayer = count($mslayers);
	if (!$nbLayer) {
		$bOk = false;
	}
}

if ($bOk) {
	$dateAndTime = date('Y-m-d_H-i-s');
	
	// init session parameters
	if (isset($_SESSION['exportLayer'])) {
		unset($_SESSION['exportLayer']);
	}

	$maxProgressByLayer = 75 / $nbLayer;
	$maxProgressByStep = $maxProgressByLayer / 3;
	$dns = PluginsMapUtils::getDSNConnection($mslayers[0], true);
	$tempDir = $_SESSION['web_imagepath'] . $dateAndTime . '_' . session_id();
	$tempLocation = $_SESSION['web_imageurl'] . $dateAndTime . '_' . session_id();
	$tempDir = str_replace('/', '\\', $tempDir);
	$tempIniFile = "{$tempDir}_exportLayer.ini";
	initIniFile($tempIniFile);
	$_SESSION['exportLayer']['iniFile'] = $tempIniFile;
	$_SESSION['exportLayer']['exportInProgress'] = true;
	
	@mkdir($tempDir, 0700);
	
	// set new timeout (chrono comme back to 0)
	set_time_limit($timeLimit);

	// export each layers
	session_write_close();
	$index = 1;
	foreach ($mslayers as $mslayer) {
		if (isExportCanceled($tempIniFile)) {
			break;
		}
		
		if ($mslayer && ($mslayer->connectiontype == MS_POSTGIS || $mslayer->connectiontype == MS_ORACLESPATIAL)) {
			$attrLst = getAttributsRealAndReadNames($layer);
			$attrString = $attrLst['valuesToUseTxt'];
			
			$dbfArray = false;
			
			$qParam = PluginsMapUtils::getQueryParamsFromDataString($mslayer, false, true);
			$geomFld = $qParam['geomFld'];
			$db_table = $qParam['db_table'];
			$layerType = $mslayer->type;
			$fileName = "$tempDir\\$mslayer->name";
			
			// get attributs types
			if ($attrString) {
				$attrArray = explode(',', $attrString);
				$tableArray = explode('.', $db_table);
				$dbfArray = getAttrType($dns, $tableArray[0], $tableArray[1], $attrArray);
			}
			
			// get prj file if exists
			$proj = $mslayer->getProjection();
			if (empty($proj)){
				$proj = $map->getProjection();
			}
			
			if (!empty($proj)){
				$prjFile = $prjDir;
				$pos = strpos($proj, 'epsg:');
				if ($pos !== false){
					$proj = substr($proj, $pos + 5);
					$prjFile .= "$proj.prj";
				}
				 
				if (file_exists($prjFile) && !is_dir($prjFile)){
					copy($prjFile, "$fileName.prj");
					$fileToZip[] = "$fileName.prj";
				}
			}
			
			if (isExportCanceled($tempIniFile)) {
				break;
			}
			
			// make query
			$query = "SELECT st_astext($geomFld) AS $geomFld, $attrString FROM $db_table WHERE (";
			
			if (isset($qParam['mapLayerFilter'])) {
				$query .= " {$qParam['mapLayerFilter']} AND ";
			}
			$query .= "TRUE) ";
			$query .= "LIMIT $nbObjLimit";
						
			try {
				// execute query
				$pdo = new PDO($dns['dsn'], $dns['user'], $dns['password']);
				$pdo->exec("SET client_encoding = 'WIN1252';");
				$result = $pdo->query($query);
				
				$progress += $maxProgressByStep;
				setProgress($tempIniFile, $progress);
				
				if ($result !== false && !isExportCanceled($tempIniFile)) {
					$result->setFetchMode(PDO::FETCH_ASSOC);
					if ($result->rowCount() != 0) {
						$shpFileObj = ms_newShapeFileObj("$fileName.shp", $typeList[$layerType]);
						$fileToZip[] = "$fileName.shp";
						$fileToZip[] = "$fileName.shx";
						
						while (($row = $result->fetch())) {
							foreach ($row as $header => $value) {
								// if the_geom : add to shape file
								if ($header == $geomFld) {
									$shapObj = ms_shapeObjFromWkt($value);
									$shpFileObj->addShape($shapObj);
									$shapObj->free();
								// else add to attribut list
								} else if ($dbfArray !== false) {
									addAttDbf($dbfArray, $header, $value);
								}
							}
						}
						
						$shpFileObj->free();
						unset($shpFileObj);
						
						$progress += $maxProgressByStep;
						setProgress($tempIniFile, $progress);
						
						// create dbf file
						if ($dbfArray !== false && !isExportCanceled($tempIniFile)) {
							createDbfFile("$fileName.dbf", $dbfArray);
							$fileToZip[] = "$fileName.dbf";
						}
						
						$progress += $maxProgressByStep;
						setProgress($tempIniFile, $progress);
					}
				}
				
			} catch (PDOException $e) {
				$bOk = false;
				break;
			}
			
		}
		
		$progress = $index * $maxProgressByLayer;
		setProgress($tempIniFile, $progress);
		$index++;
	}
}

if ($bOk && !isExportCanceled($tempIniFile)) {
	// zip all files
	if (isset($fileToZip[0])) {
		$zipFilePath = "$tempDir.zip";
		PMCommon::packFilesZip($zipFilePath, $fileToZip, true, false);
		$ret['tempFileLocation'] = "$tempLocation.zip";
		$ret['bOk'] = true;
	}
}

// delete temporary files
foreach ($fileToZip as $file) {
	if (file_exists($file))	{
		unlink($file);
	}
}
if ($tempDir && file_exists($tempDir)) {
	rmdir($tempDir);
}

$progress = 100;
setProgress($tempIniFile, $progress);

if (isExportCanceled($tempIniFile)) {
	$ret['bOk'] = false;
	$ret['err'] = _p('expLayer_exportCanceled');
}

$retStr = json_encode($ret);

header("Content-Type: text/plain; charset=$defCharset");
echo $retStr;
?>