/******************************************************************************
 *
 * Purpose: Draw points and export coordinates
 * Author:  Christophe ARIOLI, SIRAP
 *
 ******************************************************************************
 *
 * Copyright (c) 2011 SIRAP
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/

var exportPointsPlugin = $.extend({}, drawingBase,
{
	// Dialog options
	dlgOptions: {width:465, height:250, left:50, top:100, resizeable:true, newsize:true, container:'pmExportPointsContainer', name:'ExportPoints'},
	dlgType: 'dynwin',
	default_color: '#1AC7F2', // default drawing color
	default_outlineColor: '#595959', // default outline color
	// shape draw and label default properties
	point: {draw:{defaultSymbol:'circle', defaultThickness:10}, label:{defaultFont:'FreeSans', defaultTextSize:10}},

	// layers definition
	layer_def_point: '{"type":"tplMapFile", "tplname": "drawPoint", "layername": "PointsToExport", "category": "cat_exportPoints"}',

	current_properties: [], // array of shape properties

	pluginNameSrv: 'exportPoints', // pluginName for init function
	pluginNameClt: 'ExportPoints', // pluginName for init function

	helpMsg: 'exportPoints_help',

	wgs84Proj: 'init=epsg:4326',
	mapProj: this.wgs84Proj,
	
	mapUnit: 3,
	roundTo: 1000,
	
	init: function() {
		this.init_base(); // init parameters of common drawing class

		this.tableContentId = this.pluginNameSrv + "TableContent"; // HTML table content name for the plugin exportPoints
		this.emptyButtonId = this.pluginNameSrv + "Empty"; // empty button name for the plugin exportPoints
		this.importButtonId = this.pluginNameSrv + "_ImportFile"; // import button name for the plugin exportPoints
		this.exportButtonId = this.pluginNameSrv + "_ExportResult"; // export div name for the plugin exportPoints
		this.downloadButtonId = this.pluginNameSrv + "_GenerateFile"; // export button name for the plugin exportPoints
		this.exportProjId = this.pluginNameSrv + "_ExportProj"; // export button name for the plugin exportPoints
		this.exportProjComboId = this.pluginNameSrv + "_ComboExportProj"; // combo to choose target projection for the plugin exportPoints
		this.downloadLinkId = this.pluginNameSrv + "_LinkFile";

		// load config settings from config_XXXXX.xml file
		if (typeof(PM.ini.pluginsConfig[this.pluginNameSrv]) != 'undefined') {
			var pluginsConfig = PM.ini.pluginsConfig[this.pluginNameSrv];
			if (typeof(pluginsConfig.dlgType) != "undefined") {
				this.dlgType = pluginsConfig.dlgType;
			}
			if (typeof(pluginsConfig.default_color) != "undefined") {
				this.default_color = pluginsConfig.default_color;
				this.color = this.default_color;
			}
			if (typeof(pluginsConfig.default_outlineColor) != "undefined") {
				this.default_outLineColor = pluginsConfig.default_outlineColor;
				this.outLineColor = this.default_outLineColor;
			}
			if (typeof(pluginsConfig.point) != "undefined") {
				this.point = pluginsConfig.point;
			}
		}
	},
	

	/**
	 * Create box dialog when the user click on the drawing plugin in toolbar
	 */
	openDlg: function() {
		//$('#helpMessage').html(_p('drawing_help')).show();

		if ($('#' + this.tableContentId).length == 0) {
			// Create dynamic window
			PM.Dlg.createDnRDlg(this.dlgOptions, _p('ExportPoints'), false, 'PM.Plugin.' + this.pluginNameClt + '.onTop');

    		// window contents

    	    // content table
    	    var htmltableContent = '<table id="' + this.tableContentId + '" class="drawingTableContent">';
    	    htmltableContent += '<tr><th>' + _p('Comment') + '</th><th>X</th><th>Y</th>';

    	    htmltableContent += '<th>'+ _p('Delete') + '</th>';
    	    htmltableContent += '</tr></table>';
    	    htmltableContent += '<div id="' + this.emptyButtonId + '"><input type="button" value="'+ _p('Empty') + '" onClick="javascript:PM.Plugin.' + this.pluginNameClt + '.clearObjectsTab()"></input></div>';

    	    // upload, download
    	    var htmltableBottom = this.getHtmlTableBottom();

    	    $('#' + this.dlgOptions.container + '_MSG').html(htmltableContent + htmltableBottom);

    	    // target proj comboBox
    	    this.setHtmlProjCombo();

    	    // hide elements
            $('#' + this.importButtonId).hide();
    		$('#' + this.downloadLinkId).hide();

    		this.updateTab();
		} else {
			this.redrawPoly();
		}

		$('#' + this.dlgOptions.container).show().trigger('click');

		this.drawTypeObj = 'point',
	    this.setType(this.drawTypeObj);

		this.updateSpecialButtons();
	},
	

	getHtmlTableBottom: function() {
		 var htmltableBottom = '';
		 htmltableBottom += '<hr>';
		 htmltableBottom += '<div id="' + this.importButtonId + '">';
		 htmltableBottom += '<label for="fileToUpload">' + _p('Import a file') + ' :</label><input type="file" name="fileToUpload" id="fileToUpload" onchange="PM.Plugin.' + this.pluginNameClt + '.ajaxFileUpload()" />';
		 htmltableBottom += '<img id="progressUpload" src="images/indicator.gif" style="display:none;" />';
		 htmltableBottom += '</div>';
		 htmltableBottom += '<div id="' + this.exportButtonId + '">';

		 // target proj comboBox
		 htmltableBottom += '<div id="' + this.exportProjId + '"></div>';
		 htmltableBottom += '<div id="' + this.downloadButtonId + '"><label for="exportPoints_save">' + _p('Export result') + ' :</label><input type="button" name="exportPoints_save" value="'+ _p('Save') + '" onClick="javascript:PM.Plugin.' + this.pluginNameClt + '.exportPoints_saveFile()"></input></div>';
		 htmltableBottom += '<div id="' + this.downloadLinkId + '"></div>';
		 htmltableBottom += '</div>';

		 return htmltableBottom;
	},
	

	/**
	 * get combobox to select target projection to exported points
	 * parameters: void
	 * @return: void
	 */
	setHtmlProjCombo: function() {
		var htmlProjCombo = "" ;
		var url = PM_PLUGIN_LOCATION + '/exportPoints/x_getProjList.php';
		var params = SID;

		$.ajax({
			url: url,
			data: params,
			type: "POST",
			dataType: "json",
			callingPluginName: this.pluginNameClt,
			success: function(response) {
				var pluginObject = getPMPluginObjFromString(this.callingPluginName);
				if (pluginObject) {
					var mapProj = response.mapProj;
					var prjJsonList = response.prjJson;
					var mapUnit = response.mapUnit;
					var htmlProjCombo = _p('exportPoints_targetProj') + " : " + "<select id='" + pluginObject.exportProjComboId + "'>";

					$.each(prjJsonList, function(i, p) {
						var select = "";
						if(mapProj.toUpperCase() == p.prjDef.toUpperCase()) {
							select = " selected";
						}
						htmlProjCombo += "<option value='" + p.prjDef + "'" + select + ">" + p.prjName + "</option>";
					});
					htmlProjCombo += "</select>";
					$('#exportPoints_ExportProj').html(htmlProjCombo);

					var pluginObject = getPMPluginObjFromString(this.callingPluginName);
	    	    	if (pluginObject) {
						var idsToHide = [pluginObject.importButtonId, pluginObject.downloadLinkId];
						$('#' + pluginObject.exportProjComboId).bind('change', {'idsToHide': idsToHide}, function(e) {
							$.each(e.data.idsToHide, function(i, val) {
								$('#' + val).hide();
							});
						});
						pluginObject.mapProj = mapProj;
						var unit = parseInt(mapUnit);
						pluginObject.mapUnit = unit;
						switch(unit) {
							case 3:
								pluginObject.roundTo = 1000;
								break;
							case 4:
								pluginObject.roundTo = 1000000;
								break;
							default:
								pluginObject.roundTo = 1;
						}
	    	    	}
				}
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				if (window.console) console.log(errorThrown);
			}
		});
	},
	

	/**
	 * Display empty button
	 */
	afterDrawSymbols: function(clickX, clickY, dblClick) {
		// Don't go outside map
		if ((clickX < PM.mapW) && (clickY < PM.mapH)) {
			this.updateSpecialButtons();
		}
	},
	

	/**
	 * Get layer definition
	 * parameters: type (type of object : point,line ...)
	 * @return: ret (a json string)
	 */
	getLayerDef: function(type) {
		return this.layer_def_point;
	},
	

	/**
	 * Add an object to the HTML table.
	 * parameters: drawNbObjet(object's index), type(object's type), properties(object's properties)
	 * @return: void
	 */
	addObjToTab_extend: function(drawNbObjet, type) {
		var txt = this.current_properties["comment"];
		var coordinates = eval(this.tabObjects[drawNbObjet]["coordinates"]);
		var xMap = coordinates[0];
		var yMap = coordinates[1];
		if(this.mapProj.toUpperCase() != this.wgs84Proj.toUpperCase()) {
			xMap = Math.round(xMap*this.roundTo)/this.roundTo;
			yMap = Math.round(yMap*this.roundTo)/this.roundTo;
		}
		
		var htmlstr = "<tr><td>"  + txt + "</td><td>" + xMap + "</td><td>" + yMap + "</td>";
		htmlstr += "<td><a href='javascript:PM.Plugin." + this.pluginNameClt + ".deleteObj(" + (drawNbObjet) + ")'><img alt='" + _p('Delete') + "' title='" + _p('Delete') + "' width='20' height='20' src='" + PM_PLUGIN_LOCATION + "/drawing_base/images/delete.gif'/></a></td>";
		htmlstr += "</tr>";
		$("#" + this.tableContentId).append(htmlstr);
	},
	

	drawSymbols: function(clickX, clickY, dblClick) {
		if (this.drawTypeObj == null || this.drawTypeObj == "undefined"){
			return;
		}

		// Don't go outside map
		if ((clickX < PM.mapW) && (clickY < PM.mapH)) {

			var drawNbObjet = this.tabObjects.length;
			var pointPx = new Point(clickX,clickY); // Create a Point object(px coordinates)
			var pointGeo = PM.Draw.toGeoPoint(pointPx); // Return a Point object with geo coordinates

			this.initColors(); // fix user's color, outlineColor choice

			if (this.drawTypeObj == 'point') {
				PM.Draw.drawLineSegment(jg,new Line(pointPx, pointPx));

			}
			var txt = this.insertTxt(pointPx); // insert annotation
			var properties = this.initObjProperties(txt, pointGeo.x, pointGeo.y);
			var data = this.addObject(this.drawTypeObj, '[' + pointGeo.toString(',') + ']', properties);
			this.sendLayerToServer(this.drawTypeObj, data);

			this.addObjToTab(drawNbObjet, this.drawTypeObj);
		}

		if (this.afterDrawSymbols) {
			this.afterDrawSymbols(clickX, clickY, dblClick);
		}
	},
	

	/**
	 * Display empty button
	 */
	afterDrawSymbols: function(clickX, clickY, dblClick) {
		// Don't go outside map
		if ((clickX < PM.mapW) && (clickY < PM.mapH)) {
			//$('#' + this.downloadLinkId + ' a').attr("href", "#").parent().hide();
			$('#' + this.downloadLinkId).hide();
			this.updateSpecialButtons();
		}
	},
	

	/**

	 * initialize object's properties
	 * @param: txt(text grabbed by user)
	 * @return: properties(array of properties)
	 */
	initObjProperties: function(txt, pxMap, pyMap) {
		var pluginProperties = [];

		if (this.initCurrentProperties) {
			pluginProperties = this.initCurrentProperties(txt);
		}

		return pluginProperties;
	},
	

	/**
	 * Initialize array of object's properties
	 */
	initCurrentProperties: function(txt) {
		this.current_properties = ["index", "comment", "symbolThickness", "color", "outLineColor", "colorHex", "outLineHex",
			               			"textSize", "fontFamily", "symbolShape"];
		
		this.current_properties["index"] = this.tabObjects.length;
		this.current_properties["comment"] = txt;
		this.current_properties["symbolThickness"] = this[this.drawTypeObj].draw.defaultThickness;
		this.current_properties["color"] = convertHexToRGB(this.color);
		this.current_properties["outLineColor"] = convertHexToRGB(this.outLineColor);
		this.current_properties["colorHex"] = this.color;
		this.current_properties["outLineHex"] = this.outLineColor;
		this.current_properties["textSize"] = this[this.drawTypeObj].label.defaultTextSize;
		this.current_properties["fontFamily"] = this[this.drawTypeObj].label.defaultFont;
		this.current_properties["symbolShape"] = this[this.drawTypeObj].draw.defaultSymbol;

		return this.current_properties;
	},
	

	sendLayers: function(type, data) {
		this.sendLayerToServer(type, data);
	},
	

	/**
	 * Layers to remove for the plugin drawing
	 */
	getLayersToRemove: function(data) {
		var drawLayer = '';
		var drawLayerPoint = this.createLayersString(this.layer_def_point, data);
		drawLayer = '[' + drawLayerPoint + ']';
		return drawLayer;
	},
	

	/**
	 * Update html table
	 * after an action like deleting an object, close and re-open box dialog, clear all objects ...
	 */
	updateTab_extend: function() {
		for (var iObj = 0 ; iObj < this.tabObjects.length ; iObj++) {
			var typeObj = this.tabObjects[iObj]["type"];
			var properties = this.tabObjects[iObj]["properties"];
			this.current_properties = properties;
			this.addObjToTab(iObj, typeObj);
		}
		this.redrawPoly();

		//$('#' + this.downloadLinkId + ' a').attr('href','#').parent().hide();
		$('#' + this.downloadLinkId).hide();
		this.updateSpecialButtons();
	},
	

	updateSpecialButtons: function() {
		this._exportPoints_updateSpecialButtons();
	},
	

	_exportPoints_updateSpecialButtons: function() {
		if (this.tabObjects.length == 0) {
			$('#' + this.emptyButtonId).hide();
			//$('#' + this.importButtonId).hide();
			$('#' + this.exportProjId).hide();
			$('#' + this.downloadButtonId).hide();
		} else {
			$('#' + this.emptyButtonId).show();
			//$('#' + this.importButtonId).show()
			$('#' + this.exportProjId).show();
			$('#' + this.downloadButtonId).show();
		}
	},
	

	/**
	 * function used to close box dialog
	 * @return: void
	 */
	drawCloseWindow: function() {
		$('#' + this.dlgPropertiesOptions.container).hide();
	},
	

	/**

	 * Save points in txt file.

	 * parameters: void
	 * @return: void
	 */
	exportPoints_saveFile: function() {
		$('#progressUpload').show();
		$('#' + this.downloadLinkId).hide();

		var url = PM_PLUGIN_LOCATION + '/exportPoints/x_pointsExport.php';
		
		var data = this.exportPointsGenerateData();
		var comboSelctedProj = $('#' + this.exportProjComboId).val();
		var params = SID + '&data=' + data + '&targetProj=' + comboSelctedProj;

		$.ajax({
			url: url,
			data: params,
			type: "POST",
			dataType: "json",
			callingPluginName: this.pluginNameClt,
			success: function(response) {
				var pluginObject = getPMPluginObjFromString(this.callingPluginName);
				if (pluginObject) {
					$('#' + pluginObject.downloadLinkId).html('<a href="' + response.expFileLocation + '" target="_blank">' + _p('Download')+ '</a>').show();
				}
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				if (window.console) console.log(errorThrown);
			},
			complete: function() {
				$('#progressUpload').hide();
			}
		});
	},
	

	exportPointsGenerateData: function() {
		var data;
		data = this.generateJson('point');
		var drawLayerPoint = this.createLayersString(this.layer_def_point, data);
		drawLayerPoint = this.checkGeometry(drawLayerPoint);
		return drawLayerPoint;
	}
});

$.extend(PM.Plugin, {ExportPoints: exportPointsPlugin});

$.extend(PM.Map,
{
	/**
     * custom sample script for extending tool functions
     * called from map.js/domouseclick()
     * must be named '*_click()'
     */
	exportPoints_click: function() {
		PM.Map.mode = PM.Plugin.ExportPoints.pluginNameSrv;
		PM.Map.maction = PM.Plugin.ExportPoints.pluginNameSrv;
		PM.Map.tool = PM.Plugin.ExportPoints.pluginNameSrv;

        // define the cursor
        if (PM.useCustomCursor) {
            PM.setCursor(false, 'crosshair');
        }
        PM.Plugin.ExportPoints.openDlg();
	},

	/**
     * SIMPLE CLICK event in main map
     * start drawing point, line, polygon ...
     * called from map.js/zoombox_apply()
     * must be named '*_start(imgxy)'
     */
	exportPoints_start: function(imgxy) {
		var pixccoords = imgxy.split('+');
	    var pixX = pixccoords[0];
		var pixY = pixccoords[1];

		PM.Plugin.ExportPoints.drawSymbols(pixX, pixY, false);
	}
});