<?php

/******************************************************************************
 *
 * Purpose:
 * Author:  Christophe Arioli, SIRAP
 *
 *****************************************************************************
 *
 * Copyright (c) 2011 SIRAP
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * p.mapper is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/

// prevent XSS
if (isset($_REQUEST['PM_INCPHP'])) exit();

require_once('../../incphp/pmsession.php');

require_once('../../incphp/globals.php');

// get points
$data = $_REQUEST['data'];
$data = str_replace(array("\\'", '\\"', '\\\\"', "\r", "\n", "\t"), array("'", '"', '\\"', '', '', ''), $data);

//set round value
$roundTo = 3;
switch ($map->units) {
    case 3: // m
        $roundTo = 3;
        break;
    case 4: // km
        $roundTo = 6;
        break;
    default: // other
    	$roundTo = 9;
        break;
}

$dateAndTime = date('Y-m-d_H-i-s');

$fileNameTmp = _p('ExportPoints') . '_' . $dateAndTime;
$fileName =  "$fileNameTmp.txt"; // for instance: ExportPoints_31-12-2008_09-02-17.txt
$expFilePath = $_SESSION['web_imagepath'] . $fileName;
$iterator = 1;
while (file_exists($expFilePath)) {
	$iterator++;
	$fileName = "$fileNameTmp_$iterator.txt";
}

$expFilePath = $_SESSION['web_imagepath'] . $fileName;
if (!file_exists($expFilePath)) {
    $fh = @fopen($expFilePath, 'w');
	if ($fh) {

		// write title
		$title = utf8_decode($_SESSION['pmTitle']);
		$tmp = fwrite($fh, "## $title\r\n");
		
		// variables used to convert points coordinates to target projection
		$mapProjection = $map->getProjection();
		$mapProjection = preg_replace('/^\+/', '', $mapProjection);
		$targetProjection = isset($_REQUEST['targetProj']) ? $_REQUEST['targetProj'] : $mapProjection;
		$convertCoord = strcasecmp($targetProjection, $mapProjection);

		// write map unit
		$mapUnitDescription = utf8_decode('## ' . _p('exportPoints_dosUnit'). ' : ' . _p('unitAndProj__' . $map->units));
		$tmp = fwrite($fh, "$mapUnitDescription\r\n");

		// write map and target projections informations
		$mapProjectionDescription = _p('exportPoints_projNotdef') . " ($mapProjection)";
		$targetProjectionDescription = _p('exportPoints_projNotdef') . " ($targetProjection)";
		if (isset($_SESSION['pluginsConfig']['exportPoints'])
		&& isset($_SESSION['pluginsConfig']['exportPoints']['projections'])
		&& isset($_SESSION['pluginsConfig']['exportPoints']['projections']['prj'])) {
			$prjList = $_SESSION['pluginsConfig']['exportPoints']['projections']['prj'];
			if ($prjList) {
				$mapProjFound = false;
				$targetProjFound = !$convertCoord;
				foreach ($prjList as $p) {
					if (!$mapProjFound && isset($p['definition']) && strcasecmp($p['definition'], $mapProjection) == 0) {
						$mapProjectionDescription = isset($p['name']) ? $p['name'] . ' (' . $p['definition'] . ')' : $p['definition'];
						$mapProjFound = true;
					}
					if (!$targetProjFound && isset($p['definition']) && strcasecmp($p['definition'], $targetProjection) == 0) {
						$targetProjectionDescription = isset($p['name']) ? $p['name'] . ' (' . $p['definition'] . ')' : $p['definition'];
						$targetProjFound = true;
					}
					if ($mapProjFound && $targetProjFound) {
						break;
					}
				}
			}
		}
		$tmp = fwrite($fh, '## ' . utf8_decode(_p('exportPoints_dosProj') . " : $mapProjectionDescription") . "\r\n");
		if ($convertCoord) {
			$tmp = fwrite($fh, '## ' . utf8_decode(_p('exportPoints_targetProj') . " : $targetProjectionDescription") . "\r\n");
		}

		// write points
		$decodeData = json_decode($data);
		$pointArray = $decodeData->data->features;

		$tmp = fwrite($fh, "index\tcomment\tX\tY\r\n");
		
		$fromPrjObj = false;
		$toPrjObj = false;
		if ($mapProjection && $targetProjection && $mapProjection != $targetProjection) {
    		if ($_SESSION['MS_VERSION'] >= 6) {
    			$fromPrjObj = new projectionObj($mapProjection);
    			$toPrjObj = new projectionObj($targetProjection);
    		} else {
    			$fromPrjObj = ms_newprojectionobj($mapProjection);
    			$toPrjObj = ms_newprojectionobj($targetProjection);
    		}
		}
		
		foreach ($pointArray as $f) {
			$coordinates = $f->geometry->coordinates;
			$x =  $coordinates[0];
			$y =  $coordinates[1];

			if ($convertCoord) {
				$poPoint = ms_newpointobj();
				$poPoint->setXY($x, $y);
				if ($fromPrjObj && $toPrjObj) {
					$poPoint->project($fromPrjObj, $toPrjObj);
				}
				$x = $poPoint->x;
				$y = $poPoint->y;
			}

			// 4326 = lat/lon WGS84 -> not use round() function to keep maximum precision
			if (!preg_match('/init=epsg:4326$/i', $targetProjection)) {
				$x = round($x, $roundTo);
				$y = round($y, $roundTo);
			}

			$properties = $f->properties;
			$index = strval($properties->index);
			$comment = utf8_decode($properties->comment);

			$tmp = fwrite($fh, "$index\t$comment\t$x\t$y\r\n");
		}
	}
	fclose($fh);
}

$expFileLocation = $_SESSION['web_imageurl'] . $fileName;

$defCharset = $_SESSION['defCharset'];
header("Content-type: text/plain; charset=$defCharset");
echo "{\"expFileLocation\":\"$expFileLocation\"}";
?>