<?php

// Conversion de couleur HSV => RGB
// Code from http://www.easyrgb.com/index.php
function color_hsv2rgb($H, $S, $V) {
	$R = 0; 
	$G = 0;
	$B = 0;
	
	if ($S == 0) {                       //HSV from 0 to 1
		$R = $V * 255;
		$G = $V * 255;
		$B = $V * 255;
	} else {
		$var_h = $H * 6;
		//H must be < 1
		if ($var_h == 6) {
			$var_h = 0 ;     
		}
		$var_i = floor($var_h);             //Or ... var_i = floor( var_h )
		$var_1 = $V * (1 - $S);
		$var_2 = $V * (1 - $S * ($var_h - $var_i));
		$var_3 = $V * (1 - $S * (1 - ($var_h - $var_i)));
	
		if ($var_i == 0) { 
			$var_r = $V; 
			$var_g = $var_3; 
			$var_b = $var_1; 
		} else if ($var_i == 1) { 
			$var_r = $var_2; 
			$var_g = $V; 
			$var_b = $var_1; 
		} else if ($var_i == 2) { 
			$var_r = $var_1; 
			$var_g = $V; 
			$var_b = $var_3; 
		} else if ($var_i == 3) { 
			$var_r = $var_1; 
			$var_g = $var_2;
			$var_b = $V;     
		} else if ($var_i == 4) { 
			$var_r = $var_3; 
			$var_g = $var_1; 
			$var_b = $V;     
		} else {
			$var_r = $V; 
			$var_g = $var_1; 
			$var_b = $var_2;
		}
	
		$R = floor($var_r * 255);                  //RGB results from 0 to 255
		$G = floor($var_g * 255);
		$B = floor($var_b * 255);
	}
	
	$ret['R'] = $R;
	$ret['G'] = $G;
	$ret['B'] = $B;
	return $ret;
}

// Conversion de couleur RGB => HSV
// Code from http://www.easyrgb.com/index.php
function color_rgb2hsv($R, $G, $B) {
	$H = 0;
	$S = 0;
	$V = 0;
	
	$var_R = ($R / 255);                    //RGB from 0 to 255
	$var_G = ($G / 255);
	$var_B = ($B / 255);
	
	$var_Min = min($var_R, $var_G, $var_B);    //Min. value of RGB
	$var_Max = max($var_R, $var_G, $var_B);    //Max. value of RGB
	$del_Max = $var_Max - $var_Min;             //Delta RGB value
	
	$V = $var_Max;
	
	if ($del_Max == 0) {                     //This is a gray, no chroma...
		$H = 0;                                //HSV results from 0 to 1
		$S = 0;
	} else {                                    //Chromatic data...
		$S = $del_Max / $var_Max;
	
		$del_R = ((($var_Max - $var_R) / 6 ) + ($del_Max / 2 ) ) / $del_Max;
		$del_G = ((($var_Max - $var_G) / 6 ) + ($del_Max / 2 ) ) / $del_Max;
		$del_B = ((($var_Max - $var_B) / 6 ) + ($del_Max / 2 ) ) / $del_Max;
	
		if ($var_R == $var_Max ) {
			$H = $del_B - $del_G;
		} else if ( $var_G == $var_Max ) {
			$H = ( 1 / 3 ) + $del_R - $del_B;
		}
		else if ($var_B == $var_Max) {
			$H = ( 2 / 3 ) + $del_G - $del_R;
		}
	
		if ($H < 0) {
			$H += 1;
		}
		if ($H > 1) {
			$H -= 1;
		}
	}
	
	$ret["h"] = $H;
	$ret["s"] = $S;
	$ret["v"] = $V;
	
	return $ret;
}

function getNewColor($existingRgbColorArray) {
	$hue = 0;
	
	if ($existingRgbColorArray) {
		$hueArray = array(0, 101);
		$minHue = 0;
		$maxHue = 100;
		foreach ($existingRgbColorArray as $existingColor) {
			$hsv = color_rgb2hsv($existingColor['R'], $existingColor['G'], $existingColor['B']);
			$hueArray[] = floor($hsv['h'] * 100);
		}
	
		sort($hueArray);
		$nbHue = count($hueArray);
		$maxIntersect = 0;
		for ($i = 1; $i < $nbHue; $i++) {
			$intersect = $hueArray[$i] - $hueArray[$i - 1];
			if ($intersect > $maxIntersect) {
				$maxIntersect = $intersect;
				$minHue =  $hueArray[$i - 1];
				$maxHue = $hueArray[$i];
			}
		}
	
		$hue = floor(($minHue + $maxHue) / 2) / 100;
	}
	// Select bright color with the new hue
	$rgbColor = color_hsv2rgb($hue, 1, 1);
	
	return $rgbColor;
}

?>