/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["extensions.VisibleLayers.RemoveLayerControl"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["extensions.VisibleLayers.RemoveLayerControl"] = true;
dojo.require("GeoMOOSE.Tab.Catalog.LayerControl");
dojo.provide("extensions.VisibleLayers.RemoveLayerControl");

dojo.declare("extensions.VisibleLayers.RemoveLayerControl", [GeoMOOSE.Tab.Catalog.LayerControl], {
	classes: ['sprite-control-fade'],

	tip: '"Remove ${layer} from the Visible Layers List."',

	draw: function(parent) {
		this.inherited(arguments);

		var control = dojo.byId(this.control_id);
		dojo.style(control, {
			'backgroundImage' : 'url("images/close.png")',
			'backgroundPosition' : 'bottom left'
		});
	},

	onClick: function() {
		GeoMOOSE.turnLayerOff(this.layer.pathsAsArray());
		dojo.publish('visible-layers-remove', [this.layer.src]);
	}
});

CONFIGURATION.layer_controls['remove-layer'] = {'on' : false};
CONFIGURATION.layer_control_order.unshift('remove-layer');

GeoMOOSE._registerLayerControl('remove-layer', extensions.VisibleLayers.RemoveLayerControl);


}
