<?php

/******************************************************************************
 *
 * Purpose: Initializes basic configuration settings and writes 
 *          settings to PHP session. 
 * Author:  Armin Burger
 *
 ******************************************************************************
 *
 * Copyright (c) 2003-2011 Armin Burger
 *
 * This file is part of p.mapper.
 *
 * p.mapper is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * p.mapper is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/


/************************************************************************
   
   !!! THIS FILE IS *NOT* A CONFIG FILE FOR CUSTOMIZATION !!!
   !!! DO NOT EDIT THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING !!!
   
 ************************************************************************/

/**
 * Check for register_globals set to On
 */
if (ini_get('register_globals')) {
    echo "!!! 'register_globals' is enabled in your php.ini. This is a severe security leak!!!";
    exit();
}


/**
 * Config settings
 */
// Check if config is set via URL
if (isset($_REQUEST['config'])) {
    // Check for invalid GET variables
    if (preg_match("/\/|\./", $_REQUEST['config'])) exit();
    $config = trim($_REQUEST['config']);
} elseif (isset($_SESSION['config'])) {
    $config = $_SESSION['config'];
} elseif (isset($config)) {
    $config = $config;
} else {
    $config = "default";
}

// Read and merge config 
$PM_BASECONFIG_DIR = str_replace('\\', '/', dirname(__FILE__));

// use "default" config if the specified one doesn't exists
$configfile = "$PM_BASECONFIG_DIR/config_$config.xml";
if (!file_exists($configfile)) {
    $config = 'default';
}

require_once($PM_BASECONFIG_DIR . "/common/._startup_/.startup.php");
$startUp = new StartUp($config, $PM_BASECONFIG_DIR);
$ini = $startUp->getIni();
//print_r($ini);


/**
 * Reset SESSION if requested
 */
if (isset($_GET["resetsession"]))  {
    $resetsession = $_GET["resetsession"];
} elseif (isset($ini['config']['pm_resetsession'])) {
    $resetsession = $ini['config']['pm_resetsession'];
} else {
    $resetsession = False;
}
    
if ($resetsession) {
    if (strtoupper(trim($resetsession)=="ALL")) {
		$_SESSION = array();		
	} else {
        $resetList = explode(',', $resetsession);
        foreach ($resetList as $var) {
            $_SESSION["$var"] = null;
		}
    }
    $_SESSION["session_alive"] = 1;
}


if (isset($ini['config']['pm_config_location'])) {
    $PM_CONFIG_LOCATION  = $ini['config']['pm_config_location'];
} else {
    $PM_CONFIG_LOCATION  = "default";
}


if (isset($ini['config']['pm_config_location_common'])) {
    $PM_CONFIG_LOCATION_COMMON  = $ini['config']['pm_config_location_common'];
} else {
    $PM_CONFIG_LOCATION_COMMON  = "common";
}

$PM_CONFIG_DIR = str_replace('\\', '/', realpath($PM_BASECONFIG_DIR . "/" . $PM_CONFIG_LOCATION));
$PM_JS_CONFIG  = $PM_CONFIG_LOCATION . "/" . "js_config.php";
$PM_BASE_DIR   = str_replace('\\', '/', realpath($PM_BASECONFIG_DIR . "/../"));


/**
 * MapServer version 
 */
if (isset($ini['pmapper']['msVersion'])) {
    $msVersion = "_" . $ini['pmapper']['msVersion'];
} else {
    $msVersion = "";
}



/**
 * Map file
 */
$mapFileIni = trim($ini['map']['mapFile']);
// try as absolute path
if ($mapFileIni{0} == "/" || $mapFileIni{1} == ":") {
    $PM_MAP_FILE = str_replace('\\', '/', $mapFileIni);
// else as relative to $PM_CONFIG_DIR
} else {
    $PM_MAP_FILE = str_replace('\\', '/', realpath($PM_BASECONFIG_DIR . "/" . $mapFileIni));
    if (!file_exists($PM_MAP_FILE)) {
        $PM_MAP_FILE = str_replace('\\', '/', realpath($PM_CONFIG_DIR . "/" . $mapFileIni));
    }
}

if (!file_exists($PM_MAP_FILE)) {
    error_log ("P.MAPPER-ERROR: Cannot find map file '$mapFileIni'. Check 'config.ini' file at section 'mapFile'.", 0);
    exit();
}


/**
 * INITIALIZE MAP
 */
/*
if (!extension_loaded('MapScript')) {
    dl("php_mapscript$msVersion." . PHP_SHLIB_SUFFIX);
}
$map = ms_newMapObj($PM_MAP_FILE);
$web_imagepath = str_replace('\\', '/', $map->web->imagepath);
$mapTmpFile = $web_imagepath . session_id() . ".map";
$map->save($mapTmpFile);
*/



/**
 * Map file for query result highlighting
 */
if (isset($ini['map']['tplMapFile'])) { 
    $tplMapFileIni = trim($ini['map']['tplMapFile']);
    // try as absolute path
    if ($tplMapFileIni{0} == "/" || $tplMapFileIni{1} == ":") {
        $PM_TPL_MAP_FILE = str_replace('\\', '/', $tplMapFileIni);
    // else as relative to $PM_CONFIG_DIR
    } else {
        $PM_TPL_MAP_FILE = str_replace('\\', '/', realpath($PM_BASECONFIG_DIR . "/" . $tplMapFileIni));  
    }
    if (!file_exists($PM_TPL_MAP_FILE)) {
        error_log ("P.MAPPER-ERROR: Cannot find map file '$tplMapFileIni'. Check 'config.ini' file at section 'hlMapFile'.", 0);
        exit();
    }
} else {
    $PM_TPL_MAP_FILE = 0;
}

/**
 * Set character set for correct display of special characters
 */
if (isset($ini['locale']['defaultCharset'])) {
    $defCharset = $ini['locale']['defaultCharset'];
} else {
    $defCharset = "UTF-8";
}


/**
 * WEB location INCPHP 
 */
if (isset($ini['config']['pm_incphp_location'])) {
    $PM_INCPHP_LOCATION  = trim($ini['config']['pm_incphp_location']);
    $PM_INCPHP = str_replace('\\', '/', realpath(dirname(__FILE__) . "/../" . $PM_INCPHP_LOCATION));
    if (!$PM_INCPHP) {
        error_log("P.MAPPER-ERROR: location '$PM_INCPHP_LOCATION' not existing. Check config at section 'pm_incphp_location'");
        exit();
    }
} else {
    $PM_INCPHP_LOCATION = "incphp";
    $PM_INCPHP = str_replace('\\', '/', realpath(dirname(__FILE__) . "/../incphp"));
} 


/**
 * Directory location XAJAX 
 */
$PM_XAJAX_LOCATION = $PM_INCPHP_LOCATION . "/xajax/";



/**
 * Directory JAVASCRIPT 
 */
if (isset($ini['config']['pm_javascript_location'])) {
    $PM_JAVASCRIPT  = trim($ini['config']['pm_javascript_location']);
} else {
    $PM_JAVASCRIPT = "javascript";
}

if (!realpath(dirname(__FILE__) . "/../" . $PM_JAVASCRIPT)) {
    error_log("P.MAPPER-ERROR: location '$PM_JAVASCRIPT' not existing. Check config at section 'pm_javascript'");
    exit();
} else {
    $PM_JAVASCRIPT_REALPATH = str_replace('\\', '/', realpath(dirname(__FILE__) . "/../" . $PM_JAVASCRIPT));
}

if (isset($ini['config']['pm_javascript_optional'])) {
    $jsOptional = $ini['config']['pm_javascript_optional'];
    if (is_array($jsOptional)) {
        $PM_JAVASCRIPT_OPTIONAL = $jsOptional;
    } else {
        $PM_JAVASCRIPT_OPTIONAL = array(trim($jsOptional));
    }
} else {
    $PM_JAVASCRIPT_OPTIONAL = False;
}

/**
 * Directory PLUGINS 
 */
if (isset($ini['config']['pm_plugin_location'])) {
    $PM_PLUGIN_LOCATION  = trim($ini['config']['pm_plugin_location']);
} else {
    $PM_PLUGIN_LOCATION = "plugins";
}

if (!realpath(dirname(__FILE__) . "/../" . $PM_PLUGIN_LOCATION)) {
    error_log("P.MAPPER-ERROR: location '$PM_PLUGIN_LOCATION' not existing. Check config at section 'pm_javascript'");
    exit();
} else {
    $PM_PLUGIN_REALPATH = str_replace('\\', '/', realpath(dirname(__FILE__) . "/../" . $PM_PLUGIN_LOCATION));
}



/**
 * Application language
 */
if (isset($_REQUEST['language'])) {
    $gLanguage = trim($_REQUEST['language']);
} elseif (isset($_SESSION['language'])) {
    $gLanguage = trim($_SESSION['language']);
} elseif (isset($ini['locale']['defaultLanguage'])) {
    $gLanguage = trim($ini['locale']['defaultLanguage']);
} elseif (isset($_ENV['PM_DEFAULT_LANGUAGE'])) {
    $gLanguage = trim($_ENV['PM_DEFAULT_LANGUAGE']);
} elseif (isset($_SERVER['PM_DEFAULT_LANGUAGE'])) {
    $gLanguage = trim($_SERVER['PM_DEFAULT_LANGUAGE']);
} else {
    $gLanguage = "en";   // default language
}


/**
 * Config file for attribute search, default = search.xml
 */
if (isset($ini['config']['pm_search_configfile'])) {
    $pm_search_configfile_ini = $ini['config']['pm_search_configfile'];
    if ($ini['config']['pm_search_configfile'] == "inline") { 
        $PM_SEARCH_CONFIGFILE = $PM_BASECONFIG_DIR . "/config_" . $config . ".xml";
    } else {
        if ($pm_search_configfile_ini{0} == "/" || $pm_search_configfile_ini{1} == ":") {
            $PM_SEARCH_CONFIGFILE = $pm_search_configfile_ini;
        } else {
            $PM_SEARCH_CONFIGFILE = $PM_BASECONFIG_DIR . "/". $pm_search_configfile_ini;
        }
    }
} else {
    $PM_SEARCH_CONFIGFILE = $PM_CONFIG_DIR . "/search.xml";
}

if (!is_file($PM_SEARCH_CONFIGFILE)) {
    error_log("P.MAPPER-ERROR: Wrong entry for 'pm_search_configfile' in config. File '$PM_SEARCH_CONFIGFILE' not existing");
}


/**
 * Config file for printing, default = print.xml
 */
if (isset($ini['config']['pm_print_configfile'])) {
    $pm_print_configfile_ini = $ini['config']['pm_print_configfile'];
    if ($pm_print_configfile_ini{0} == "/" || $pm_print_configfile_ini{1} == ":") {
        $PM_PRINT_CONFIGFILE = $ini['config']['pm_print_configfile'];
    } else {
        $PM_PRINT_CONFIGFILE = $PM_BASECONFIG_DIR . "/". $ini['config']['pm_print_configfile'];
    }
} else {
    $PM_PRINT_CONFIGFILE = $PM_BASECONFIG_DIR . "/common/print.xml";
}

if (!is_file($PM_PRINT_CONFIGFILE)) {
    error_log("P.MAPPER-ERROR: Wrong entry for 'pm_print_configfile' in config. File '$PM_PRINT_CONFIGFILE' not existing");
}


/**
 * Plugin definitions
 */
$plugin_jsInitList = array();
$plugin_jsTocInitList = array();
$plugin_jsMapUpdateList = array();
$plugin_jsFileList = array();
$plugin_jsFilePathAlreadyIncludedList = array();
$plugin_cssFileList = array();
$plugin_cssFilePathAlreadyIncludedList = array();
$plugin_phpFileList = array();
// MapObj modifiers
$plugin_phpMapObjModifierFileList = array();
// External js Files
$plugin_jsExternalFileList = array();
// Query layers: modify query results in js
$plugin_jsModifyQueryResultsFunctions = array();

// plugins should always be an array:
if (!isset($ini['pmapper']['plugins'])) {
	$ini['pmapper']['plugins'] = array();
} else if (!is_array($ini['pmapper']['plugins'])){
	$ini['pmapper']['plugins'] = array($ini['pmapper']['plugins']);
}

if (isset($ini['pmapper']['plugins'])) {
    $plugins = (array)$ini['pmapper']['plugins']; 
    foreach ($plugins as $p) {
        $pluginDir = "$PM_PLUGIN_REALPATH/$p"; 
        
        if (is_dir($pluginDir)) {
            if (is_file("$pluginDir/config.inc")) {
                include_once("$pluginDir/config.inc");
                
                if (isset($jsInitFunction)) {
                    $plugin_jsInitList[] = $jsInitFunction;
                }
                unset($jsInitFunction);
                
                if (isset($jsTocInitFunction)) {
                    $plugin_jsTocInitList[] = $jsTocInitFunction;
                }
                unset($jsTocInitFunction);
                
                if (isset($jsMapUpdateFunction)) {
                    $plugin_jsMapUpdateList[] = $jsMapUpdateFunction;
                }
                unset($jsMapUpdateFunction);

                // Query layers: modify query results in js
                if (isset($jsModifyQueryResultsFunctions)) {
                	if (is_array($jsModifyQueryResultsFunctions)) {
                		$plugin_jsModifyQueryResultsFunctions = array_merge($plugin_jsModifyQueryResultsFunctions, $jsModifyQueryResultsFunctions);
                	} else if (is_string($jsModifyQueryResultsFunctions)) {
                		$plugin_jsModifyQueryResultsFunctions[] = $jsModifyQueryResultsFunctions;
                	}
                }
                unset($jsModifyQueryResultsFunctions);
                
                if (isset($jsFiles)) {
                    foreach($jsFiles as $jf) {
                    	$jsPath = realpath("$PM_PLUGIN_REALPATH/$p/$jf");
						$jsRealFile = "$jsPath/$jf";
						if (!in_array($jsRealFile, $plugin_jsFilePathAlreadyIncludedList)) {
							$plugin_jsFilePathAlreadyIncludedList[] = $jsRealFile;
	                        $plugin_jsFileList[] = "$PM_PLUGIN_LOCATION/$p/$jf";
						}
                    }
                }
                unset($jsFiles);

				// External js Files
                if (isset($jsExternalFiles)) {
                    foreach($jsExternalFiles as $jef) {
                        $plugin_jsExternalFileList[] = "$jef";
                    }
                }
                unset($jsExternalFiles);
                
                if (isset($cssFiles)) {
                    foreach($cssFiles as $jf) {
                    	$cssPath = realpath("$PM_PLUGIN_REALPATH/$p/$jf");
                    	$cssRealFile = "$cssPath/$jf";
						if (!in_array($cssRealFile, $plugin_cssFilePathAlreadyIncludedList)) {
							$plugin_cssFilePathAlreadyIncludedList[] = $cssRealFile;
	                        $plugin_cssFileList[] = "$PM_PLUGIN_LOCATION/$p/$jf";
						}
                    }
                }
                unset($cssFiles);
                
                if (isset($phpFiles)) {
                    foreach($phpFiles as $pf) {
                        if (is_file("$pluginDir/$pf")) {
                            $plugin_phpFileList[] = "$pluginDir/$pf";
                        }
                    }
                }
                unset($phpFiles);
				
				// MapObj modifiers
				if (isset($phpMapObjModifierFiles)) {
                    foreach($phpMapObjModifierFiles as $pf) {
                        if (is_file("$pluginDir/$pf")) {
                            $plugin_phpMapObjModifierFileList[] = "$pluginDir/$pf";
                        }
                    }
                }
                unset($phpMapObjModifierFiles);
                
                
            } else {
                error_log("P.MAPPER-ERROR: plugin config file '$pluginDir/config.inc' not existing");
            }
        } else {
            error_log("P.MAPPER-ERROR: plugin directory '$pluginDir' not existing");
        }
    }
}


/**
 * Define constants
 */
define("PM_INCPHP",              $PM_INCPHP);
define("PM_INCPHP_LOCATION",     $PM_INCPHP_LOCATION);
define("PM_JAVASCRIPT",          $PM_JAVASCRIPT);
define("PM_JAVASCRIPT_REALPATH", $PM_JAVASCRIPT_REALPATH);
define("PM_PLUGIN_LOCATION",     $PM_PLUGIN_LOCATION);
define("PM_PLUGIN_REALPATH",     $PM_PLUGIN_REALPATH);
define("PM_CONFIG_LOCATION",     $PM_CONFIG_LOCATION);
define("PM_CONFIG_LOCATION_COMMON",   $PM_CONFIG_LOCATION_COMMON);
define("PM_CONFIG_DIR",          $PM_CONFIG_DIR);
define("PM_BASECONFIG_DIR",      $PM_BASECONFIG_DIR);
define("PM_JS_CONFIG",           $PM_JS_CONFIG);


/**
 * Write vars to session
 */
$_SESSION['PM_BASE_DIR']               = $PM_BASE_DIR;
$_SESSION['PM_BASECONFIG_DIR']         = $PM_BASECONFIG_DIR;
$_SESSION['PM_CONFIG_LOCATION']        = $PM_CONFIG_LOCATION;
$_SESSION['PM_CONFIG_LOCATION_COMMON'] = $PM_CONFIG_LOCATION_COMMON;
$_SESSION['PM_CONFIG_DIR']             = $PM_CONFIG_DIR;
$_SESSION['PM_SEARCH_CONFIGFILE']      = $PM_SEARCH_CONFIGFILE;
$_SESSION['PM_PRINT_CONFIGFILE']       = $PM_PRINT_CONFIGFILE;
$_SESSION['PM_INCPHP']                 = $PM_INCPHP;
$_SESSION['PM_INCPHP_LOCATION']        = $PM_INCPHP_LOCATION;
$_SESSION['PM_JAVASCRIPT']             = $PM_JAVASCRIPT;
$_SESSION['PM_JAVASCRIPT_OPTIONAL']    = $PM_JAVASCRIPT_OPTIONAL;
$_SESSION['PM_MAP_FILE']               = $PM_MAP_FILE;
$_SESSION['PM_TPL_MAP_FILE']           = $PM_TPL_MAP_FILE;
$_SESSION['PM_PLUGIN_LOCATION']        = $PM_PLUGIN_LOCATION;
$_SESSION['PM_PLUGIN_REALPATH']        = $PM_PLUGIN_REALPATH;

$_SESSION['gLanguage']  = $gLanguage;
$_SESSION['defCharset'] = $defCharset;
$_SESSION['msVersion']  = $msVersion;
$_SESSION['session_alive'] = 1;
$_SESSION['config']     = $config;

$_SESSION['plugin_jsFileList']    = array_unique($plugin_jsFileList);
$_SESSION['plugin_jsInitList']    = $plugin_jsInitList;
$_SESSION['plugin_jsTocInitList'] = $plugin_jsTocInitList;
$_SESSION['plugin_cssFileList']   = $plugin_cssFileList;
$_SESSION['plugin_phpFileList']   = $plugin_phpFileList;
// MapObj modifiers
$_SESSION['plugin_phpMapObjModifierFileList'] = $plugin_phpMapObjModifierFileList;
// External js Files
$_SESSION['plugin_jsExternalFileList'] = $plugin_jsExternalFileList;
// Query layers: modify query results in js
$_SESSION['plugin_jsModifyQueryResultsFunctions'] = array_unique($plugin_jsModifyQueryResultsFunctions);

?>