<?php

/******************************************************************************
 *
 * Purpose: get available projections
 * Author:  Christophe Arioli, SIRAP
 *
 *****************************************************************************
 *
 * Copyright (c) 2011 SIRAP
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * p.mapper is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/

// prevent XSS
if (isset($_REQUEST['PM_INCPHP'])) exit();

require_once('../../incphp/pmsession.php');

require_once('../../incphp/globals.php');

$projsArray = array();
$mapProjection = '';
$mapUnit = '';

if (!isset($_SESSION['pluginsConfig']['exportPoints'])) {
    pm_logDebug(0, "P.MAPPER-ERROR: Configuration under '<pluginsConfig><exportPoints>' is missing. Check your config.xml file ({$_SESSION['PM_BASECONFIG_DIR']}/config_{$_SESSION['config']}.xml).");
} else if (isset($_SESSION['pluginsConfig']['exportPoints']['projections']['prj'])) {
	$mapUnit = $map->units;
	$prjList = $_SESSION['pluginsConfig']['exportPoints']['projections']['prj'];
	if ($prjList) {
		$mapProjection = $map->getProjection();
		$mapProjection = preg_replace('/^\+/', '', $mapProjection);

		foreach ($prjList as $p) {
			if (isset($p['definition'])) {
				$projName = isset($p['name']) ? $p['name'] : $p['definition'];
				$projDef = $p['definition'];
				$projsArray[] = array('prjName' => $projName, 'prjDef' => $projDef);
			}
		}
	}
}

$prjJson = json_encode($projsArray);

header("Content-Type: text/plain; charset=$defCharset");
echo "{\"prjJson\": $prjJson, \"mapProj\": \"$mapProjection\", \"mapUnit\": \"$mapUnit\"}";
?>