$.extend(PM.Plugin, 
{
	MenuDlg : 
	{
		addMenu: function (dlgName, menuName, menuItems) {	
			var menuContainer = $('#' + dlgName + ' .menuBar table tr');
			
			if (menuContainer.length == 0) {
				$('#' + dlgName + '_TC').after('<div class="menuBar"><table><tr></tr></table></div>');
				PM.Dlg.adaptDWin($('#' + dlgName));
				menuContainer = $('#' + dlgName + ' .menuBar table tr');
			}
			
			if (menuContainer.length == 1) {		
				var menuPnl = this.createMenuButton(menuContainer, menuName);
				this.addMenuItems(menuPnl, menuItems);
			}
			
			return true;	
		},
		
		createMenuButton: function(menuContainer, btnName) {
			var menuPanel = false;
				
			menuContainer.find('td').each(function(){
				if ($(this).find('div:first').html() == btnName) {
					menuPanel = $(this).find('ul');
					return false;
				}
			});
			
			if (!menuPanel) {
				var menuBtn;
				
				menuPanel = $('<ul></ul>');
				menuPanel.hide();
				$.data(menuPanel, 'pnlName', btnName);
				
				menuBtn = $('<td><div>' + btnName + '</div></td>');
				menuBtn.hover(function(){}, function(){
					if ($.data(menuBtn, "visible")){
						menuPanel.slideUp('fast');
						$.data(menuBtn, "visible", false);
						menuBtn.removeClass('menuButtonSelected');
					}
				});
				
				$.data(menuBtn, 'visible', false);
				menuBtn.click(function(){
					menuBtn.toggleClass('menuButtonSelected');
					if ($.data(menuBtn, "visible")){
						menuPanel.slideUp("fast");
	                    $.data(menuBtn, "visible", false);
					} else {
						//var pos = menuBtn.position();
						var pos = menuBtn.offset();
						menuPanel.css('left', pos.left);
						if (menuPanel.outerWidth() < menuBtn.outerWidth()) {
							menuPanel.css('width', menuBtn.outerWidth());
						}
						
						menuPanel.css('top', pos.top + menuBtn.outerHeight());
						//menuPanel.slideDown('fast');
						menuPanel.show();
						$.data(menuBtn, "visible", true);
					}
				});
				
				menuBtn.append(menuPanel);
				menuContainer.append(menuBtn);
			}
			
			return menuPanel;
		},
		
		addMenuItems: function(menuPanel, items) {
			for(var i= 0; i < items.length; i++) {
				menuLink = $('<a></a>').html(items[i].name);
				if (typeof(items[i].link != 'undefined') && items[i].link != '') {
					menuLink.attr('href', items[i].link);	
				} else {
					menuLink.addClass('disabled');
				}
				menuItem = $('<li></li>').append(menuLink);
				menuPanel.append(menuItem);
			}
		}
	}
});

$.extend(PM.Dlg,
{
	adaptDWin: function(container) {
        var cn = container.id();
        var newMSGh = parseInt($('#' + cn).css('height')) - parseInt($('#' + cn +'_TC').outerHeight()) - parseInt($('#' + cn + '_BC').outerHeight()) ; 
        var menu = $('#' + cn + ' .menuBar');
        if (menu.length == 1) {
        	newMSGh -= parseInt(menu.outerHeight());
        }
        $('#' + cn + '_MSG').css({height: newMSGh});
    }
});