/******************************************************************************
 *
 * Purpose: selectionManagement
 * Author:  Vincent Mathis, SIRAP
 *
 ******************************************************************************
 *
 * Copyright (c) 2009 SIRAP
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/

$.extend(PM.Plugin, 
{
	SelectionManagement: 
	{
		dlgSaveSelection: {width:400, height:330, left:250, top:250, resizeable:true, newsize:true, container:'pmSavSelectionContainer', name:_p('selectionManagement_savSelectionDlg')},
		dlgCalculLengthArea: {width:400, height:200, left:250, top:250, resizeable:true, newsize:true, container:'pmCalculLengthArea', name:_p('selectionManagement_calculLengthAreaDlg')},
		useMenuDlg: false,
		bRename: true,
		
		/**
		 * Link: remove from selection
		 */
		obj_results_links: {},
		
		/**
		 * Init function
		 * 
		 * Only init the link(s)
		 */
		init: function() {
			var link = '<div class="selectionManagement_linkImg" ';
			link += 'alt="' + _p('selectionManagement_removeSelected__object') + '" ';
			link += 'title="' + _p('selectionManagement_removeSelected__object') + '" ';
			link += 'onclick="javascript:PM.Plugin.SelectionManagement.removeObjectFromSelection(\'--shpLayer--\',\'--shpIndex--\')"';
			link += '>&nbsp;</div>';
			this.obj_results_links = {"selectionManagement_removeSelected__header": link};
			
			PM.Query.writeQResultEventTab.push('PM.Plugin.SelectionManagement.getEtatCurrentSel');
			
			if (typeof(PM.ini.pluginsConfig.selectionManagement) != 'undefined') {
				if (typeof(PM.ini.pluginsConfig.selectionManagement.useMenuDlg) != 'undefined') {
					if (PM.ini.pluginsConfig.selectionManagement.useMenuDlg == 1) {
						this.useMenuDlg = true;
					}
				}
			}
		},
		
		/**
		 * AJAX call to remove an object from selection (by layer and index)
		 */
		removeObjectFromSelection: function (layer, shapeIndex) {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_selectionManagement.php";
			var params = SID;
			params += '&operation=remove_selected';
			params += '&layerName=' + layer;
			params += '&objIndex=' + shapeIndex;
	
			$.ajax({
				url: url,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					// Select the objects
					PM.Query.writeQResult(response.queryResult, PM.infoWin);	
					// Si selection vide
					if (response.queryResult == 0) {
						PM.Map.clearInfo();
					}
				},
				error: function (XMLHttpRequest, textStatus, errorThrown) {
					if (window.console) {
						console.log(errorThrown);
					}
				}	
			});
		},
		
		/**
		 * Add header
		 */
		extendQueryLayersHeaders : function(queryLayers, tplName) {
	        if (queryLayers && tplName != 'iquery') {
		        for (var iLayer = 0 ; iLayer < queryLayers.length ; iLayer++) {
		        	var currentLayer = queryLayers[iLayer];
					// ajout de la nouvelle en-tête dans le tableau
	        		$.each(this.obj_results_links, function(name, value) {
		        		currentLayer.header.push(_p(name));
		        		currentLayer.stdheader.push(_p(name));
	        		});
		        }
	        }
		    return queryLayers;
		},

		/**
		 * Add link to each object
		 */
		extendQueryLayersValues: function(queryLayers, tplName) {
			if (queryLayers && tplName != 'iquery') {
		        for (var iLayer = 0 ; iLayer < queryLayers.length ; iLayer++) {
		        	var currentLayer = queryLayers[iLayer];
		        	
		        	var links = this.obj_results_links;
		        	$.each(currentLayer.values, function(iVal, val) {
		        		$.each(links, function(name, link) {
		        			var newlink = link.replace(/--shpLayer--/g, val[0].shplink[0]);
		        			newlink = newlink.replace(/--shpIndex--/g, val[0].shplink[1]);
		        			val.push(newlink);
		        		});
		        	});
		        }
	        }
		    return queryLayers;
		},
		
		/**
		 * remove selection
		 */
		removeSelection: function() {
			var urlreq = PM_PLUGIN_LOCATION + "/selectionManagement/x_selectionManagement.php";
			var params = SID;
			params += "&operation=remove_selection";

			$.ajax({
				url: urlreq,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					PM.Plugin.SelectionManagement.getEtatCurrentSel();
					PM.Map.clearInfo();
				},	
				error: function(response) {
					alert("Echec de la suppression");
				}
			});
			
			// hide selection 
			if ($('#pmQueryContainer').length > 0) {
	            $('#pmQueryContainer .jqmClose').click();
	        }
		},
		
		/**
		 * reload selection
		 */
		reloadSelection: function() {
			var urlreq = PM_PLUGIN_LOCATION + "/selectionManagement/x_selectionManagement.php";
			var params = SID;
			params += "&operation=reload_selection";

			$.ajax({
				url: urlreq,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					// select the objects
					PM.Query.writeQResult(response.queryResult, PM.infoWin);
				},		
				error: function(response) {
					alert(_p("selectionManagement_reloadError"));
				}
			});
		},
		
		/**
		 * Reload application
		 */
		reloadMap: function(remove) {
			var mapurl = PM_XAJAX_LOCATION + 'x_load.php?'+SID+'&zoom_type=zoompoint';
			if (remove) {
				PM.extentSelectedFeatures = null;
			}
			PM.Map.updateMap(mapurl);
		},
		
		addSelectionOperator: function(container, pluginName, bInline) {
			var pluginRealName = pluginName.replace('Plugin.','');
			
			var text = '<fieldset id="' + pluginRealName + '_selOperators" class="selOperators';
			
			if (bInline) {
				text += ' ';
				text += 'selOperators_inline';
			}
			
			text += '"';
			text += ' ';
			text += 'style="border: 1px groove grey">';
			
			if (!bInline) {
				text += '<legend><b>' + _p('selectionManagement_selOperator_text') + '</b></legend>';
			}
			
			text += '<table><tr>';
			text += '<td id="' + pluginRealName + '_selOperator_new" class="selOperatorImg_new selOperatorImg_on" onclick="javascript:PM.' + pluginName + '.setSelection(\'new\')" alt="'+ _p('selectionManagement_selOperator_new_text')+ '" title="' + _p('selectionManagement_selOperator_new_text')+ '"></td>';
			text += '<td id="' + pluginRealName + '_selOperator_add" class="selOperatorImg_add selOperatorImg_on" onclick="javascript:PM.' + pluginName + '.setSelection(\'add\')" alt="'+ _p('selectionManagement_selOperator_add_text')+ '" title="' + _p('selectionManagement_selOperator_add_text')+ '"></td>';
			text += '<td id="' + pluginRealName + '_selOperator_intersec" class="selOperatorImg_intersec selOperatorImg_on" onclick="javascript:PM.' + pluginName + '.setSelection(\'intersec\')" alt="'+ _p('selectionManagement_selOperator_intersec_text')+ '" title="' + _p('selectionManagement_selOperator_intersec_text')+ '"></td>';
			text += '<td id="' + pluginRealName + '_selOperator_del" class="selOperatorImg_del" onclick="javascript:PM.' + pluginName + '.setSelection(\'del\')" alt="'+ _p('selectionManagement_selOperator_del_text')+ '" title="' + _p('selectionManagement_selOperator_del_text')+ '"></td>';
			text += '</tr></table></fieldset>';
			
			 $(container).append(text);
		},
		
		setSelectionOperator: function (pluginName, type) {
			switch(type) {
				case 'add': 
					$('#' + pluginName + '_selOperator_add').removeClass('selOperatorImg_off').addClass('selOperatorImg_on');
					$('#' + pluginName + '_selOperator_del').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_new').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_intersec').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					break;
				case 'del': 
					$('#' + pluginName + '_selOperator_add').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_del').removeClass('selOperatorImg_off').addClass('selOperatorImg_on');
					$('#' + pluginName + '_selOperator_new').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_intersec').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					break;
				case 'new':
					$('#' + pluginName + '_selOperator_add').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_del').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_new').removeClass('selOperatorImg_off').addClass('selOperatorImg_on');
					$('#' + pluginName + '_selOperator_intersec').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					break;
				case 'intersec':
					$('#' + pluginName + '_selOperator_add').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_del').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_new').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_intersec').removeClass('selOperatorImg_off').addClass('selOperatorImg_on');
					break;
				default :
					$('#' + pluginName + '_selOperator_add').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_del').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_new').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					$('#' + pluginName + '_selOperator_intersec').removeClass('selOperatorImg_on').addClass('selOperatorImg_off');
					break;
			}
		},
		
		openSavSelectionDlg: function() {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelectionDlg.phtml";
			var params = SID;
			
			$.ajax({
				url: url,
				dataType: "html",
				type: "POST",
				data: params,
				success: function(response) {
		        	PM.Dlg.createDnRDlg(PM.Plugin.SelectionManagement.dlgSaveSelection, PM.Plugin.SelectionManagement.dlgSaveSelection.name, false);
					$('#' + PM.Plugin.SelectionManagement.dlgSaveSelection.container + '_MSG').html(response);
					$('#selectionManagement_selList .selectionManagement_tabSelection').hide();
					$('#selectionManagement_selList .selectionManagement_noSelection').hide();
					$('#selectionManagement_saveSelection_newColor').SevenColorPicker(true);
					$('#selectionManagement_saveSelection_newOutlineColor').SevenColorPicker();
					$('#selectionManagement_selListFooter ').hide();
					$('#selectionManagement_newSelection .btnSaveSelection input').attr("disabled", true);
					
					$("#selectionManagement_selListFooter td").hover(function() {
						var text = '&nbsp;';

						if ($(this).find('div').hasClass('selectionManagement_reloadSelection')) {
							text = _p('selectionManagement_btnReloadSavSelTitle');
						} else if ($(this).find('div').hasClass('selectionManagement_addSelection')) {
							text = _p('selectionManagement_btnAddSavSelTitle');
						} else if ($(this).find('div').hasClass('selectionManagement_intersectSelection')) {
							text = _p('selectionManagement_btnIntersectSavSelTitle');
						} else if ($(this).find('div').hasClass('selectionManagement_excludeSelection')) {
							text = _p('selectionManagement_btnExcludeSavSelTitle');
						} else if ($(this).find('div').hasClass('selectionManagement_deleteSelection')) {
							text = _p('selectionManagement_btnDeleteSavSelTitle');
						}
						
						$("#selectionManagement_selListFooter .footerHoverAction").html(text);
					}, function() {
						$("#selectionManagement_selListFooter .footerHoverAction").html('&nbsp;');
					});
					PM.Plugin.SelectionManagement.getSelection();
				},
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (window.console) console.log(errorThrown);
                }
			});
		},
		
		saveSelection: function() {
			var grpName = "new_selection";
			var jsonString = '';
			var jsonStringColor = '';
			var tabColor = ['255', '0', '0'];
			var tabOutlineColor = ['0', '0', '0'];
			
			$('#selectionManagement_newSelection .btnSaveSelection input').attr("disabled", true);
			
			grpName = $('#selectionManagement_saveSelection_newName').val();
			grpName = grpName.replace(/"/g, '');
			grpName = grpName.replace(/'/g, '');
		
			color = $('#selectionManagement_saveSelection_newColor').val();
			if (color == "") {	
				color = '-1, -1, -1';
			} else if (color.substring(0, 1) == '#') {
				color = convertHexToRGB(color);
			} else {
				color = color.substring(4, color.length - 1);
			}
			tabColor = color.split(', ');
			
			color = $('#selectionManagement_saveSelection_newOutlineColor').val();
			if (color.substring(0, 1) == '#') {
				color = convertHexToRGB(color);
			} else {
				color = color.substring(4, color.length - 1);
			}
			tabOutlineColor = color.split(', ');
			
			if (grpName.length == 0) {
				return;
			}
			
			jsonStringColor = '"background":{"R": "' + tabColor[0] + '", "G": "' + tabColor[1] + '", "B": "' + tabColor[2] + '"}, "outline":{"R": "' + tabOutlineColor[0] + '", "G": "' + tabOutlineColor[1] + '", "B": "' + tabOutlineColor[2] + '"}';
			jsonString = '[{"def":{"type":"msMapFile", "layername": "", "description": "' + grpName + '", "category": "selectionmanagement_selectionCategory", "color":{' + jsonStringColor + '}}, "datatype": "msCurrentSelection", "data":{}}]';
				
			PM.Map.ClientDynamicLayers.addOrReplaceLayers(jsonString);
		},
		
		deleteSelection: function() {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID;
			var selectionList = '';
			
			$('.selectionManagement_chkBox_select').each(function() {
				if ($(this).is(':checked')) {			
					if (selectionList != '') {
						selectionList += ',';
					}
					
					selectionList += $(this).val();
				}
				
			});
			
			if (selectionList != '') {
				params += '&action=deleteSelection';
				params += '&selectionList=' + selectionList; 
				$.ajax({
					url: url,
					dataType: "json",
					type: "POST",
					data: params,
					success: function(response) {
						if (response.ok) {
							var jsonString = JSON.stringify(response.layers);
							PM.Map.ClientDynamicLayers.removeLayers(jsonString);
							PM.Plugin.SelectionManagement.getSelection();
						}
					},	
					error: function(response) {
					}
				});
			}
		},
		
		getSelection: function() {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID + '&action=getSelectionList';
			
			if (!$('#selectionManagement_selList').length) {
				return;
			}
			
			$.ajax({
				url: url,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					if (response.ok) {
						var bShowTab = false;
						
						$('#selectionManagement_selList .selectionManagement_selectionLine').remove();
						
						if (response.bCurrentSel) {
							$('#selectionManagement_newSelection .btnSaveSelection input').attr("disabled", false);
							if (response.bShowCurrentSel) {
								$('.selectionManagement_saveSelection_showCurrentSelection').attr('checked','checked');
							} else {
								$('.selectionManagement_saveSelection_showCurrentSelection').attr('checked','');
							}
							$('.selectionManagement_currentSelectionLine').show();
							bShowTab = true;
						} else {
							$('.selectionManagement_currentSelectionLine').hide();
							$('#selectionManagement_newSelection .btnSaveSelection input').attr("disabled", true);
						}
						
						if (response.selCount) {
							$('#selectionManagement_selList .selectionManagement_tabSelection').append(response.html);
							bShowTab = true;	
							$('.selectionManagement_saveSelection_selColor input').SevenColorPicker(true);
							$('.selectionManagement_saveSelection_selOutlineColor input').SevenColorPicker();
							PM.Plugin.SelectionManagement.updateSelectionCheckbox();
						}
						
						if (bShowTab) {
							$('#selectionManagement_selList .selectionManagement_noSelection').hide();
							$('#selectionManagement_selList .selectionManagement_tabSelection').show();
							$('#selectionManagement_selListFooter ').show();
						} else {
							$('#selectionManagement_selList .selectionManagement_tabSelection').hide();
							$('#selectionManagement_selList .selectionManagement_noSelection').show();
							$('#selectionManagement_selListFooter ').hide();
						}
					}
				},	
				error: function(response) {
					$('#selectionManagement_selList .selectionManagement_selectionLine').remove();
					$('#selectionManagement_selList .selectionManagement_tabSelection').hide();
					$('#selectionManagement_selList .selectionManagement_noSelection').show();
					$('#selectionManagement_selListFooter ').hide();
				},
			});
		},
		
		changeSelectionColor: function(bBgColor, itemId) {
			var selector;
			var color;
			var colorType;
			
			// be careful: because of js compression bad algorithm, do not use ending parentesis followed by space in string
			if (bBgColor) {
				selector= '#selectionManagement_selList .selectionManagement_saveSelection_selColor:eq(' + itemId + ')' + ' input:first';
				colorType = 'background';
			} else {
				selector= '#selectionManagement_selList .selectionManagement_saveSelection_selOutlineColor:eq(' + itemId + ')' + ' input:first';
				colorType = 'outline';
			}
			
			color = $(selector).val();
			if (color == "") {
				color = '-1, -1, -1';
			} else if (color.substring(0, 1) == '#') {
				color = convertHexToRGB(color);
			} else {
				color = color.substring(4, color.length - 1);
			}
			
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID + '&action=changeSelectionColor' + '&itemId=' + itemId + '&colorType=' + colorType + '&newColor=' + color;
			$.ajax({
				url: url,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					if (response.ok) {
						PM.Map.reloadMap(false);
					}
				},	
				error: function(response) {
				}
			});
		},
		
		upateSelectionList: function() {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID + '&action=updateSelectionList';
			$.ajax({
				url: url,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					if (response.ok) {
						if (response.update) {
							var rgbString = 'rgb(' + response.newRgbColor.R + ',' +  response.newRgbColor.G + ',' + response.newRgbColor.B + ')';
							$('#selectionManagement_saveSelection_newColor').next().css('background-color', rgbString);
							$('#selectionManagement_saveSelection_newColor').val(response.newHexColor);
							PM.Plugin.SelectionManagement.getSelection();
							PM.Plugin.SelectionManagement.removeSelection();
						}
					}
				},	
				error: function(response) {
				}
			});
		},
		
		reloadSavedSelection: function(selectMethode) {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID;
			var selectionList = '';
			
			$('.selectionManagement_chkBox_select').each(function() {
				if ($(this).is(':checked')) {			
					if (selectionList != '') {
						selectionList += ',';
					}
					selectionList += $(this).val();
				}
				
			});
			
			if (selectionList != '') {
				params += '&action=reloadSelection';
				params += '&selectionList=' + selectionList; 
				params += '&selectMethode=' + selectMethode;
				$.ajax({
					url: url,
					dataType: "json",
					type: "POST",
					data: params,
					success: function(response) {
						if (response.ok) {
							PM.Plugin.SelectionManagement.showHideAllSelections(0, true);
							PM.Query.writeQResult(response.queryResult, PM.infoWin);
						}
					},	
					error: function(response) {
					}
				});
			}
		},
		
		insertAfterResultQuery: function() {
			var html = '';
			
			if (typeof(PM.Plugin.MenuDlg) != 'undefined' && this.useMenuDlg) {
				var menuItems = [{name:_p('selectionManagement_menuSaveSelection'), link:'javascript:PM.Plugin.SelectionManagement.openSavSelectionDlg();'}];
				PM.Plugin.MenuDlg.addMenu('pmQueryContainer', _p('selectionManagement_menuSelectionName'), menuItems);
			} else {
				html ='<div><input type="button" value="' + _p('selectionManagement_savSelectionDlg') + '" onclick="PM.Plugin.SelectionManagement.openSavSelectionDlg()">';
			}
			
			return html;
		},
		
		updateSelectionCheckbox: function() {
			var layerstring = PM.Toc.getLayers();
			
			if (layerstring.length > 0) {
				var tabLayer = layerstring.split(',');
			
				$('.selectionManagement_saveSelection_showLayer').each(function() {
					var val = $(this).val();
					if (val != 'currentSelection') {
						if (tabLayer.indexOf(val) >= 0) {
							$(this).attr('checked','checked');
						} else {
							$(this).attr('checked','');
						}
						
						$('#ginput_' + val).bind('click', function(){PM.Plugin.SelectionManagement.updateSelectionCheckbox();});
					}
				});
			}
		},
		
		showHideSelection: function(itemId) {
			var bChecked;
			// be careful: because of js compression bad algorithm, do not use ending parentesis followed by space in string
			var chkBox = $('#selectionManagement_selList .selectionManagement_saveSelection_showLayer:eq(' + itemId + ')');
			var grpName = chkBox.val();
			
			bChecked = chkBox.attr('checked');
			$('#ginput_' + grpName).attr('checked', bChecked); 
			PM.Toc.setlayers(grpName, false);
		},
		
		checkUncheckAllSelections: function(bCheck) {
			var checked = '';
			if (bCheck) {
				checked = 'checked';
			}
			$('.selectionManagement_chkBox_select').attr('checked', checked);
			this.enabledDisabledButtons();
		},
		
		showHideCurrentSelection: function() {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID + '&action=displayCurrentSelection&bShow=';
			var bShow = $('.selectionManagement_saveSelection_showCurrentSelection').is(':checked');
			
			if (bShow) {
				params += '1';
			} else {
				params += '0';
			}
			
			$.ajax({
				url: url,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					PM.Plugin.SelectionManagement.reloadMap(false);
				},	
				error: function(response) {
				}
			});
		},
		
		showHideAllSelections: function(bShow, bOnlySelected) {
			var grpNameArray = new Array();
			var grpName = '';
			var bAddCurrentSel = false;
			var selector = '.selectionManagement_saveSelection_showLayer';
			if (typeof(bOnlySelected) == 'undefined' || !bOnlySelected) {
				bAddCurrentSel = true;
			}
			
			if (bAddCurrentSel) {
				selector += ', .selectionManagement_saveSelection_showCurrentSelection';
			}
			
			
			$(selector).each(function() {
				grpName = $(this).val();
				if (grpName == 'currentSelection') {
					var bExecute = false;
					if (bShow && !$(this).is(':checked')) {
						$(this).attr('checked', 'checked'); 
						bExecute = true;
					} else if (!bShow && $(this).is(':checked')) {
						$(this).attr('checked', ''); 
						bExecute = true;
					}
					if (bExecute) {
						PM.Plugin.SelectionManagement.showHideCurrentSelection();
					}
				} else {
					if (!bOnlySelected || (bOnlySelected && $(this).parent().parent().find('.selectionManagement_chkBox_select').is(':checked'))) {
						if (bShow && !$(this).is(':checked')) {
							$('#ginput_' + grpName).attr('checked', 'checked'); 
							$(this).attr('checked', 'checked'); 
							grpNameArray.push(grpName);
						} else if (!bShow && $(this).is(':checked')) {
							$('#ginput_' + grpName).attr('checked', ''); 
							$(this).attr('checked', ''); 
							grpNameArray.push(grpName);
						}
					}
				}
			});
			
			if (grpNameArray.length > 0) {
				PM.Toc.setlayers(grpName, false);
			}
		},
		
		getEtatCurrentSel: function() {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID + '&action=getEtatCurrentSel';
			
			$.ajax({
				url: url,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					if (response.bCurrentSel) {
						if (response.bShowCurrentSel) {
							$('.selectionManagement_saveSelection_showCurrentSelection').attr('checked','checked');
						} else {
							$('.selectionManagement_saveSelection_showCurrentSelection').attr('checked','');
						}
						$('.selectionManagement_currentSelectionLine').show();
						$('#selectionManagement_selList .selectionManagement_tabSelection').show();
						$('#selectionManagement_selList .selectionManagement_noSelection').hide();
						$('#selectionManagement_selListFooter ').show();
						$('#selectionManagement_newSelection .btnSaveSelection input').attr("disabled", false);
					} else {
						$('.selectionManagement_currentSelectionLine').hide();
						$('#selectionManagement_newSelection .btnSaveSelection input').attr("disabled", true);
						if ($('#selectionManagement_selList .selectionManagement_tabSelection tr').lenght == 2) {
							$('#selectionManagement_selList .selectionManagement_tabSelection').hide();
							$('#selectionManagement_selList .selectionManagement_noSelection').show();
							$('#selectionManagement_selListFooter ').hide();
						}
					}
				},	
				error: function(response) {
				}
			});
		},
		
		enabledDisabledButtons: function() {
			if ($('#selectionManagement_selList .selectionManagement_chkBox_select:checked').length > 0) {
				$('#selectionManagement_selListFooter .button').removeClass('disabledButton').addClass('enabledButton');
			} else {
				$('#selectionManagement_selListFooter .button').removeClass('enabledButton').addClass('disabledButton');
			}
		},
		
		showRenameSelectionDlg: function(selectionName, itemId) {
			var html;
			
			if (this.bRename) {
				this.bRename = false;
				var item = $('#selectionManagement_selList .selectionManagement_saveSelection_description:eq(' + itemId + ')');
				var currentDescription = item.text();
				
				html = '<input class="newNameInput" type="text" name="newDescription" value="' + currentDescription + '">';
				html += '<div class="newNameComande">' + _p('selectionManagement_renameSelectionCommande') + '</div>';
				
				item.html(html);
				item.find('.newNameInput').focus().keydown(function(e) {
						
						if (e.which == 27) {
							//echap
							item.text(currentDescription);
							PM.Plugin.SelectionManagement.bRename = true;
						} else if (e.which == 13) {
							//entrée;
							var newDescription = $(this).val();
							item.text(currentDescription);
							PM.Plugin.SelectionManagement.bRename = true;
							if (newDescription != '' && newDescription != currentDescription) {
								PM.Plugin.SelectionManagement.renameSelection(selectionName, itemId, newDescription);
							}
						}
				}).blur(function() {
					item.text(currentDescription);
					PM.Plugin.SelectionManagement.bRename = true;
				});
			}
		},
		
		renameSelection: function(selectionName, itemId, newDescription) {
			var url = PM_PLUGIN_LOCATION + "/selectionManagement/x_saveSelection.php";
			var params = SID + '&action=renameSelection&selectionName=' + selectionName + '&newDescription=' + newDescription;
			
			$.ajax({
				url: url,
				dataType: "json",
				type: "POST",
				data: params,
				success: function(response) {
					PM.Toc.init();
					$('#selectionManagement_selList .selectionManagement_saveSelection_description:eq(' + itemId + ')').text(newDescription);
				},	
				error: function(response) {
				}
			});
		}
	}
});

$.merge(PM.Custom.queryResultAddList, ['PM.Plugin.SelectionManagement.insertAfterResultQuery()']);
