<?php
/******************************************************************************
 *
* Purpose: save current selection in a new layer
* Author:  Julien BONNET, SIRAP
*
******************************************************************************
*
* Copyright (c) 2012 SIRAP
*
* This is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version. See the COPYING file.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with p.mapper; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
******************************************************************************/

// prevent XSS
if (isset($_REQUEST['_SESSION'])) exit();

require_once('../../incphp/group.php');
require_once('../../incphp/pmsession.php');
require_once('../../incphp/init/initmap.php');

require_once('../../incphp/globals.php');
require_once($_SESSION['PM_PLUGIN_REALPATH'] . '/clientdynamiclayers/clientDynamicLayers.php');
require_once($_SESSION['PM_PLUGIN_REALPATH'] . '/common/selectTools.inc.php');
require_once('./selectionManagementTools.inc.php');

if (!isset($_SESSION['saveSelection'])) {
	$_SESSION['saveSelection'] = array();
}

$res = array();
$res['ok'] = true;
$action = $_REQUEST['action'];

if ($action == 'updateSelectionList') {
	$res['update'] = false;	
	
	if (isset($_SESSION['clientDynamicLayers'])) {
		foreach ($_SESSION['clientDynamicLayers'] as $dynlayer) {
			if (strpos($dynlayer->def->layername, 'selectGrp_') === 0) {
				if (!isset($_SESSION['saveSelection'][$dynlayer->def->layername])) {
					$_SESSION['saveSelection'][$dynlayer->def->layername] = array();
					$_SESSION['saveSelection'][$dynlayer->def->layername]['description'] = $dynlayer->def->description;
					$_SESSION['saveSelection'][$dynlayer->def->layername]['color'] = array(); 
					$_SESSION['saveSelection'][$dynlayer->def->layername]['background'] = array();
					$_SESSION['saveSelection'][$dynlayer->def->layername]['color']['background']['R'] = $dynlayer->def->color->background->R;
					$_SESSION['saveSelection'][$dynlayer->def->layername]['color']['background']['G'] = $dynlayer->def->color->background->G;
					$_SESSION['saveSelection'][$dynlayer->def->layername]['color']['background']['B'] = $dynlayer->def->color->background->B;
					$_SESSION['saveSelection'][$dynlayer->def->layername]['outline'] = array();
					$_SESSION['saveSelection'][$dynlayer->def->layername]['color']['outline']['R'] = $dynlayer->def->color->outline->R;
					$_SESSION['saveSelection'][$dynlayer->def->layername]['color']['outline']['G'] = $dynlayer->def->color->outline->G;
					$_SESSION['saveSelection'][$dynlayer->def->layername]['color']['outline']['B'] = $dynlayer->def->color->outline->B;
					$_SESSION['saveSelection'][$dynlayer->def->layername]['selection'] = $_SESSION['JSON_Results'];
					$res['update'] = true;
					break;
				}
			}	
		}	
	}
	
	if ($res['update']) {
		$selectionColorArray = array();
		foreach ($_SESSION['saveSelection'] as $selection) {
			$selectionColorArray[] = $selection['color']['background'];
		}
		$res['newRgbColor'] = getNewColor($selectionColorArray);
		$res['newHexColor'] = sprintf('#%02s%02s%02s', dechex($res['newRgbColor']['R']), dechex($res['newRgbColor']['G']), dechex($res['newRgbColor']['B']));
		$_SESSION['selectionManagement']['saveSelection']['newColor'] = $res['newRgbColor'];
	}
	
} else if ($action == 'getSelectionList') {
	$selCount = 0;
	$colorVal;
	$bCurrentSel = false;
	$bShowCurrentSel = false;

	if (isset($_SESSION['JSON_Results']) && $_SESSION['JSON_Results']) {
		$bCurrentSel = true;
		if (isset($_SESSION['resultlayers'])) {
			$bShowCurrentSel = true;
		}
	}
	
	if (isset($_SESSION['saveSelection'])) {
		foreach ($_SESSION['saveSelection'] as $selectionName=>$selection) {
			$background = $selection['color']['background'];
			$outline = $selection['color']['outline'];
			$content .= '<tr class="selectionManagement_selectionLine">';
			$content .= '<td class="selectionManagement_colMin"><input class="selectionManagement_chkBox_select" type="checkbox" name="'.$selectionName .'" value="' .$selectionName . '" onclick="javascript:PM.Plugin.SelectionManagement.enabledDisabledButtons()"></td>';
			$content .= '<td class="selectionManagement_colMin"><input class="selectionManagement_saveSelection_showLayer" type="checkbox" name="'.$selectionName .'" value="' .$selectionName . '" onclick="javascript:PM.Plugin.SelectionManagement.showHideSelection(' .$selCount .')"></td>';
			$content .= '<td class="selectionManagement_saveSelection_description" onclick="javascript:PM.Plugin.SelectionManagement.showRenameSelectionDlg(\'' .$selectionName .'\', ' .$selCount . ')">' .$selection['description'] .'</td>';
			$content .= '<td class="selectionManagement_colMin selectionManagement_cellWithTable">';
			if ($background['R'] == -1 && $background['G'] == -1 && $background['B'] == -1) {
				$colorVal = '';
			} else {
				$colorVal = 'rgb(' .$background['R'] .',' .$background['G'] .',' .$background['B'] .')';
			}
			$content .= '<span class="selectionManagement_saveSelection_selColor"><input type="text" value="' .$colorVal .'" onchange="javascript:PM.Plugin.SelectionManagement.changeSelectionColor(true, ' .$selCount .')"  style="display: none;"></span>&nbsp;';
			$content .= '<span class="selectionManagement_saveSelection_selOutlineColor"><input type="text" value="rgb(' .$outline['R'] .',' .$outline['G'] .',' .$outline['B'] .')" onchange="javascript:PM.Plugin.SelectionManagement.changeSelectionColor(false, ' .$selCount .')"  style="display: none;"></span>';
			$content .= '</td>';
			$content .= '</tr>';
			$selCount++;
		}
	}
	
	$res['selCount'] = $selCount;
	$res['html'] = $content;
	$res['bCurrentSel'] = $bCurrentSel;
	$res['bShowCurrentSel'] = $bShowCurrentSel;
	
} else if ($action == 'deleteSelection') {
	$selectionList = $_REQUEST['selectionList'];
	$layerLst = array();
	
	$selectionList = explode(',', $selectionList);
	foreach($selectionList as $selectionName) {
		if (isset($_SESSION['saveSelection'][$selectionName])) {
			if (isset($_SESSION['clientDynamicLayers'])) {
				$actualDynlayers = $_SESSION['clientDynamicLayers'];
				foreach ($actualDynlayers as $actualDynlayer) {
					if ($actualDynlayer->def->layername == $selectionName) {
						$layerLst[] = $actualDynlayer;
					}	
				}	
			}
			unset($_SESSION['saveSelection'][$selectionName]);
		}	
	}
	
	if (!$layerLst) {
		$res['ok'] = false;
	} else {
		$res['layers'] = $layerLst;
	}
	
} else if ($action == 'changeSelectionColor') {
	$res['ok'] = false;
	
	if (isset($_SESSION['saveSelection']) && isset($_SESSION['clientDynamicLayers'])) {
		$actualDynlayers = $_SESSION['clientDynamicLayers'];
		$itemId = isset($_REQUEST['itemId'])?$_REQUEST['itemId']:'-1';
		$colorType = isset($_REQUEST['colorType'])?$_REQUEST['colorType']:'background';
		$colorString = isset($_REQUEST['newColor'])?$_REQUEST['newColor']:'255, 0, 0';
		$colorArray = explode(',', $colorString);
		
		if ($itemId >= 0 && $itemId < count($_SESSION['saveSelection'])) {	
			if (isset($colorArray[2])) {
				$color['R'] = $colorArray[0];
				$color['G'] = $colorArray[1];
				$color['B'] = $colorArray[2];
				
				$id = 0;
				foreach ($_SESSION['saveSelection'] as $selName=>$selData) {
					if ($id == $itemId) {
						foreach ($actualDynlayers as $actualDynlayer) {
							if ($actualDynlayer->def->layername == $selName) {
								if ($colorType == 'background') {
									$actualDynlayer->def->color->background->R = $color['R'];
									$actualDynlayer->def->color->background->G = $color['G'];
									$actualDynlayer->def->color->background->B = $color['B'];
									$_SESSION['saveSelection'][$selName]['color']['background'] = $color;
								} else {
									$actualDynlayer->def->color->outline->R = $color['R'];
									$actualDynlayer->def->color->outline->G = $color['G'];
									$actualDynlayer->def->color->outline->B = $color['B'];
									$_SESSION['saveSelection'][$selName]['color']['outline'] = $color;
								}
								$res['ok'] = true;
							}
						}
						
						break;	
					}
					
					$id++;
				}
			}		
		}
	}		
	
	$initMap = new Init_map($map, false, false, $_SESSION['gLanguage'], true);
	$initMap->createLegendList();
	
} else if ($action == 'reloadSelection') {
	$res['ok'] = false;
	$first = true;
	$queryResult = NULL;
	
	$selectionList = isset($_REQUEST['selectionList'])?$_REQUEST['selectionList']:'';
	$selectMethode = isset($_REQUEST['selectMethode'])?$_REQUEST['selectMethode']:'new';
	
	if ($selectionList && isset($_SESSION['saveSelection'])) {
		$selectionList = explode(',', $selectionList);
		$bMixWithCurrentSel = true;
		foreach ($selectionList as $selectionName) {
			if (isset($_SESSION['saveSelection'][$selectionName])) {
				if ($first) {
					$queryResult = $_SESSION['saveSelection'][$selectionName]['selection'];
					$first = false;
				} else {
					if ($selectMethode == 'intersec' && !$_SESSION['JSON_Results']) {
						$queryResult = SelectTools::mixSelection('intersec', $_SESSION['saveSelection'][$selectionName]['selection'], $queryResult);
						$bMixWithCurrentSel = false;
					} else {
						$queryResult = SelectTools::mixSelection('add', $_SESSION['saveSelection'][$selectionName]['selection'], $queryResult);
					}
				}
			}
		}
		
		if ($queryResult) {
			if ($bMixWithCurrentSel) {
				$queryResult =  SelectTools::mixSelection($selectMethode, $_SESSION['JSON_Results'], $queryResult);
			}
			$_SESSION['JSON_Results'] = $queryResult;
			SelectTools::updateHighlightJson($queryResult);
			$res['queryResult'] = json_decode($queryResult);
			$res['ok'] = true;
		}
		
	}
} else if ($action == 'displayCurrentSelection') {
	$res['ok'] = false;
	
	if (isset($_SESSION['JSON_Results']) && $_SESSION['JSON_Results']) {
		$bShow = isset($_REQUEST['bShow'])?$_REQUEST['bShow']:1;
		
		if ($bShow && !isset($_SESSION['resultlayers'])) {
			SelectTools::updateHighlightJson($_SESSION['JSON_Results']);
			$res['ok'] = true;
		} else if (!$bShow && isset($_SESSION['resultlayers'])) {
			unset($_SESSION['resultlayers']);
			$res['ok'] = true;
		}
	}
	
} else if ($action == 'getEtatCurrentSel') {
	$bCurrentSel = false;
	$bShowCurrentSel = false;
	
	if (isset($_SESSION['JSON_Results']) && $_SESSION['JSON_Results']) {
		$bCurrentSel = true;
		if (isset($_SESSION['resultlayers'])) {
			$bShowCurrentSel = true;
		}
	}
	
	$res['ok'] = true;
	$res['bCurrentSel'] = $bCurrentSel;
	$res['bShowCurrentSel'] = $bShowCurrentSel;
	
} else if ($action == 'renameSelection') {
	$res['ok'] = false;
	
	if (isset($_SESSION['clientDynamicLayers'])) {
		$layerName = isset($_REQUEST['selectionName'])?$_REQUEST['selectionName']:'';
		$newDescription = isset($_REQUEST['newDescription'])?$_REQUEST['newDescription']:'';
		
		if ($layerName && $newDescription && isset($_SESSION['saveSelection'][$layerName])) {
			foreach ($_SESSION['clientDynamicLayers'] as $id=>$dynLayer) {
				if ($dynLayer->def->layername == $layerName) {
					$_SESSION['clientDynamicLayers'][$id]->def->description = $newDescription;
					$_SESSION['saveSelection'][$layerName]['description'] = $newDescription;
					$res['ok'] = true;
					break;
				}		
			}	
		}	
	}
	
} else {
	$res['ok'] = false;
}

header("Content-type: text/plain; charset=$defCharset");
echo json_encode($res);

?>
