<?php

/******************************************************************************
 *
 * Purpose: increase or decrease object's size
 * Author:  Christophe Arioli, SIRAP
 *
 *****************************************************************************
 *
 * Copyright (c) 2011 SIRAP
 *
 * p.mapper is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * p.mapper is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/

// prevent XSS
if (isset($_REQUEST['PM_INCPHP'])) exit();

require_once('../../incphp/pmsession.php');

require_once('../../incphp/globals.php');


/**
 * return code :
 *   true = OK
 *   false = new scale too small
*/
$codeRet = true;

$layerName = isset($_REQUEST['layer']) ? $_REQUEST['layer'] : null;
$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'clear';

$layerArray = $_SESSION['sizeUpDownObj']['setLabelLayers'];

// clear array
if ($action == 'clear'){
	$layerArray = array();

// remove layer
} else if ($action == 'reset'){
	$search = array_search($layerName, $layerArray);
	if ($search !== false) {
		unset($layerArray[$search]);
	}

// set new scale
} else if ($action == 'scaleup') {
	if (!isset($layerArray)) {
		$layerArray = array();
	}
	
	$search = array_search($layerName, $layerArray);
	if ($search === false) {
		// map scale from session
		$currentScale = $_SESSION['geo_scale'];
		// max scale factor
		$maxscalefactor = $_SESSION['sizeUpDownObj']['setLabelScaleMaxfactor'];
		$layers = getLayersByGroupOrLayerName($map, $layerName);
		foreach ($layers as $layer) {
			$layerRet = false;
			$labelMaxScaledenom = $layer->labelmaxscaledenom != -1 ? $layer->labelmaxscaledenom : $layer->maxscaledenom;
			$limiteNewLabelMaxScale = ($maxscalefactor * $labelMaxScaledenom);
			if ($currentScale <= $limiteNewLabelMaxScale) {
				$layerRet = true;
				$layerArray[] = $layerName;
			}
			$codeRet = $codeRet && $layerRet;
		}
	}
}

$_SESSION['sizeUpDownObj']['setLabelLayers'] = $layerArray;

$returnJson = json_encode(array('coderet' => $codeRet));

header("Content-Type: text/plain; charset=$defCharset");
echo $returnJson;

?>

