
$.extend(PM.Plugin,
{
	SwitchLayers: 
	{
		srcImgOnUp: 'plugins/switchlayers/layerson3_up.png',
		srcImgOffUp: 'plugins/switchlayers/layersoff3_up.png',
		srcImgOnDown: 'plugins/switchlayers/layerson3_down.png',
		srcImgOffDown: 'plugins/switchlayers/layersoff3_down.png',
		srcImgOnMix: 'plugins/switchlayers/layerson3_mix.png',
		srcImgOffMix: 'plugins/switchlayers/layersoff3_mix.png',
		insertAfter: false,
		useAllCatStates: true,
				
		init: function() {
			this.initDefaultParams();
			this.initButtons();

			if (this.useAllCatStates) {
				this.updateButtons();

				var checkBoxGroups = $('li[id^="ligrp_"]');
				// Bind click function to groups checkboxes
				$(checkBoxGroups).click(function () {
					var idCat = $(this).parent().parent().id();
					PM.Plugin.SwitchLayers.updateCat(idCat);
				});
			}
		},

		initDefaultParams: function() {
			if (typeof(PM.ini.pluginsConfig.switchlayers) != 'undefined') {
				var pluginConfig = PM.ini.pluginsConfig.switchlayers;

				if (typeof(pluginConfig.srcImgOnUp) != 'undefined') {
					this.srcImgOnUp = pluginConfig.srcImgOnUp;
				}
				if (typeof(pluginConfig.srcImgOffUp) != 'undefined') {
					this.srcImgOffUp = pluginConfig.srcImgOffUp;
				}
				if (typeof(pluginConfig.srcImgOnDown) != 'undefined') {
					this.srcImgOnDown = pluginConfig.srcImgOnDown;
				}
				if (typeof(pluginConfig.srcImgOffDown) != 'undefined') {
					this.srcImgOffDown = pluginConfig.srcImgOffDown;
				}
				if (typeof(pluginConfig.srcImgOnMix) != 'undefined') {
					this.srcImgOnMix = pluginConfig.srcImgOnMix;
				}
				if (typeof(pluginConfig.srcImgOffMix) != 'undefined') {
					this.srcImgOffMix = pluginConfig.srcImgOffMix;
				}
				if (typeof(pluginConfig.insertAfter) != 'undefined') {
					this.insertAfter = parseInt(pluginConfig.insertAfter);
				}
				if (typeof(pluginConfig.useAllCatStates) != 'undefined') {
					this.useAllCatStates = parseInt(pluginConfig.useAllCatStates);
				}
			}
		},

		initButtons: function() {
			var checkBoxCategorie = $('li[id^="licat_"]');
			checkBoxCategorie.each(function() {
				var id = $(this).attr("id");
		
				if ($('#' + id + ' .switchlayers-OnUp, #' + id + ' .switchlayers-OffUp').length == 0
				&& $('#' + id + ' .switchlayers-OnMix, #' + id + ' .switchlayers-OffMix').length == 0) {
					var	chkOn = PM.Plugin.SwitchLayers.createLink('OnUp', id, PM.Plugin.SwitchLayers.srcImgOnUp);
					var	chkOff = PM.Plugin.SwitchLayers.createLink('OffUp', id, PM.Plugin.SwitchLayers.srcImgOffUp);
					var catSpan = $(this).children('[id^="spxg_"]');
					if (catSpan.length > 0) {
/*
						if (PM.Plugin.SwitchLayers.insertAfter) {
							catSpan.append(chkOn).append(chkOff);
						} else {
							catSpan.prepend(chkOff).prepend(chkOn);
						}
*/
						if (PM.Plugin.SwitchLayers.insertAfter) {
							catSpan.after(chkOff).after(chkOn);
						} else {
							catSpan.before(chkOn).before(chkOff);
						}
					}
				}
			});
			
		},

		createLink: function(action, id, imgsrc) {
			var cat = id.substring(id.indexOf("_") + 1);
			var text = _p('Layers ' + action);
			var link = $('<a />').attr('href', 'javascript:PM.Toc.catLayersSwitch' + action + '(\'' + id + '\')').attr('title', text);
			var img = $('<img />').attr('src', imgsrc).attr('alt', text).addClass('switchlayers-' + action);
			img.appendTo(link);
			return link;
		},
		
		updateButtons: function() {
			var checkBoxCategorie = $('li[id^="licat_"]');
			checkBoxCategorie.each(function() {
				var idCat = $(this).attr('id');
				PM.Plugin.SwitchLayers.updateCat(idCat);
			});
		},
		
		updateCat: function(idCat) {
			var groupsChecked = 0;
			var groupsUnChecked = 0;
			
			var catGroupsNb = $('#' + idCat).find('input[name="groupscbx"]').length;
			
			$('#' + idCat).find('input[name="groupscbx"]').each(function() {
				// check if group is checked
				var grpId = $(this).id();
				if ($('#' + grpId).is(':checked')) {
					groupsChecked++;
				} else {
					groupsUnChecked++;
				}
				// 1 group checked / 1 group unchecked in category
				if (groupsChecked > 0 && groupsUnChecked > 0) {
					// change categories images (mixed)
					PM.Plugin.SwitchLayers.updateLink('OnUp', idCat, PM.Plugin.SwitchLayers.srcImgOnMix, 'switchlayers-OnUp', 'switchlayers-OnMix');
					PM.Plugin.SwitchLayers.updateLink('OnDown', idCat, PM.Plugin.SwitchLayers.srcImgOnMix, 'switchlayers-OnDown', 'switchlayers-OnMix');
					PM.Plugin.SwitchLayers.updateLink('OffUp', idCat, PM.Plugin.SwitchLayers.srcImgOffMix, 'switchlayers-OffUp', 'switchlayers-OffMix');
					PM.Plugin.SwitchLayers.updateLink('OffDown', idCat, PM.Plugin.SwitchLayers.srcImgOffMix, 'switchlayers-OffDown', 'switchlayers-OffMix');
					return;
				}
			});

			if (!groupsChecked || !groupsUnChecked) {
				// all groups are checked or unchecked in the category => change images On/Off
				
				if (groupsChecked == catGroupsNb) {
					this.updateLink('OnMix', idCat, this.srcImgOnDown, 'switchlayers-OnMix', 'switchlayers-OnDown');
					this.updateLink('OnUp', idCat, this.srcImgOnDown, 'switchlayers-OnUp', 'switchlayers-OnDown');
					this.updateLink('OffMix', idCat, this.srcImgOffUp, 'switchlayers-OnMix', 'switchlayers-OffUp');
					this.updateLink('OffDown', idCat, this.srcImgOffUp, 'switchlayers-OffDown', 'switchlayers-OffUp');
				} else if (groupsUnChecked == catGroupsNb) {
					this.updateLink('OffMix', idCat, this.srcImgOffDown, 'switchlayers-OffMix', 'switchlayers-OffDown');
					this.updateLink('OffUp', idCat, this.srcImgOffDown, 'switchlayers-OffUp', 'switchlayers-OffDown');
					this.updateLink('OnMix', idCat, this.srcImgOnUp, 'switchlayers-OnMix', 'switchlayers-OnUp');
					this.updateLink('OnDown', idCat, this.srcImgOnUp, 'switchlayers-OnDown', 'switchlayers-OnUp');
				}
			}
		},

		updateLink: function(action, idCat, srcImg, classToRemove, classToAdd) {
			$('#' + idCat + ' > a > img').each(function() {
				if ($(this).hasClass('switchlayers-'+ action)) {
					$(this).attr('src', srcImg);
					$(this).removeClass(classToRemove).addClass(classToAdd);
				}
			});
		}
	}
});

$.extend(PM.Toc, {

	catLayersSwitchOnUp: function(cat) {
		this.catLayersSwitch(cat, 'on');
		if (PM.Plugin.SwitchLayers.useAllCatStates) {
			PM.Plugin.SwitchLayers.updateCat(cat);
		}
	},

	catLayersSwitchOffUp: function(cat) {
		this.catLayersSwitch(cat, 'off');
		if (PM.Plugin.SwitchLayers.useAllCatStates) {
			PM.Plugin.SwitchLayers.updateCat(cat);
		}
	},

	catLayersSwitchOn: function(cat) {
		this.catLayersSwitchOnUp(cat);
	},

	catLayersSwitchOff: function(cat) {
		this.catLayersSwitchOffUp(cat);
	}
});
