$.extend(PM.Plugin, 
{
	TocActionMenu : 
	{
		menuGrpObj: false,
		hideTocContextMenu: false,
		bHide: true,
		hideTimer: false,
		
		init : function() {
			if (typeof(PM.ini.pluginsConfig.tocActionMenu) != 'undefined') {
				var pluginConfig = PM.ini.pluginsConfig.tocActionMenu;
				
				if (typeof(pluginConfig.hideTocContextMenu) != 'undefined') {
					this.hideTocContextMenu = parseInt(pluginConfig.hideTocContextMenu);
				}
			}
			
			if (PM.contextMenuList) {
				$.each(PM.contextMenuList, function() {
					if (this.bindto == "li.tocgrp") {
						PM.Plugin.TocActionMenu.menuGrpObj = this;
					}
				});
			}
		},
		
		addMenuLinks: function() {
			//Delete existing menu on right click
			if (this.hideTocContextMenu) {
				$('li.toccat').unbind('contextmenu');
				$('li.tocgrp').unbind('contextmenu');
			}
			
			if (this.menuGrpObj !== false) {
				$('#toc').find('.grp-title').each(function() {
					if ($(this).parent().parent().find('.tocMenuBtn').length == 0) {
		                grpName = $(this).parent().id().replace(/spxg_/, '');
		                
		                var menuBtn = $('<span><img class="tocMenuImg" src="' + PM_PLUGIN_LOCATION + '/tocActionMenu/images/tocActionMenu.png"></img></span>').addClass('tocMenuBtn');
		                menuBtn.data('grpName', grpName);
		                menuBtn.click(function(){
		                	var bCreate = true;
		                	
		                	if ($('.tocMenuPnl').length > 0) {
		                		if ($('.tocMenuPnl').data('grpName') == $(this).data('grpName')) {
		                			bCreate = false;
		                		}
		                		$('.tocMenuPnl').slideUp('fast');
		                		$('.tocMenuBtn-on').removeClass('tocMenuBtn-on');
		                		$('.tocMenuPnl').remove();
		                	}
		                	
		                	if (bCreate) {
			                	var menuPnl = $('<ul></ul>').addClass('tocMenuPnl').hide();
			                	var pos = $(this).parent().offset();
			                    var groupName = $(this).data('grpName');
			                	
			                	menuPnl.css('left', pos.left);	
			                	menuPnl.css('width', $(this).parent().outerWidth());
			                	menuPnl.data('grpName', groupName);
			                	
			                	$.each(PM.Plugin.TocActionMenu.menuGrpObj.menulist, function() {
									menuPnl.append(PM.Plugin.TocActionMenu.createMenuItem(_p(this.text), this.run + '(\'' + groupName + '\')', 'images/menus/' + this.imgsrc));
				                });
			                	
			                	
			                	$('body').append(menuPnl);
			                	
			                	if (pos.top + $(this).parent().outerHeight() + menuPnl.outerHeight() > $(window).height()) {
			                		menuPnl.css('top', pos.top - menuPnl.height());
			                	} else {
			                		menuPnl.css('top', pos.top + $(this).parent().outerHeight());
			                	}
			                	
			                	$(this).find('.tocMenuImg').addClass('tocMenuBtn-on');
			                	menuPnl.slideDown('fast');	
			                	
			                	menuPnl.hover(function(){
			                		PM.Plugin.TocActionMenu.bHide = false;
			                        clearTimeout(PM.Plugin.TocActionMenu.hideTimer);
			                	}, function(){
									$(this).slideUp('fast');
									$('.tocMenuBtn-on').removeClass('tocMenuBtn-on');
									$(this).remove();
								});
		                	}
		                });
		                
		                $(this).parent().parent().hover(function(){}, function(){
		                	PM.Plugin.TocActionMenu.bHide = true;
		                	PM.Plugin.TocActionMenu.hideTimer = setTimeout(function() {
		                		if ($('.tocMenuPnl').length > 0 && PM.Plugin.TocActionMenu.bHide) {
		                    		$('.tocMenuPnl').slideUp('fast');
		                    		$('.tocMenuBtn-on').removeClass('tocMenuBtn-on');
		                    		$('.tocMenuPnl').remove();
		                    		PM.Plugin.TocActionMenu.bHide = true;
		                    	}
							}, 100);
		                });
		                
		                $(this).parent().parent().append(menuBtn);
					}
	            });
			}
		},
		
		createMenuItem: function(title, link, imgUrl) {
			var img = '';
			
			var menuItem = $('<li></li>');
			
			if (typeof(imgUrl) != 'undefined' && imgUrl != '') {
				img = '<img src="' + imgUrl + '"/>';
			}
			
			var tab = '<table><tr><td class="menuItemImg">' + img + '</img></td><td class="menuItemTitle">' + title + '</td></tr></table>';
			menuItem.html(tab);
			
			if (typeof(link) != 'undefined' && link != '') {
				menuItem.click(function(){
					eval(link);
				});
			}
			
			return menuItem;
		}
	}
});
