<?php

/******************************************************************************
 *
 * Purpose: set all groups transparency
 * Author:  Christophe Arioli, SIRAP
 *
 *****************************************************************************
 *
 * Copyright (c) 2011 SIRAP
 *
 * p.mapper is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the COPYING file.
 *
 * p.mapper is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with p.mapper; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/

include_once('../transparency/transparency.inc');

$session_grouplist = $_SESSION['grouplist'];
$session_groups = $_SESSION['groups'];

$reload = false;

foreach ($_REQUEST as $requestKey => $requestVal) {	
	if (in_array($requestKey, $session_groups)) {		
		$group_name = $requestKey;
		$default_transparency = $requestVal;
		
		$opacity = 100 - $default_transparency;
		$reload = 1;
		
		$grp = $session_grouplist[$group_name];
		$glayerList = $grp->getLayers();
		foreach ($glayerList as $glayer) {
		    $glayer->setOpacity($opacity);
		}		
	}
}

header("Content-Type: text/plain");
echo "{\"reload\":$reload}";
?>