var layers = [
  new ol.layer.Tile({
    style: 'Road',
    source: new ol.source.MapQuest({layer: 'osm'})
  }),
  new ol.layer.Tile({
    style: 'Aerial',
    visible: false,
    source: new ol.source.MapQuest({layer: 'sat'})
  }),
  new ol.layer.Group({
    style: 'AerialWithLabels',
    visible: false,
    layers: [
      new ol.layer.Tile({
        source: new ol.source.MapQuest({layer: 'sat'})
      }),
      new ol.layer.Tile({
        source: new ol.source.MapQuest({layer: 'hyb'})
      })
    ]
  })
];

var map = new ol.Map({
  layers: layers,
  renderer: common.getRendererFromQueryString(),
  target: 'map',
  view: new ol.View({
    center: ol.proj.transform(
        [-73.979378, 40.702222], 'EPSG:4326', 'EPSG:3857'),
    zoom: 9
  })
});

var select = document.getElementById('layer-select');

function onChange() {
  var style = select.value;
  var i, ii;
  for (i = 0, ii = layers.length; i < ii; ++i) {
    layers[i].set('visible', (layers[i].get('style') == style));
  }
}

select.addEventListener('change', onChange);

onChange();
